/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.archetype;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NFetchCmd;
import net.thevpc.nuts.core.NAddRepositoryOptions;
import net.thevpc.nuts.core.NIsolationLevel;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.repository.NRepositorySelectorHelper;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceUtils;
import net.thevpc.nuts.security.NWorkspaceSecurityManager;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NRepositoryDB;
import net.thevpc.nuts.spi.NRepositoryLocation;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.spi.NWorkspaceArchetypeComponent;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStringUtils;

@NComponentScope(value=NScopeType.WORKSPACE)
public class DefaultNWorkspaceArchetypeComponent
implements NWorkspaceArchetypeComponent {
    @Override
    public String getName() {
        return "default";
    }

    private String defaultRepoDiscriminator(NAddRepositoryOptions d) {
        NPath repositoriesRoot = NWorkspaceExt.of().getConfigModel().getRepositoriesRoot();
        if (d.getConfig() != null && d.getConfig().getLocation() != null && d.getConfig().getLocation().getPath() != null) {
            return NPath.of(d.getConfig().getLocation().getPath()).toAbsolute(repositoriesRoot).toString();
        }
        if (!NBlankable.isBlank(d.getLocation())) {
            return NPath.of(d.getLocation()).toAbsolute(repositoriesRoot).toString();
        }
        if (!NBlankable.isBlank(d.getName())) {
            return NPath.of(d.getName()).toAbsolute(repositoriesRoot).toString();
        }
        if (d.getRepositoryModel() != null) {
            String n = NAssert.requireNonBlank(NStringUtils.firstNonBlank(d.getRepositoryModel().getName(), d.getRepositoryModel().getUuid()), "RepositoryModel name");
            return NPath.of(n).toAbsolute(NWorkspaceExt.of().getConfigModel().getRepositoriesRoot()).toString();
        }
        throw new NIllegalArgumentException(NMsg.ofC("unable to load default repository location: %s", d.getLocation()));
    }

    @Override
    public void initializeWorkspace() {
        NRepositoryLocation[] br;
        LinkedHashMap<String, NAddRepositoryOptions> def = new LinkedHashMap<String, NAddRepositoryOptions>();
        ArrayList<NRepositoryLocation> defaults = new ArrayList<NRepositoryLocation>();
        NWorkspace workspace = NWorkspace.of();
        for (NAddRepositoryOptions d : workspace.getDefaultRepositories()) {
            String discriminator = this.defaultRepoDiscriminator(d);
            String name = d.getName();
            if (NBlankable.isBlank(name)) {
                if (d.getConfig() != null && !NBlankable.isBlank(d.getConfig().getName())) {
                    name = d.getConfig().getName();
                } else if (d.getRepositoryModel() != null) {
                    name = NAssert.requireNonBlank(NStringUtils.firstNonBlank(d.getRepositoryModel().getName(), d.getRepositoryModel().getUuid()), "RepositoryModel name");
                } else {
                    throw new NIllegalArgumentException(NMsg.ofC("unable to load default repository location: %s", d.getLocation()));
                }
                d.setName(name);
            }
            def.put(discriminator, d);
            defaults.add(NRepositoryLocation.of(d.getName(), (String)null));
        }
        NWorkspaceExt.of().getModel().configModel.getStoredConfigMain().setEnablePreviewRepositories(NSession.of().isPreviewRepo());
        NWorkspaceExt.of().getModel().configModel.invalidateStoreModelMain();
        defaults.add(NRepositoryLocation.ofName("local"));
        for (NRepositoryLocation s : br = NWorkspaceExt.of().getConfigModel().resolveBootRepositoriesList().resolve(defaults.toArray(new NRepositoryLocation[0]), NRepositoryDB.of())) {
            NAddRepositoryOptions oo = NRepositorySelectorHelper.createRepositoryOptions(s, false);
            String sloc = this.defaultRepoDiscriminator(oo);
            if (def.containsKey(sloc)) {
                NRepository nr;
                NAddRepositoryOptions r = ((NAddRepositoryOptions)def.get(sloc)).copy();
                if (!NBlankable.isBlank(s.getName())) {
                    r.setName(oo.getName());
                }
                if ("system".equals((nr = workspace.addRepository(r)).getName()) && "system".equals(nr.config().getGlobalName()) && (nr.config().getLocationPath() == null || !nr.config().getLocationPath().isDirectory())) {
                    nr.setEnabled(false);
                }
                def.remove(sloc);
                continue;
            }
            workspace.addRepository(oo);
        }
        workspace.addImports("net.thevpc");
        NWorkspaceSecurityManager.of().updateUser("anonymous").resetPermissions().run();
        NWorkspaceSecurityManager.of().addUser("user").setCredentials("user".toCharArray()).addPermissions("fetch-desc", "fetch-content", "deploy", "undeploy", "push", "save").setRemoteIdentity("contributor").run();
    }

    @Override
    public void startWorkspace() {
        NId api;
        NWorkspace workspace = NWorkspace.of();
        NIsolationLevel nIsolationLevel = workspace.getBootOptions().getIsolationLevel().orNull();
        if (nIsolationLevel == NIsolationLevel.MEMORY) {
            return;
        }
        boolean isolated = nIsolationLevel != null && nIsolationLevel.ordinal() >= NIsolationLevel.CONFINED.ordinal();
        boolean initializeScripts = workspace.getBootOptions().getInitScripts().orElse(!isolated);
        boolean initializeLaunchers = workspace.getBootOptions().getInitLaunchers().orElse(!isolated);
        boolean installCompanions = workspace.getBootOptions().getInstallCompanions().orElse(false);
        if ((initializeScripts || initializeLaunchers || installCompanions) && (api = NFetchCmd.of().setId(workspace.getApiId()).setDependencyFilter(NDependencyFilters.of().byRunnable()).setFailFast(false).getResultId()) != null) {
            if (initializeScripts || initializeLaunchers) {
                NWorkspaceUtils.of(workspace).installScriptsAndLaunchers(initializeLaunchers);
            }
            if (installCompanions && api != null) {
                NWorkspaceUtils.of(workspace).installCompanions();
            }
        }
    }

    @Override
    public int getScore(NScorableContext criteria) {
        return 12;
    }
}

