/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdBuilder;
import net.thevpc.nuts.command.NFetchMode;
import net.thevpc.nuts.command.NFetchStrategy;
import net.thevpc.nuts.command.NInstallCmd;
import net.thevpc.nuts.command.NInstallEvent;
import net.thevpc.nuts.command.NInstallListener;
import net.thevpc.nuts.command.NUpdateEvent;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NRepositoryAlreadyRegisteredException;
import net.thevpc.nuts.core.NRepositoryFilter;
import net.thevpc.nuts.core.NRepositoryFilters;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NSpeedQualifier;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.core.NWorkspaceEvent;
import net.thevpc.nuts.core.NWorkspaceListener;
import net.thevpc.nuts.ext.NExtensions;
import net.thevpc.nuts.io.NOut;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.platform.NLauncherOptions;
import net.thevpc.nuts.platform.NPlatformFamily;
import net.thevpc.nuts.platform.NPlatformHome;
import net.thevpc.nuts.platform.NPlatformLocation;
import net.thevpc.nuts.reflect.NReflectConfigurationBuilder;
import net.thevpc.nuts.reflect.NReflectPropertyAccessStrategy;
import net.thevpc.nuts.reflect.NReflectPropertyDefaultValueStrategy;
import net.thevpc.nuts.reflect.NReflectRepository;
import net.thevpc.nuts.runtime.standalone.format.NFetchDisplayOptions;
import net.thevpc.nuts.runtime.standalone.format.NPrintIterator;
import net.thevpc.nuts.runtime.standalone.reflect.DefaultNReflectRepository;
import net.thevpc.nuts.runtime.standalone.repository.NRepositoryHelper;
import net.thevpc.nuts.runtime.standalone.repository.cmd.NRepositorySupportedAction;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.NInstalledRepository;
import net.thevpc.nuts.runtime.standalone.util.jclass.NJavaSdkUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.NRepositoryAndFetchMode;
import net.thevpc.nuts.spi.NRepositorySPI;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NReadOnlyException;
import net.thevpc.nuts.util.NSupportMode;

public class NWorkspaceUtils {
    private final NWorkspace workspace;

    private NWorkspaceUtils(NWorkspace workspace) {
        this.workspace = workspace;
    }

    public static NWorkspaceUtils of() {
        return NWorkspaceUtils.of(NWorkspace.of());
    }

    public static NWorkspaceUtils of(NWorkspace workspace) {
        return new NWorkspaceUtils(workspace);
    }

    public static NSession bindSession(NWorkspace ws, NSession session) {
        if (ws != null && session != null && !Objects.equals(session.getWorkspace().getUuid(), ws.getUuid())) {
            return ws.createSession().copyFrom(session);
        }
        return session;
    }

    public static boolean isUserDefaultWorkspace() {
        String defaultWorkspaceLocation = NPlatformHome.USER.getWorkspaceLocation(null);
        NPath location = NWorkspace.of().getLocation();
        return location != null && defaultWorkspaceLocation.equals(location.toString());
    }

    protected NLog _LOG() {
        return NLog.of(NWorkspaceUtils.class);
    }

    public NRepositorySPI toRepositorySPI(NRepository repo) {
        return NWorkspaceExt.of().getRepositoryModel().toRepositorySPI(repo);
    }

    public NReflectRepository getReflectRepository() {
        NReflectRepository o = (NReflectRepository)this.workspace.getProperties().get(NReflectRepository.class.getName());
        if (o == null) {
            o = new DefaultNReflectRepository(NReflectConfigurationBuilder.of().setPropertyAccessStrategy(NReflectPropertyAccessStrategy.FIELD).setPropertyDefaultValueStrategy(NReflectPropertyDefaultValueStrategy.PROPERTY_DEFAULT).build());
            this.workspace.setProperty(NReflectRepository.class.getName(), o);
        }
        return o;
    }

    public NId createSdkId(String type, String version) {
        NAssert.requireNonBlank(type, "sdk type");
        NAssert.requireNonBlank(version, "version");
        if ("java".equalsIgnoreCase(type)) {
            return NJavaSdkUtils.of(this.workspace).createJdkId(version);
        }
        return NIdBuilder.of().setArtifactId(type).setVersion(version).build();
    }

    public void checkReadOnly() {
        if (NWorkspace.of().isReadOnly()) {
            throw new NReadOnlyException(NWorkspace.of().getWorkspaceLocation().toString());
        }
    }

    public NId configureFetchEnv(NId id) {
        Map<String, String> qm = id.getProperties();
        if (qm.get("face") == null && qm.get("arch") == null && qm.get("os") == null && qm.get("osdist") == null && qm.get("platform") == null && qm.get("desktop") == null) {
            qm.put("arch", this.workspace.getArchFamily().id());
            qm.put("os", this.workspace.getOs().toString());
            if (this.workspace.getOsDist() != null) {
                qm.put("osdist", this.workspace.getOsDist().toString());
            }
            if (this.workspace.getPlatform() != null) {
                qm.put("platform", this.workspace.getPlatform().toString());
            }
            if (this.workspace.getDesktopEnvironment() != null) {
                qm.put("desktop", this.workspace.getDesktopEnvironment().toString());
            }
            return id.builder().setProperties(qm).build();
        }
        return id;
    }

    public List<NRepository> filterRepositoriesDeploy(NId id, NRepositoryFilter repositoryFilter) {
        NRepositoryFilter f = NRepositoryFilters.of().installedRepo().neg().and(repositoryFilter);
        return this.filterRepositories(NRepositorySupportedAction.DEPLOY, id, f, NFetchMode.LOCAL);
    }

    public List<NRepositoryAndFetchMode> filterRepositoryAndFetchModes(NRepositorySupportedAction fmode, NId id, NRepositoryFilter repositoryFilter, NFetchStrategy fetchStrategy) {
        ArrayList<NRepositoryAndFetchMode> ok = new ArrayList<NRepositoryAndFetchMode>();
        for (NFetchMode nutsFetchMode : fetchStrategy) {
            for (NRepository nRepositoryAndFetchMode : this.filterRepositories(fmode, id, repositoryFilter, nutsFetchMode)) {
                ok.add(new NRepositoryAndFetchMode(nRepositoryAndFetchMode, nutsFetchMode));
            }
        }
        return ok;
    }

    private List<NRepository> filterRepositories(NRepositorySupportedAction fmode, NId id, NRepositoryFilter repositoryFilter, NFetchMode mode) {
        return this.filterRepositories(fmode, id, repositoryFilter, true, null, mode);
    }

    private List<NRepository> filterRepositories(NRepositorySupportedAction fmode, NId id, NRepositoryFilter repositoryFilter, boolean sortByLevelDesc, Comparator<NRepository> postComp, NFetchMode mode) {
        ArrayList<RepoAndLevel> repos2 = new ArrayList<RepoAndLevel>();
        NSession session = this.workspace.currentSession();
        for (NRepository repository : this.workspace.getRepositories()) {
            if (!repository.isEnabled() || fmode != NRepositorySupportedAction.SEARCH && !repository.isSupportedDeploy() || !this.toRepositorySPI(repository).isAcceptFetchMode(mode) || repositoryFilter != null && !repositoryFilter.acceptRepository(repository)) continue;
            int d = 0;
            if (fmode == NRepositorySupportedAction.DEPLOY) {
                try {
                    d = NRepositoryHelper.getSupportDeployLevel(repository, fmode, id, mode, session.isTransitive());
                }
                catch (Exception ex) {
                    this._LOG().log(NMsg.ofJ("unable to resolve support deploy level for : {0}", repository.getName()).asFinestFail(ex));
                }
            }
            NSpeedQualifier t = NSpeedQualifier.NORMAL;
            try {
                t = NRepositoryHelper.getSupportSpeedLevel(repository, fmode, id, mode, session.isTransitive());
            }
            catch (Exception ex) {
                this._LOG().log(NMsg.ofJ("unable to resolve support speed level for : {0}", repository.getName()).asFineFail(ex));
            }
            if (t == NSpeedQualifier.UNAVAILABLE) continue;
            repos2.add(new RepoAndLevel(repository, d, t, postComp));
        }
        if (sortByLevelDesc || postComp != null) {
            Collections.sort(repos2);
        }
        ArrayList<NRepository> ret = new ArrayList<NRepository>();
        NInstalledRepository installedRepository = NWorkspaceExt.of().getInstalledRepository();
        if (mode == NFetchMode.LOCAL && fmode == NRepositorySupportedAction.SEARCH && (repositoryFilter == null || repositoryFilter.acceptRepository(installedRepository))) {
            ret.add(installedRepository);
        }
        for (RepoAndLevel repoAndLevel : repos2) {
            ret.add(repoAndLevel.r);
        }
        return ret;
    }

    public void validateRepositoryName(String repositoryName, Set<String> registered) {
        if (!repositoryName.matches("[a-zA-Z][.a-zA-Z0-9_-]*")) {
            throw new NIllegalArgumentException(NMsg.ofC("invalid repository id %s", repositoryName));
        }
        if (registered.contains(repositoryName)) {
            throw new NRepositoryAlreadyRegisteredException(repositoryName);
        }
    }

    public <T> NIterator<T> decoratePrint(NIterator<T> it, NFetchDisplayOptions displayOptions) {
        return new NPrintIterator<T>(it, this.workspace, NOut.out(), displayOptions);
    }

    public Events events() {
        return new Events(this);
    }

    public void installAllJVM() {
        block10: {
            NSession session = this.workspace.currentSession();
            try {
                if (session.isPlainTrace()) {
                    NOut.resetLine().println("looking for java installations in default locations...");
                }
                List<NPlatformLocation> found = this.workspace.searchSystemPlatforms(NPlatformFamily.JAVA).toList();
                int someAdded = 0;
                for (NPlatformLocation java : found) {
                    if (!this.workspace.addPlatform(java)) continue;
                    ++someAdded;
                }
                if (session.isPlainTrace()) {
                    if (someAdded == 0) {
                        NOut.println(NMsg.ofC("%s java installation locations found...", NMsg.ofStyledError("no new")));
                    } else if (someAdded == 1) {
                        NOut.println(NMsg.ofC("%s new java installation location added...", NMsg.ofStyledPrimary2("1")));
                    } else {
                        NOut.println(NMsg.ofC("%s new java installation locations added...", NMsg.ofStyledPrimary2("" + someAdded)));
                    }
                    NOut.println("you can always add another installation manually using 'nuts settings add java' command.");
                }
                if (!this.workspace.isReadOnly()) {
                    this.workspace.saveConfig();
                }
            }
            catch (Exception ex) {
                this._LOG().log(NMsg.ofJ("unable to resolve default JRE/JDK locations : {0}", ex).asFinestAlert(ex));
                if (!session.isPlainTrace()) break block10;
                NPrintStream out = session.out();
                out.resetLine();
                out.println(NMsg.ofC("%s :  %s", NMsg.ofStyledError("unable to resolve default JRE/JDK locations"), ex));
            }
        }
    }

    public void installCurrentJVM() {
        block8: {
            NSession session = this.workspace.currentSession();
            try {
                NPlatformLocation[] nPlatformLocationArray;
                NPlatformLocation found0;
                if (session.isPlainTrace()) {
                    NOut.resetLine().println("configuring current JVM...");
                }
                if ((found0 = this.workspace.resolvePlatform(NPlatformFamily.JAVA, NPath.of(System.getProperty("java.home")), null).orNull()) == null) {
                    nPlatformLocationArray = new NPlatformLocation[]{};
                } else {
                    NPlatformLocation[] nPlatformLocationArray2 = new NPlatformLocation[1];
                    nPlatformLocationArray = nPlatformLocationArray2;
                    nPlatformLocationArray2[0] = found0;
                }
                NPlatformLocation[] found = nPlatformLocationArray;
                int someAdded = 0;
                for (NPlatformLocation java : found) {
                    if (!this.workspace.addPlatform(java)) continue;
                    ++someAdded;
                }
                if (session.isPlainTrace() && someAdded == 0) {
                    NOut.println(NMsg.ofC("%s java installation locations found...", NMsg.ofStyledError("no new")));
                }
                if (!this.workspace.isReadOnly()) {
                    this.workspace.saveConfig();
                }
            }
            catch (Exception ex) {
                this._LOG().log(NMsg.ofJ("unable to resolve default JRE/JDK locations : {0}", ex).asFineAlert(ex));
                if (!session.isPlainTrace()) break block8;
                NPrintStream out = session.out();
                out.resetLine().println(NMsg.ofC("Ms :  %s", NMsg.ofStyledError("unable to resolve default JRE/JDK locations"), ex));
            }
        }
    }

    public void installScriptsAndLaunchers(boolean includeGraphicalLaunchers) {
        block2: {
            NSession session = this.workspace.currentSession();
            try {
                this.workspace.addLauncher(new NLauncherOptions().setId(session.getWorkspace().getApiId()).setCreateScript(true).setSwitchWorkspace(NWorkspace.of().getBootOptions().getSwitchWorkspace().orNull()).setCreateDesktopLauncher(includeGraphicalLaunchers ? NSupportMode.PREFERRED : NSupportMode.NEVER).setCreateMenuLauncher(includeGraphicalLaunchers ? NSupportMode.SUPPORTED : NSupportMode.NEVER));
            }
            catch (Exception ex) {
                this._LOG().log(NMsg.ofJ("unable to install desktop launchers : {0}", ex).asFineAlert(ex));
                if (!session.isPlainTrace()) break block2;
                NPrintStream out = session.out();
                out.resetLine().println(NMsg.ofC("%s :  %s", NMsg.ofStyledError("unable to install desktop launchers"), ex));
            }
        }
    }

    public void installCompanions() {
        block4: {
            NSession session = this.workspace.currentSession();
            NTexts text = NTexts.of();
            Set<NId> companionIds = NExtensions.of().getCompanionIds();
            if (companionIds.isEmpty()) {
                return;
            }
            if (session.isPlainTrace()) {
                NPrintStream out = session.out();
                out.resetLine().println(NMsg.ofC("looking for recommended companion tools to install... detected : %s", text.ofBuilder().appendJoined(text.ofPlain(","), companionIds)));
            }
            try {
                NInstallCmd.of().companions().run();
            }
            catch (Exception ex) {
                this._LOG().log(NMsg.ofJ("unable to install companions : {0}", ex).asFineAlert(ex));
                if (!session.isPlainTrace()) break block4;
                NPrintStream out = session.out();
                out.resetLine().println(NMsg.ofC("%s :  %s this happens when none of the following repositories are able to locate them : %s\n", NMsg.ofStyledError("unable to install companion tools"), ex, text.ofBuilder().appendJoined(text.ofPlain(", "), this.workspace.getRepositories().stream().map(x -> text.ofBuilder().append((Object)x.getName(), NTextStyle.primary3())).collect(Collectors.toList()))));
            }
        }
    }

    private static class RepoAndLevel
    implements Comparable<RepoAndLevel> {
        NRepository r;
        int deployWeight;
        NSpeedQualifier speed;
        Comparator<NRepository> postComp;

        public RepoAndLevel(NRepository r, int deployWeight, NSpeedQualifier speed, Comparator<NRepository> postComp) {
            this.r = r;
            this.deployWeight = deployWeight;
            this.speed = speed;
            this.postComp = postComp;
        }

        @Override
        public int compareTo(RepoAndLevel o2) {
            int x = Integer.compare(this.deployWeight, o2.deployWeight);
            if (x != 0) {
                return x;
            }
            x = Integer.compare(o2.speed.ordinal(), this.speed.ordinal());
            if (x != 0) {
                return x;
            }
            if (this.postComp != null) {
                x = this.postComp.compare(this.r, o2.r);
            }
            return x;
        }
    }

    public static class Events {
        private final NWorkspaceUtils u;

        public Events(NWorkspaceUtils u) {
            this.u = u;
        }

        public void fireOnInstall(NInstallEvent event) {
            this.u._LOG().log(NMsg.ofJ("installed {0}", event.getDefinition().getId()).withLevel(Level.FINEST).withIntent(NMsgIntent.ADD));
            for (NInstallListener listener : event.getWorkspace().getInstallListeners()) {
                listener.onInstall(event);
            }
            for (NInstallListener listener : event.getSession().getListeners(NInstallListener.class)) {
                listener.onInstall(event);
            }
        }

        public void fireOnRequire(NInstallEvent event) {
            this.u._LOG().log(NMsg.ofJ("required {0}", event.getDefinition().getId()).withLevel(Level.FINEST).withIntent(NMsgIntent.ADD));
            for (NInstallListener listener : event.getWorkspace().getInstallListeners()) {
                listener.onRequire(event);
            }
            for (NInstallListener listener : event.getSession().getListeners(NInstallListener.class)) {
                listener.onRequire(event);
            }
        }

        public void fireOnUpdate(NUpdateEvent event) {
            if (this.u._LOG().isLoggable(Level.FINEST)) {
                if (event.getOldValue() == null) {
                    this.u._LOG().log(NMsg.ofJ("updated {0}", event.getNewValue().getId()).withLevel(Level.FINEST).withIntent(NMsgIntent.UPDATE));
                } else {
                    this.u._LOG().log(NMsg.ofJ("updated {0} (old is {1})", event.getOldValue().getId().getLongId(), event.getNewValue().getId().getLongId()).withLevel(Level.FINEST).withIntent(NMsgIntent.UPDATE));
                }
            }
            for (NInstallListener listener : event.getWorkspace().getInstallListeners()) {
                listener.onUpdate(event);
            }
            for (NInstallListener listener : event.getSession().getListeners(NInstallListener.class)) {
                listener.onUpdate(event);
            }
        }

        public void fireOnUninstall(NInstallEvent event) {
            if (this.u._LOG().isLoggable(Level.FINEST)) {
                this.u._LOG().log(NMsg.ofJ("uninstalled {0}", event.getDefinition().getId()).withLevel(Level.FINEST).withIntent(NMsgIntent.REMOVE));
            }
            for (NInstallListener listener : event.getWorkspace().getInstallListeners()) {
                listener.onUninstall(event);
            }
            for (NInstallListener listener : event.getSession().getListeners(NInstallListener.class)) {
                listener.onUninstall(event);
            }
        }

        public void fireOnAddRepository(NWorkspaceEvent event) {
            if (this.u._LOG().isLoggable(Level.CONFIG)) {
                this.u._LOG().log(NMsg.ofJ("loaded repo ##{0}##", event.getRepository().getName()).withLevel(Level.CONFIG).withIntent(NMsgIntent.ADD));
            }
            for (NWorkspaceListener listener : event.getWorkspace().getWorkspaceListeners()) {
                listener.onAddRepository(event);
            }
            for (NWorkspaceListener listener : event.getSession().getListeners(NWorkspaceListener.class)) {
                listener.onAddRepository(event);
            }
        }

        public void fireOnRemoveRepository(NWorkspaceEvent event) {
            if (this.u._LOG().isLoggable(Level.FINEST)) {
                this.u._LOG().log(NMsg.ofJ("unloaded repo ##{0}##", event.getRepository().getName()).withLevel(Level.FINEST).withIntent(NMsgIntent.REMOVE));
            }
            for (NWorkspaceListener listener : event.getWorkspace().getWorkspaceListeners()) {
                listener.onRemoveRepository(event);
            }
            for (NWorkspaceListener listener : event.getSession().getListeners(NWorkspaceListener.class)) {
                listener.onRemoveRepository(event);
            }
        }
    }
}

