/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace;

import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.command.NFetchStrategy;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NRepositoryFilter;

public class NWorkspaceHelper {
    public static NFetchStrategy validate(NFetchStrategy mode) {
        return mode == null ? NFetchStrategy.ONLINE : mode;
    }

    public static List<NRepository> _getEnabledRepositories(NRepository parent, NRepositoryFilter repositoryFilter) {
        ArrayList<NRepository> repos = new ArrayList<NRepository>();
        if (parent.config().isSupportedMirroring()) {
            ArrayList<NRepository> subrepos = new ArrayList<NRepository>();
            boolean ok = false;
            for (NRepository repository : parent.config().getMirrors()) {
                if (!repository.isEnabled()) continue;
                if (repositoryFilter == null || repositoryFilter.acceptRepository(repository)) {
                    repos.add(repository);
                    ok = true;
                }
                if (ok) continue;
                subrepos.add(repository);
            }
            for (NRepository subrepo : subrepos) {
                repos.addAll(NWorkspaceHelper._getEnabledRepositories(subrepo, repositoryFilter));
            }
        }
        return repos;
    }
}

