/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace;

import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.thevpc.nuts.app.NApp;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdFormat;
import net.thevpc.nuts.command.NExecCmd;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.elem.NElementNotFoundException;
import net.thevpc.nuts.ext.NFactoryException;
import net.thevpc.nuts.internal.rpi.NCollectionsRPI;
import net.thevpc.nuts.internal.rpi.NIORPI;
import net.thevpc.nuts.io.NDigest;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.net.NWebCli;
import net.thevpc.nuts.runtime.standalone.DefaultNBootOptionsBuilder;
import net.thevpc.nuts.runtime.standalone.DefaultNDependencyBuilder;
import net.thevpc.nuts.runtime.standalone.DefaultNDescriptorBuilder;
import net.thevpc.nuts.runtime.standalone.DefaultNEnvConditionBuilder;
import net.thevpc.nuts.runtime.standalone.DefaultNIdBuilder;
import net.thevpc.nuts.runtime.standalone.DefaultNWorkspaceOptionsBuilder;
import net.thevpc.nuts.runtime.standalone.app.NAppImpl;
import net.thevpc.nuts.runtime.standalone.concurrent.NConcurrentImpl;
import net.thevpc.nuts.runtime.standalone.elem.DefaultNElementFactory;
import net.thevpc.nuts.runtime.standalone.elem.DefaultNElements;
import net.thevpc.nuts.runtime.standalone.elem.parser.DefaultNElementParser;
import net.thevpc.nuts.runtime.standalone.elem.writer.DefaultNElementWriter;
import net.thevpc.nuts.runtime.standalone.format.DefaultNObjectFormat;
import net.thevpc.nuts.runtime.standalone.format.NFormatsImpl;
import net.thevpc.nuts.runtime.standalone.id.format.DefaultNIdFormat;
import net.thevpc.nuts.runtime.standalone.io.inputstream.DefaultNIO;
import net.thevpc.nuts.runtime.standalone.io.inputstream.DefaultNIORPI;
import net.thevpc.nuts.runtime.standalone.log.DefaultNLogs;
import net.thevpc.nuts.runtime.standalone.session.DefaultNSession;
import net.thevpc.nuts.runtime.standalone.text.DefaultNTexts;
import net.thevpc.nuts.runtime.standalone.util.CoreNUtils;
import net.thevpc.nuts.runtime.standalone.util.NPropertiesHolder;
import net.thevpc.nuts.runtime.standalone.util.NScorableNScorableQueryImpl;
import net.thevpc.nuts.runtime.standalone.util.NUtilSPIImpl;
import net.thevpc.nuts.runtime.standalone.util.stream.DefaultNCollectionsRPI;
import net.thevpc.nuts.runtime.standalone.version.format.DefaultNVersionFormat;
import net.thevpc.nuts.runtime.standalone.workspace.DefaultNWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.IdCache;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceFactory;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.DefaultNExecCmd;
import net.thevpc.nuts.runtime.standalone.workspace.factorycache.CachedConstructor;
import net.thevpc.nuts.runtime.standalone.workspace.factorycache.NBeanCache;
import net.thevpc.nuts.runtime.standalone.xtra.digest.DefaultNDigest;
import net.thevpc.nuts.runtime.standalone.xtra.execentries.DefaultNLibPaths;
import net.thevpc.nuts.runtime.standalone.xtra.expr.DefaultNExprs;
import net.thevpc.nuts.runtime.standalone.xtra.web.DefaultNWebCli;
import net.thevpc.nuts.spi.NComponent;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.text.NFormats;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NPositionType;
import net.thevpc.nuts.text.NVersionFormat;
import net.thevpc.nuts.util.NClassClassMap;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NListValueMap;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNWorkspaceFactory
implements NWorkspaceFactory {
    private final NLog LOG;
    private final NListValueMap<Class<?>, Object> instances = new NListValueMap();
    private final Map<NId, IdCache> discoveredCacheById = new HashMap<NId, IdCache>();
    private final HashMap<String, String> _alreadyLogger = new HashMap();
    private final NWorkspace workspace;
    private final NBeanCache cache;

    public DefaultNWorkspaceFactory(NWorkspace ws) {
        this.workspace = ws;
        this.LOG = ((DefaultNWorkspace)ws).getModel().LOG;
        this.cache = new NBeanCache(this.LOG, CoreNUtils.isDevVerbose() ? System.err : null);
    }

    @Override
    public Set<Class<? extends NComponent>> discoverTypes(NId id, URL url, ClassLoader bootClassLoader) {
        return this.discoverTypes(id, url, bootClassLoader, new Class[]{NComponent.class});
    }

    @Override
    public Set<Class<? extends NComponent>> discoverTypes(NId id, URL url, ClassLoader bootClassLoader, Class<? extends NComponent>[] extensionPoints) {
        if (!this.discoveredCacheById.containsKey(id)) {
            IdCache value = new IdCache(id, url, bootClassLoader, this.LOG, extensionPoints, this.workspace);
            this.discoveredCacheById.put(id, value);
            HashSet<Class<? extends NComponent>> all = new HashSet<Class<? extends NComponent>>();
            for (NClassClassMap m : value.classes.values()) {
                Collection values = m.values();
                all.addAll(values);
            }
            return all;
        }
        return Collections.emptySet();
    }

    @Override
    public <T extends NComponent> NOptional<T> createComponent(Class<T> type, Object supportCriteria) {
        Set<Class<T>> extensionTypes;
        NSession session = this.workspace.currentSession();
        switch (type.getName()) {
            case "net.thevpc.nuts.app.NApp": {
                return NOptional.of((NComponent)((DefaultNSession)session).getPropertiesHolder().getOrComputeProperty(type.getName(), () -> new NAppImpl(), NScopeType.TRANSITIVE_SESSION));
            }
        }
        List<T> all = this.createAll(type);
        NOptional s = new NScorableNScorableQueryImpl(NScorableContext.of(supportCriteria)).withName(NMsg.ofC("extensions component %s", type)).fromIterable(all).getBest();
        if (!s.isPresent()) {
            switch (type.getName()) {
                case "net.thevpc.nuts.log.NLogs": {
                    DefaultNLogs p = NApp.of().getOrComputeProperty("fallback::" + type.getName(), NScopeType.SESSION, () -> new DefaultNLogs());
                    return NOptional.of(p);
                }
                case "net.thevpc.nuts.text.NTexts": {
                    DefaultNTexts p = NApp.of().getOrComputeProperty("fallback::" + type.getName(), NScopeType.SESSION, () -> new DefaultNTexts());
                    return NOptional.of(p);
                }
                case "net.thevpc.nuts.text.NObjectFormat": {
                    DefaultNObjectFormat p = NApp.of().getOrComputeProperty("fallback::" + type.getName(), NScopeType.SESSION, () -> new DefaultNObjectFormat(this.workspace));
                    return NOptional.of(p);
                }
                case "net.thevpc.nuts.io.NIO": {
                    DefaultNIO p = NApp.of().getOrComputeProperty("fallback::" + type.getName(), NScopeType.WORKSPACE, () -> new DefaultNIO());
                    return NOptional.of(p);
                }
                case "net.thevpc.nuts.elem.NElements": {
                    DefaultNElements p = NApp.of().getOrComputeProperty("fallback::" + type.getName(), NScopeType.SESSION, () -> new DefaultNElements());
                    return NOptional.of(p);
                }
                case "net.thevpc.nuts.elem.NElementWriter": {
                    DefaultNElementWriter p = NApp.of().getOrComputeProperty("fallback::" + type.getName(), NScopeType.SESSION, () -> new DefaultNElementWriter());
                    return NOptional.of(p);
                }
                case "net.thevpc.nuts.elem.NElementParser": {
                    DefaultNElementParser p = NApp.of().getOrComputeProperty("fallback::" + type.getName(), NScopeType.SESSION, () -> new DefaultNElementParser());
                    return NOptional.of(p);
                }
                case "net.thevpc.nuts.elem.NElementFactory": {
                    DefaultNElementFactory p = NApp.of().getOrComputeProperty("fallback::" + type.getName(), NScopeType.SESSION, () -> new DefaultNElementFactory());
                    return NOptional.of(p);
                }
                case "net.thevpc.nuts.io.NLibPaths": {
                    DefaultNLibPaths p = NApp.of().getOrComputeProperty("fallback::" + type.getName(), NScopeType.SESSION, () -> new DefaultNLibPaths(this.workspace));
                    return NOptional.of(p);
                }
                case "net.thevpc.nuts.io.NDigest": {
                    NDigest p = NApp.of().getOrComputeProperty("fallback::" + type.getName(), NScopeType.SESSION, () -> new DefaultNDigest(this.workspace));
                    return NOptional.of(p);
                }
                case "net.thevpc.nuts.internal.rpi.NIORPI": {
                    NIORPI p = NApp.of().getOrComputeProperty("fallback::" + type.getName(), NScopeType.SESSION, () -> new DefaultNIORPI(this.workspace));
                    return NOptional.of(p);
                }
                case "net.thevpc.nuts.internal.rpi.NCollectionsRPI": {
                    NCollectionsRPI p = NApp.of().getOrComputeProperty("fallback::" + type.getName(), NScopeType.SESSION, () -> new DefaultNCollectionsRPI());
                    return NOptional.of(p);
                }
                case "net.thevpc.nuts.artifact.NIdFormat": {
                    NIdFormat p = NApp.of().getOrComputeProperty("fallback::" + type.getName(), NScopeType.SESSION, () -> new DefaultNIdFormat());
                    return NOptional.of(p);
                }
                case "net.thevpc.nuts.text.NVersionFormat": {
                    NVersionFormat p = NApp.of().getOrComputeProperty("fallback::" + type.getName(), NScopeType.SESSION, () -> new DefaultNVersionFormat(this.workspace));
                    return NOptional.of(p);
                }
                case "net.thevpc.nuts.command.NExecCmd": {
                    NExecCmd p = NApp.of().getOrComputeProperty("fallback::" + type.getName(), NScopeType.SESSION, () -> new DefaultNExecCmd(this.workspace));
                    return NOptional.of(p);
                }
                case "net.thevpc.nuts.net.NWebCli": {
                    NWebCli p = NApp.of().getOrComputeProperty("fallback::" + type.getName(), NScopeType.SESSION, () -> new DefaultNWebCli());
                    return NOptional.of(p);
                }
                case "net.thevpc.nuts.artifact.NIdBuilder": {
                    return NOptional.of(new DefaultNIdBuilder());
                }
                case "net.thevpc.nuts.artifact.NDependencyBuilder": {
                    return NOptional.of(new DefaultNDependencyBuilder());
                }
                case "net.thevpc.nuts.artifact.NEnvConditionBuilder": {
                    return NOptional.of(new DefaultNEnvConditionBuilder());
                }
                case "net.thevpc.nuts.artifact.NDescriptorBuilder": {
                    return NOptional.of(new DefaultNDescriptorBuilder());
                }
                case "net.thevpc.nuts.core.NBootOptionsBuilder": {
                    return NOptional.of(new DefaultNBootOptionsBuilder());
                }
                case "net.thevpc.nuts.core.NWorkspaceOptionsBuilder": {
                    return NOptional.of(new DefaultNWorkspaceOptionsBuilder());
                }
                case "net.thevpc.nuts.expr.NExprs": {
                    return NOptional.of(new DefaultNExprs());
                }
                case "net.thevpc.nuts.text.NFormats": {
                    NFormats p = NApp.of().getOrComputeProperty("fallback::" + type.getName(), NScopeType.WORKSPACE, () -> new NFormatsImpl());
                    return NOptional.of(p);
                }
                case "net.thevpc.nuts.app.NApp": {
                    return NOptional.of(new NAppImpl());
                }
                case "net.thevpc.nuts.spi.NUtilSPI": {
                    return NOptional.of(new NUtilSPIImpl());
                }
                case "net.thevpc.nuts.concurrent.NConcurrent": {
                    return NOptional.of(new NConcurrentImpl());
                }
            }
            if (all.isEmpty() && !session.isBot()) {
                System.err.println("[Nuts] unable to resolve " + type);
                extensionTypes = this.getExtensionTypes(type);
                System.err.println("[Nuts] extensionTypes =  " + extensionTypes);
                this.dump(type);
                new Throwable().printStackTrace();
            }
        }
        if (all.isEmpty() && !session.isBot()) {
            System.err.println("[Nuts] unable to resolve " + type);
            extensionTypes = this.getExtensionTypes(type);
            System.err.println("[Nuts] extensionTypes =  " + extensionTypes);
            this.dump(type);
            new Throwable().printStackTrace();
        }
        return s;
    }

    @Override
    public <T extends NComponent> List<T> createComponents(Class<T> type, Object supportCriteria) {
        List<T> list = this.createAll(type);
        return new NScorableNScorableQueryImpl<T>(NScorableContext.of()).fromIterable(list).getAll();
    }

    @Override
    public <T extends NComponent> List<T> createAll(Class<T> type) {
        ArrayList<NComponent> all = new ArrayList<NComponent>();
        for (Object object : this.instances.getAll(type)) {
            all.add((NComponent)object);
        }
        for (Class clazz : this.getExtensionTypes(type)) {
            Object obj = null;
            try {
                obj = this.resolveInstance(clazz, type);
            }
            catch (Exception e) {
                this.LOG.log(NMsg.ofJ("error while instantiating {0} for {1} : {2}", clazz, type, e).asError(e));
            }
            if (obj == null) continue;
            all.add((NComponent)obj);
        }
        return all;
    }

    @Override
    public <T extends NComponent> T createFirst(Class<T> type) {
        Iterator<Object> iterator = this.instances.getAll(type).iterator();
        if (iterator.hasNext()) {
            Object obj = iterator.next();
            return (T)((NComponent)obj);
        }
        iterator = this.getExtensionTypes(type).iterator();
        if (iterator.hasNext()) {
            Class c = (Class)iterator.next();
            return this.resolveInstance(c, type);
        }
        return null;
    }

    @Override
    public <T extends NComponent> Set<Class<? extends T>> getExtensionTypes(Class<T> type) {
        LinkedHashSet<Class<T>> all = new LinkedHashSet<Class<T>>();
        for (IdCache v : this.discoveredCacheById.values()) {
            all.addAll(v.getExtensionTypes(type));
        }
        return all;
    }

    private <T extends NComponent> Set<Class<? extends T>> getExtensionTypesNoCache(Class<T> type) {
        LinkedHashSet<Class<T>> all = new LinkedHashSet<Class<T>>();
        for (IdCache v : this.discoveredCacheById.values()) {
            all.addAll(v.getExtensionTypesNoCache(type));
        }
        return all;
    }

    private <T extends NComponent> Set<Class<? extends T>> getExtensionTypesNoCache2(Class<T> type) {
        LinkedHashSet<Class<T>> all = new LinkedHashSet<Class<T>>();
        for (IdCache v : this.discoveredCacheById.values()) {
            all.addAll(v.getExtensionTypesNoCache2(type));
        }
        return all;
    }

    @Override
    public <T extends NComponent> List<T> getExtensionObjects(Class<T> extensionPoint) {
        return new ArrayList<Object>(this.instances.getAll(extensionPoint));
    }

    @Override
    public <T extends NComponent> boolean isRegisteredType(Class<T> extensionPoint, String implementation) {
        return this.findRegisteredType(extensionPoint, implementation) != null;
    }

    @Override
    public <T extends NComponent> boolean isRegisteredInstance(Class<T> extensionPoint, T implementation) {
        return this.instances.contains(extensionPoint, implementation);
    }

    @Override
    public <T extends NComponent> void registerInstance(Class<T> extensionPoint, T implementation) {
        if (this.isRegisteredInstance(extensionPoint, implementation)) {
            throw new NIllegalArgumentException(NMsg.ofC("already registered Extension %s for %s", implementation, extensionPoint.getName()));
        }
        if (this.LOG.isLoggable(Level.CONFIG)) {
            this.LOG.log(NMsg.ofJ("bind    {0} for impl instance {1}", NStringUtils.formatAlign(extensionPoint.getSimpleName(), 40, NPositionType.FIRST), implementation.getClass().getName()).withLevel(Level.FINEST).withIntent(NMsgIntent.ADD));
        }
        this.instances.add(extensionPoint, implementation);
    }

    @Override
    public <T extends NComponent> void registerType(Class<T> extensionPoint, Class<? extends T> implementationType, NId source) {
        IdCache t;
        if (this.isRegisteredType(extensionPoint, implementationType.getName())) {
            throw new NIllegalArgumentException(NMsg.ofC("already registered Extension %s for %s", implementationType.getName(), extensionPoint.getName()));
        }
        if (this.LOG.isLoggable(Level.CONFIG)) {
            this.LOG.log(NMsg.ofJ("bind    {0} for impl type {1}", NStringUtils.formatAlign(extensionPoint.getSimpleName(), 40, NPositionType.FIRST), implementationType.getName()).withLevel(Level.FINEST).withIntent(NMsgIntent.ADD));
        }
        if ((t = this.discoveredCacheById.get(source)) == null) {
            t = new IdCache(source, this.workspace);
            this.discoveredCacheById.put(source, t);
        }
        t.add(NComponent.class, implementationType);
    }

    @Override
    public <T extends NComponent> boolean isRegisteredType(Class<T> extensionPoint, Class<? extends T> implementationType) {
        return this.getExtensionTypes(extensionPoint).contains(implementationType);
    }

    public <T extends NComponent> Class<? extends T> findRegisteredType(Class<T> extensionPoint, String implementation) {
        for (Class<T> cls : this.getExtensionTypes(extensionPoint)) {
            if (!cls.getName().equals(implementation)) continue;
            return cls;
        }
        return null;
    }

    public <T extends NComponent> T newInstance(Class<T> t, Class<? super T> apiType) {
        return (T)((NComponent)this.newInstance(t, new Class[0], new Object[0], apiType));
    }

    protected <T extends NComponent> T newInstanceAndLog(Class<? extends T> implementation, Class<?>[] argTypes, Object[] args, Class<T> apiType, NScopeType scope) {
        String old;
        T o = this.newInstance(implementation, apiType);
        if (!(this.isBootstrapLogType(apiType) || !this.LOG.isLoggable(Level.CONFIG) || (old = this._alreadyLogger.get(apiType.getName())) != null && old.equals(implementation.getName()))) {
            this._alreadyLogger.put(apiType.getName(), implementation.getName());
            this.LOG.log(NMsg.ofC("resolve %s to  %s %s", NStringUtils.formatAlign(apiType.getSimpleName(), 40, NPositionType.FIRST), scope, implementation.getName()).withLevel(Level.FINEST).withIntent(NMsgIntent.READ));
        }
        return o;
    }

    protected <T> T newInstance(Class<T> t, Class[] argTypes, Object[] args, Class apiType) {
        T t1 = null;
        NSession session = this.workspace.currentSession();
        CachedConstructor<T> ctrl0 = this.cache.findConstructor(t, argTypes);
        if (ctrl0 == null) {
            if (this.isBootstrapLogType(apiType)) {
                this.safeLog(NMsg.ofC("error when instantiating %s as %s : no constructor found", apiType, t), null);
            } else if (this.LOG.isLoggable(Level.FINEST)) {
                this.LOG.log(NMsg.ofC("error when instantiating %s as %s : no constructor found", apiType, t).asFinest().withIntent(NMsgIntent.FAIL));
            }
            NBeanCache cache2 = new NBeanCache(this.LOG, CoreNUtils.isDevVerbose() ? System.err : null);
            cache2.findConstructor(t, argTypes);
            throw new NFactoryException(NMsg.ofC("instantiate '%s' failed", t), (Throwable)new NoSuchElementException(NMsg.ofC("No constructor was found %s(%s). All %s available constructors are : %s", t.getName(), Arrays.stream(argTypes).map(Class::getSimpleName).collect(Collectors.joining(",")), t.getDeclaredConstructors().length, Arrays.stream(t.getDeclaredConstructors()).map(x -> this.toString()).collect(Collectors.joining(" ; "))).toString()));
        }
        try {
            t1 = ctrl0.newInstance(args, session);
        }
        catch (Exception e) {
            if (this.isBootstrapLogType(apiType)) {
                this.safeLog(NMsg.ofC("error when instantiating %s as %s : %s", apiType, t, e), e);
            } else if (this.LOG.isLoggable(Level.FINEST)) {
                this.LOG.log(NMsg.ofC("error when instantiating %s as %s : %s", apiType, t, e).asFinestFail(e));
            }
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new NFactoryException(NMsg.ofC("error when instantiating %s as %s : %s", apiType, t, e), cause);
        }
        return t1;
    }

    protected <T extends NComponent> T resolveInstance(Class<? extends T> implType, Class<T> apiType) {
        return this.resolveInstance(implType, apiType, new Class[0], new Object[0]);
    }

    private <T extends NComponent> NScopeType computeScope(Class<? extends T> implType, Class<T> apiType) {
        NComponentScope apiScope = apiType.getAnnotation(NComponentScope.class);
        NComponentScope implScope = implType.getAnnotation(NComponentScope.class);
        NScopeType scope = NScopeType.PROTOTYPE;
        if (apiScope != null || implScope != null) {
            if (apiScope != null && implScope == null) {
                scope = apiScope.value();
            } else if (apiScope == null && implScope != null) {
                scope = implScope.value();
            } else if (apiScope.value() == implScope.value()) {
                scope = apiScope.value();
            } else {
                scope = apiScope.value();
                if (this.LOG.isLoggable(Level.CONFIG)) {
                    switch (apiType.getName()) {
                        case "net.thevpc.nuts.text.NTexts": {
                            break;
                        }
                        default: {
                            this.LOG.log(NMsg.ofJ("invalid scope {0} ; expected {1} for  {2}", implScope.value(), apiScope.value(), implType.getName()).withLevel(Level.FINEST).withIntent(NMsgIntent.FAIL));
                        }
                    }
                }
            }
        }
        return scope;
    }

    public void safeLog(NMsg msg, Throwable any) {
        PrintStream err = NWorkspaceExt.of().getModel().bootModel.getBootTerminal().getErr();
        if (err == null) {
            err = System.err;
        }
        err.println(msg.toString() + ":");
        any.printStackTrace();
    }

    public boolean isBootstrapLogType(Class apiType) {
        switch (apiType.getName()) {
            case "net.thevpc.nuts.io.NPaths": 
            case "net.thevpc.nuts.text.NTexts": 
            case "net.thevpc.nuts.log.NLogs": 
            case "net.thevpc.nuts.log.NLog": {
                return true;
            }
        }
        return false;
    }

    protected <T extends NComponent> T resolveInstance(Class<? extends T> implementation, Class<T> apiType, Class<?>[] argTypes, Object[] args) {
        if (implementation == null) {
            return null;
        }
        NScopeType scope = this.computeScope(implementation, apiType);
        if (apiType.getAnnotation(NComponentScope.class) != null) {
            scope = apiType.getAnnotation(NComponentScope.class).value();
        }
        if (scope == null) {
            scope = NScopeType.PROTOTYPE;
        }
        NScopeType finalScope = scope;
        if (scope == NScopeType.PROTOTYPE) {
            return this.newInstanceAndLog(implementation, argTypes, args, apiType, finalScope);
        }
        NPropertiesHolder beans = DefaultNWorkspaceFactory.resolveBeansHolder(scope);
        return (T)beans.getOrComputeProperty(implementation.getName(), () -> this.newInstanceAndLog(implementation, argTypes, args, apiType, finalScope), finalScope);
    }

    private static NPropertiesHolder resolveBeansHolder(NScopeType scope) {
        return NApp.of().getOrComputeProperty(NWorkspaceFactory.class.getName() + "::beans", scope, () -> new NPropertiesHolder());
    }

    public <T extends NComponent> T create(Class<T> type) {
        Object one = this.instances.getOne(type);
        if (one != null) {
            if (this.LOG.isLoggable(Level.CONFIG)) {
                this.LOG.log(NMsg.ofJ("resolve {0} to singleton {1}", NStringUtils.formatAlign(type.getSimpleName(), 40, NPositionType.FIRST), one.getClass().getName()).withLevel(Level.FINEST).withIntent(NMsgIntent.READ));
            }
            return (T)((NComponent)one);
        }
        Set<Class<T>> extensionTypes = this.getExtensionTypes(type);
        Iterator<Class<T>> iterator = extensionTypes.iterator();
        if (iterator.hasNext()) {
            Class<T> e = iterator.next();
            return this.resolveInstance(e, type);
        }
        iterator = extensionTypes.iterator();
        if (iterator.hasNext()) {
            Class<T> t = iterator.next();
            return this.newInstance(t, type);
        }
        throw new NElementNotFoundException(NMsg.ofC("type %s not found", type));
    }

    public <T extends NComponent> List<T> createAll(Class<T> type, Class<?>[] argTypes, Object[] args) {
        ArrayList<Object> all = new ArrayList<Object>();
        for (Class<T> c : this.getExtensionTypes(type)) {
            Object obj = null;
            try {
                obj = this.resolveInstance(c, type, argTypes, args);
            }
            catch (Exception e) {
                this.LOG.log(NMsg.ofC("error when instantiating %s : %s", type, e).asWarningFail(e));
            }
            if (obj == null) continue;
            all.add(obj);
        }
        return all;
    }

    public void dump(Class<?> type) {
        System.err.println("Start Extensions Factory Dump");
        String tname = type.getName();
        for (Map.Entry<NId, IdCache> e : this.discoveredCacheById.entrySet()) {
            IdCache idCache = e.getValue();
            System.err.println("\t" + e.getKey() + " :: " + idCache.url);
            for (Map.Entry<Class<?>, NClassClassMap> v : idCache.classes.entrySet()) {
                NClassClassMap vv = v.getValue();
                Set classes = vv.allKeySet();
                for (Class k : classes) {
                    if (!k.isInterface()) continue;
                    if (k.getName().equals(tname)) {
                        if (k.equals(type)) {
                            System.err.println("\t\t --->  " + k + "->" + vv.get(k));
                        } else {
                            System.err.println("\t\t --->  " + k + "->" + vv.get(k) + " ::: class loader : found " + k.getClassLoader() + " __VS__ expected " + type.getClassLoader());
                        }
                        System.err.println("\t\t\t --->  " + type + "->" + vv.get(type) + " ::: class loader : found " + k.getClassLoader() + " __VS__ expected " + type.getClassLoader());
                        System.err.println("\t\t\t\t --->  getAll => " + type + "->" + Arrays.asList((Class[])vv.getAll(type)));
                        System.err.println("\t\t\t\t --->  getExtensionTypes => " + this.getExtensionTypes(type));
                        System.err.println("\t\t\t\t --->  getExtensionTypesNoCache => " + this.getExtensionTypesNoCache(type));
                        System.err.println("\t\t\t\t --->  getExtensionTypesNoCache2 => " + this.getExtensionTypesNoCache2(type));
                        continue;
                    }
                    System.err.println("\t\t" + k + "->" + vv.get(k));
                }
                for (Class k : classes) {
                    if (k.isInterface()) continue;
                    if (k.getName().equals(tname)) {
                        if (k.equals(type)) {
                            System.err.println("\t\t --->  " + k + "->" + vv.get(k));
                        } else {
                            System.err.println("\t\t --->  " + k + "->" + vv.get(k) + " ::: class loader : found " + k.getClassLoader() + " __VS__ expected " + type.getClassLoader());
                        }
                        System.err.println("\t\t\t --->  " + type + "->" + vv.get(type) + " ::: class loader : found " + k.getClassLoader() + " __VS__ expected " + type.getClassLoader());
                        continue;
                    }
                    System.err.println("\t\t" + k + "->" + vv.get(k));
                }
            }
        }
        System.err.println("Finish Extensions Factory Dump");
    }

    private static final class ClassExtension {
        Class clazz;
        Object source;
        boolean enabled = true;

        public ClassExtension(Class clazz, Object source, boolean enabled) {
            this.clazz = clazz;
            this.source = source;
            this.enabled = enabled;
        }
    }
}

