/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import net.thevpc.nuts.app.NApp;
import net.thevpc.nuts.boot.NBootOptionsInfo;
import net.thevpc.nuts.boot.NBootWorkspaceImpl;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NExecCmd;
import net.thevpc.nuts.command.NInstallListener;
import net.thevpc.nuts.concurrent.NCallable;
import net.thevpc.nuts.core.NBootOptions;
import net.thevpc.nuts.core.NRepositoryListener;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.core.NWorkspaceListener;
import net.thevpc.nuts.internal.NScopedWorkspace;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.runtime.standalone.DefaultNBootOptionsBuilder;
import net.thevpc.nuts.runtime.standalone.event.DefaultNWorkspaceEventModel;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NObservableMapListener;
import net.thevpc.nuts.util.NScorableContext;

public abstract class AbstractNWorkspace
implements NWorkspace {
    protected NBootOptionsInfo callerBootOptionsInfo;

    public AbstractNWorkspace(NBootOptionsInfo callerBootOptionsInfo) {
        this.callerBootOptionsInfo = callerBootOptionsInfo;
    }

    @Override
    public void runWith(Runnable runnable) {
        NScopedWorkspace.runWith(this, runnable);
    }

    @Override
    public <T> T callWith(NCallable<T> callable) {
        return NScopedWorkspace.callWith(this, callable);
    }

    @Override
    public int getScore(NScorableContext criteria) {
        return 10;
    }

    public String toString() {
        return "NutsWorkspace{" + this.getName() + '}';
    }

    @Override
    public void close() {
    }

    @Override
    public NWorkspace share() {
        NScopedWorkspace.setSharedWorkspaceInstance(this);
        return this;
    }

    @Override
    public NWorkspace setSharedInstance() {
        NScopedWorkspace.setSharedWorkspaceInstance(this);
        return this;
    }

    @Override
    public boolean isSharedInstance() {
        return NScopedWorkspace.getSharedWorkspaceInstance() == this;
    }

    private DefaultNWorkspaceEventModel eventsModel() {
        return ((NWorkspaceExt)((Object)this)).getModel().eventsModel;
    }

    @Override
    public NWorkspace removeRepositoryListener(NRepositoryListener listener) {
        this.eventsModel().removeRepositoryListener(listener);
        return this;
    }

    @Override
    public NWorkspace addRepositoryListener(NRepositoryListener listener) {
        this.eventsModel().addRepositoryListener(listener);
        return this;
    }

    @Override
    public List<NRepositoryListener> getRepositoryListeners() {
        return this.eventsModel().getRepositoryListeners();
    }

    @Override
    public NWorkspace addUserPropertyListener(NObservableMapListener<String, Object> listener) {
        this.eventsModel().addUserPropertyListener(listener);
        return this;
    }

    @Override
    public NWorkspace removeUserPropertyListener(NObservableMapListener<String, Object> listener) {
        this.eventsModel().removeUserPropertyListener(listener);
        return this;
    }

    @Override
    public List<NObservableMapListener<String, Object>> getUserPropertyListeners() {
        return this.eventsModel().getUserPropertyListeners();
    }

    @Override
    public NWorkspace removeWorkspaceListener(NWorkspaceListener listener) {
        this.eventsModel().removeWorkspaceListener(listener);
        return this;
    }

    @Override
    public NWorkspace addWorkspaceListener(NWorkspaceListener listener) {
        this.eventsModel().addWorkspaceListener(listener);
        return this;
    }

    @Override
    public List<NWorkspaceListener> getWorkspaceListeners() {
        return this.eventsModel().getWorkspaceListeners();
    }

    @Override
    public NWorkspace removeInstallListener(NInstallListener listener) {
        this.eventsModel().removeInstallListener(listener);
        return this;
    }

    @Override
    public NWorkspace addInstallListener(NInstallListener listener) {
        this.eventsModel().addInstallListener(listener);
        return this;
    }

    @Override
    public List<NInstallListener> getInstallListeners() {
        return this.eventsModel().getInstallListeners();
    }

    @Override
    public void runBootCommand() {
        this.runWith(() -> {
            NBootOptions info2 = new DefaultNBootOptionsBuilder(this.callerBootOptionsInfo).build();
            NApp.of().setId(this.getApiId());
            NLog LOG = NLog.of(NBootWorkspaceImpl.class);
            LOG.log(NMsg.ofC("running workspace in %s mode", this.getRunModeString(info2)).withLevel(Level.CONFIG).withIntent(NMsgIntent.SUCCESS));
            NExecCmd execCmd = NExecCmd.of().setExecutionType(info2.getExecutionType().orNull()).setRunAs(info2.getRunAs().orNull()).failFast();
            List<String> executorOptions = info2.getExecutorOptions().orNull();
            if (executorOptions != null) {
                execCmd.configure(true, executorOptions.toArray(new String[0]));
            }
            NCmdLine executorOptionsCmdLine = NCmdLine.of(executorOptions).setExpandSimpleOptions(false);
            while (executorOptionsCmdLine.hasNext()) {
                execCmd.configureLast(executorOptionsCmdLine);
            }
            if (info2.getApplicationArguments().get().isEmpty()) {
                if (info2.getSkipWelcome().orElse(false).booleanValue()) {
                    return;
                }
                execCmd.addCommand("welcome");
            } else {
                execCmd.addCommand((Collection<String>)info2.getApplicationArguments().get());
            }
            execCmd.run();
        });
    }

    private String getRunModeString(NBootOptions options) {
        if (options.getReset().orElse(false).booleanValue()) {
            return "reset";
        }
        if (options.getRecover().orElse(false).booleanValue()) {
            return "recover";
        }
        return "exec";
    }
}

