/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.version.filter;

import java.util.List;
import net.thevpc.nuts.artifact.NVersionComparator;
import net.thevpc.nuts.artifact.NVersionFilter;
import net.thevpc.nuts.artifact.NVersionFilters;
import net.thevpc.nuts.runtime.standalone.util.filters.InternalNTypedFilters;
import net.thevpc.nuts.runtime.standalone.version.filter.DefaultNVersionFilter;
import net.thevpc.nuts.runtime.standalone.version.filter.NVersionFilterAnd;
import net.thevpc.nuts.runtime.standalone.version.filter.NVersionFilterFalse;
import net.thevpc.nuts.runtime.standalone.version.filter.NVersionFilterNone;
import net.thevpc.nuts.runtime.standalone.version.filter.NVersionFilterOr;
import net.thevpc.nuts.runtime.standalone.version.filter.NVersionFilterParser;
import net.thevpc.nuts.runtime.standalone.version.filter.NVersionFilterTrue;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NFilter;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NScorableContext;

public class InternalNVersionFilters
extends InternalNTypedFilters<NVersionFilter>
implements NVersionFilters {
    public InternalNVersionFilters() {
        super(NVersionFilter.class);
    }

    @Override
    public NOptional<NVersionFilter> byValue(String version) {
        return this.byValue(version, null);
    }

    @Override
    public NOptional<NVersionFilter> byValue(String version, NVersionComparator versionComparator) {
        return DefaultNVersionFilter.parse(version, versionComparator);
    }

    @Override
    public NVersionFilter always() {
        return new NVersionFilterTrue();
    }

    @Override
    public NVersionFilter never() {
        return new NVersionFilterFalse();
    }

    @Override
    public NVersionFilter not(NFilter other) {
        return new NVersionFilterNone((NVersionFilter)other);
    }

    @Override
    public NVersionFilter as(NFilter a) {
        if (a instanceof NVersionFilter) {
            return (NVersionFilter)a;
        }
        return null;
    }

    @Override
    public NVersionFilter from(NFilter a) {
        if (a == null) {
            return null;
        }
        NVersionFilter t = this.as(a);
        if (t == null) {
            throw new NIllegalArgumentException(NMsg.ofPlain("not a VersionFilter"));
        }
        return t;
    }

    @Override
    public NVersionFilter all(NFilter ... others) {
        List<NVersionFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        if (all.size() == 1) {
            return (NVersionFilter)all.get(0);
        }
        return new NVersionFilterAnd(all.toArray(new NVersionFilter[0]));
    }

    @Override
    public NVersionFilter any(NFilter ... others) {
        List<NVersionFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        if (all.size() == 1) {
            return (NVersionFilter)all.get(0);
        }
        return new NVersionFilterOr(all.toArray(new NVersionFilter[0]));
    }

    @Override
    public NVersionFilter none(NFilter ... others) {
        List<NVersionFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        return new NVersionFilterNone(all.toArray(new NVersionFilter[0]));
    }

    @Override
    public NVersionFilter parse(String expression) {
        return this.parse(expression, null);
    }

    @Override
    public NVersionFilter parse(String expression, NVersionComparator versionComparator) {
        return new NVersionFilterParser(expression, versionComparator).parse();
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }
}

