/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.version.filter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.artifact.NVersionComparator;
import net.thevpc.nuts.artifact.NVersionFilter;
import net.thevpc.nuts.artifact.NVersionFilters;
import net.thevpc.nuts.artifact.NVersionInterval;
import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.runtime.standalone.id.filter.NExprIdFilter;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.spi.base.AbstractVersionFilter;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NFilterOp;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringUtils;
import net.thevpc.nuts.util.NSupportMode;

public class DefaultNVersionFilter
extends AbstractVersionFilter
implements NExprIdFilter,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<NVersionInterval> intervals = new ArrayList<NVersionInterval>();

    public DefaultNVersionFilter() {
        super(NFilterOp.CUSTOM);
    }

    public static NOptional<NVersionFilter> parse(String version, NVersionComparator versionComparator) {
        if (NBlankable.isBlank(version) || "*".equals(version)) {
            return NOptional.of((NVersionFilter)NVersionFilters.of().always());
        }
        NOptional<List<NVersionInterval>> r = NVersionInterval.ofList(version, versionComparator);
        return r.map(x -> {
            DefaultNVersionFilter dd = new DefaultNVersionFilter();
            for (NVersionInterval i : x) {
                dd.add(i);
            }
            return dd;
        });
    }

    @Override
    public boolean acceptVersion(NVersion version) {
        if (this.intervals.isEmpty()) {
            return true;
        }
        for (NVersionInterval value : this.intervals) {
            if (!value.acceptVersion(version)) continue;
            return true;
        }
        return false;
    }

    @Override
    public NOptional<List<NVersionInterval>> intervals() {
        return NOptional.of(this.intervals);
    }

    public void add(NVersionInterval interval) {
        this.intervals.add(interval);
    }

    @Override
    public String toExpr() {
        return "id.version.matches(" + NStringUtils.formatStringLiteral(NStringUtils.formatStringLiteral(this.toString(), NElementType.SINGLE_QUOTED_STRING), NElementType.DOUBLE_QUOTED_STRING, NSupportMode.NEVER) + ")";
    }

    @Override
    public NVersionFilter simplify() {
        ArrayList<NVersionInterval> intervals2 = new ArrayList<NVersionInterval>();
        boolean updates = false;
        for (NVersionInterval interval : this.intervals) {
            NVersionInterval _interval = CoreFilterUtils.simplify(interval);
            if (_interval != null) {
                if (_interval.getLowerBound() == null && _interval.getUpperBound() == null) {
                    return null;
                }
                if (!_interval.equals(interval)) {
                    updates = true;
                }
                intervals2.add(interval);
                continue;
            }
            updates = true;
        }
        if (intervals2.isEmpty()) {
            return null;
        }
        if (!updates) {
            return this;
        }
        DefaultNVersionFilter d = new DefaultNVersionFilter();
        d.intervals.addAll(intervals2);
        return d;
    }

    public int hashCode() {
        int hash = 3;
        hash = 71 * hash + Objects.hashCode(this.intervals);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultNVersionFilter other = (DefaultNVersionFilter)obj;
        return Objects.equals(this.intervals, other.intervals);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (NVersionInterval interval : this.intervals) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(interval.toString());
        }
        return sb.toString();
    }
}

