/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.stream;

import java.util.List;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.thevpc.nuts.runtime.standalone.util.stream.NStreamBase;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NCollections;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NUnexpectedException;

public class NStreamFromNIterator<T>
extends NStreamBase<T> {
    private final NIterator<T> o;

    public NStreamFromNIterator(String nutsBase, NIterator<T> o) {
        super(nutsBase);
        this.o = o;
    }

    @Override
    public List<T> toList() {
        return NCollections.list(this.o);
    }

    @Override
    public Stream<T> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.o, 16), false);
    }

    @Override
    public NIterator<T> iterator() {
        return this.o;
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Objects.hashCode(this.o);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NStreamFromNIterator other = (NStreamFromNIterator)obj;
        return Objects.equals(this.o, other.o);
    }

    public String toString() {
        return "IteratorBasedResult@" + Integer.toHexString(this.hashCode());
    }

    @Override
    public void close() {
        if (this.o instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)this.o)).close();
            }
            catch (Exception e) {
                throw new NUnexpectedException(NMsg.ofC("unable to close iterator : %s", e));
            }
        }
        super.close();
    }
}

