/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.stream;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.runtime.standalone.util.stream.NStreamFromNIterator;
import net.thevpc.nuts.runtime.standalone.util.stream.NStreamWithDescription;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NComparator;
import net.thevpc.nuts.util.NFunction;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NIteratorBuilder;
import net.thevpc.nuts.util.NIteratorUtils;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NPredicate;
import net.thevpc.nuts.util.NStream;
import net.thevpc.nuts.util.NTooManyElementsException;
import net.thevpc.nuts.util.UnsafeFunction;

public abstract class NStreamBase<T>
implements NStream<T> {
    protected String nutsBase;

    public NStreamBase(String nutsBase) {
        this.nutsBase = nutsBase;
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("duplicate key %s", u));
        };
    }

    @Override
    public List<T> toList() {
        ArrayList list = new ArrayList();
        for (Object a : this) {
            list.add(a);
        }
        return list;
    }

    @Override
    public Set<T> toSet() {
        return this.stream().collect(Collectors.toSet());
    }

    @Override
    public Set<T> toSortedSet() {
        return this.stream().collect(Collectors.toCollection(TreeSet::new));
    }

    @Override
    public Set<T> toOrderedSet() {
        return this.stream().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public NOptional<T> findLast() {
        Object t2 = null;
        for (Object t2 : this) {
        }
        return NOptional.ofEmpty(() -> this.nutsBase == null ? NMsg.ofPlain("missing last") : NMsg.ofC("missing last %s", this.nutsBase));
    }

    @Override
    public NOptional<T> findSingleton() {
        Iterator it = this.iterator();
        if (it.hasNext()) {
            Object t = it.next();
            if (it.hasNext()) {
                return NOptional.ofError(() -> NMsg.ofC("too many results for %s", this.nutsBase), (Throwable)new NTooManyElementsException(NMsg.ofC("too many results for %s", this.nutsBase)));
            }
            return NOptional.of(t);
        }
        return NOptional.ofEmpty(() -> this.nutsBase == null ? NMsg.ofPlain("missing") : NMsg.ofC("missing %s", this.nutsBase));
    }

    @Override
    public Stream<T> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 16), false);
    }

    @Override
    public long count() {
        long count = 0L;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public <R> NStream<R> map(final Function<? super T, ? extends R> mapper) {
        return new NStreamBase<R>(this.nutsBase){

            @Override
            public NIterator<R> iterator() {
                Iterator it = NStreamBase.this.iterator();
                return NIteratorBuilder.of(it).map(NFunction.of(mapper)).build();
            }
        };
    }

    @Override
    public <R> NStream<R> mapUnsafe(UnsafeFunction<? super T, ? extends R> mapper, Function<Exception, ? extends R> onError) {
        return this.map(NFunction.ofUnsafe(mapper, onError));
    }

    @Override
    public <R> NStream<R> mapUnsafe(UnsafeFunction<? super T, ? extends R> mapper) {
        return this.mapUnsafe(mapper, null);
    }

    @Override
    public NStream<T> sorted() {
        return new NStreamBase<T>(this.nutsBase){

            @Override
            public NIterator<T> iterator() {
                Iterator it = NStreamBase.this.iterator();
                return NIteratorUtils.sort(it, null, false);
            }
        };
    }

    @Override
    public NStream<T> sorted(final NComparator<T> comp) {
        return new NStreamBase<T>(this.nutsBase){

            @Override
            public NIterator<T> iterator() {
                Iterator it = NStreamBase.this.iterator();
                return NIteratorUtils.sort(it, comp, false);
            }
        };
    }

    @Override
    public NStream<T> distinct() {
        return new NStreamBase<T>(this.nutsBase){

            @Override
            public NIterator<T> iterator() {
                Iterator it = NStreamBase.this.iterator();
                return NIteratorUtils.distinct(it);
            }
        };
    }

    @Override
    public <R> NStream<T> distinctBy(final Function<T, R> condition) {
        return new NStreamBase<T>(this.nutsBase){

            @Override
            public NIterator<T> iterator() {
                Iterator it = NStreamBase.this.iterator();
                return NIteratorUtils.distinct(it, condition);
            }
        };
    }

    @Override
    public NStream<T> nonNull() {
        return (NStream)this.filter(Objects::nonNull).redescribe(NElementDescribables.ofDesc("nonNull"));
    }

    @Override
    public NStream<T> nonBlank() {
        return (NStream)this.filter(x -> {
            if (x == null) {
                return false;
            }
            if (x instanceof CharSequence) {
                return NBlankable.isBlank((CharSequence)x);
            }
            if (x instanceof char[]) {
                return NBlankable.isBlank((char[])x);
            }
            if (x instanceof NBlankable) {
                return !((NBlankable)x).isBlank();
            }
            return true;
        }).redescribe(NElementDescribables.ofDesc("nonBlank"));
    }

    @Override
    public NStream<T> filter(final Predicate<? super T> predicate) {
        return new NStreamBase<T>(this.nutsBase){

            @Override
            public NIterator<T> iterator() {
                Iterator it = NStreamBase.this.iterator();
                return NIteratorBuilder.of(it).filter(NPredicate.of(predicate)).build();
            }
        };
    }

    @Override
    public NStream<T> filterNonNull() {
        return (NStream)this.filter(Objects::nonNull).redescribe(NElementDescribables.ofDesc("nonNull"));
    }

    @Override
    public NStream<T> filterNonBlank() {
        return (NStream)this.filter(x -> !NBlankable.isBlank(x)).redescribe(NElementDescribables.ofDesc("nonBlank"));
    }

    @Override
    public NStream<T> coalesce(final NIterator<? extends T> other) {
        return new NStreamBase<T>(this.nutsBase){

            @Override
            public NIterator<T> iterator() {
                Iterator it = NStreamBase.this.iterator();
                List iterators = Arrays.asList(it, other);
                return NIteratorUtils.coalesce(iterators);
            }
        };
    }

    @Override
    public NStream<T> concat(final NIterator<? extends T> other) {
        return new NStreamBase<T>(this.nutsBase){

            @Override
            public NIterator<T> iterator() {
                Iterator it = NStreamBase.this.iterator();
                List iterators = Arrays.asList(it, other);
                return NIteratorUtils.concat(iterators);
            }
        };
    }

    @Override
    public NStream<T> coalesce(final NStream<? extends T> other) {
        return new NStreamBase<T>(this.nutsBase){

            @Override
            public NIterator<T> iterator() {
                Iterator it = NStreamBase.this.iterator();
                List iterators = Arrays.asList(it, other.iterator());
                return NIteratorUtils.coalesce(iterators);
            }
        };
    }

    @Override
    public NStream<T> concat(final NStream<? extends T> other) {
        return new NStreamBase<T>(this.nutsBase){

            @Override
            public NIterator<T> iterator() {
                Iterator it = NStreamBase.this.iterator();
                List iterators = Arrays.asList(it, other.iterator());
                return NIteratorUtils.concat(iterators);
            }
        };
    }

    @Override
    public boolean[] toBooleanArray() {
        Boolean[] b = (Boolean[])this.toArray(Boolean[]::new);
        boolean[] c = new boolean[b.length];
        for (int i = 0; i < b.length; ++i) {
            c[i] = b[i];
        }
        return c;
    }

    @Override
    public byte[] toByteArray() {
        Number[] b = (Number[])this.toArray(Number[]::new);
        byte[] c = new byte[b.length];
        for (int i = 0; i < b.length; ++i) {
            c[i] = b[i].byteValue();
        }
        return c;
    }

    @Override
    public char[] toCharArray() {
        Character[] b = (Character[])this.toArray(Character[]::new);
        char[] c = new char[b.length];
        for (int i = 0; i < b.length; ++i) {
            c[i] = b[i].charValue();
        }
        return c;
    }

    @Override
    public short[] toShortArray() {
        Short[] b = (Short[])this.toArray(Short[]::new);
        short[] c = new short[b.length];
        for (int i = 0; i < b.length; ++i) {
            c[i] = b[i];
        }
        return c;
    }

    @Override
    public float[] toFloatArray() {
        Float[] b = (Float[])this.toArray(Float[]::new);
        float[] c = new float[b.length];
        for (int i = 0; i < b.length; ++i) {
            c[i] = b[i].floatValue();
        }
        return c;
    }

    @Override
    public int[] toIntArray() {
        return this.mapToInt(x -> ((Number)x).intValue()).toArray();
    }

    @Override
    public long[] toLongArray() {
        return this.mapToLong(x -> ((Number)x).longValue()).toArray();
    }

    @Override
    public double[] toDoubleArray() {
        return this.mapToDouble(x -> ((Number)x).doubleValue()).toArray();
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super T> mapper) {
        return this.stream().mapToInt(mapper);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super T> mapper) {
        return this.stream().mapToLong(mapper);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        return this.stream().mapToDouble(mapper);
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.stream().toArray(generator);
    }

    @Override
    public <K, U> Map<K, U> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return this.stream().collect(Collectors.toMap(keyMapper, valueMapper));
    }

    @Override
    public <K, U> Map<K, U> toOrderedMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return this.stream().collect(Collectors.toMap(keyMapper, valueMapper, NStreamBase.throwingMerger(), LinkedHashMap::new));
    }

    @Override
    public <K, U> Map<K, U> toSortedMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return this.stream().collect(Collectors.toMap(keyMapper, valueMapper, NStreamBase.throwingMerger(), TreeMap::new));
    }

    @Override
    public <R> NStream<R> flatMapIter(final Function<? super T, ? extends Iterator<? extends R>> mapper) {
        return new NStreamBase<R>(this.nutsBase){

            @Override
            public NIterator<R> iterator() {
                return NIteratorBuilder.of(NStreamBase.this.iterator()).flatMap(mapper).build();
            }
        };
    }

    @Override
    public <R> NStream<R> flatMapList(final Function<? super T, ? extends List<? extends R>> mapper) {
        return new NStreamBase<R>(this.nutsBase){

            @Override
            public NIterator<R> iterator() {
                NIteratorBuilder r = NIteratorBuilder.of(NStreamBase.this.iterator());
                return r.flatMap(NFunction.of(tt -> ((List)mapper.apply(tt)).iterator()).redescribe(() -> NFunction.of(mapper).describe())).build();
            }
        };
    }

    @Override
    public <R> NStream<R> flatMapArray(final Function<? super T, ? extends R[]> mapper) {
        return new NStreamBase<R>(this.nutsBase){

            @Override
            public NIterator<R> iterator() {
                return NIteratorBuilder.of(NStreamBase.this.iterator()).flatMap(NFunction.of(t -> Arrays.asList((Object[])mapper.apply(t)).iterator()).redescribe(() -> NFunction.of(mapper).describe())).build();
            }
        };
    }

    @Override
    public <R> NStream<R> flatMap(final Function<? super T, ? extends Stream<? extends R>> mapper) {
        return new NStreamBase<R>(this.nutsBase){

            @Override
            public NIterator<R> iterator() {
                return (NIterator)NIteratorBuilder.of(NStreamBase.this.iterator()).flatMap(NFunction.of(t -> ((Stream)mapper.apply(t)).iterator())).build().redescribe(() -> NFunction.of(mapper).describe());
            }
        };
    }

    @Override
    public <R> NStream<R> flatMapStream(final Function<? super T, ? extends NStream<? extends R>> mapper) {
        return new NStreamBase<R>(this.nutsBase){

            @Override
            public NIterator<R> iterator() {
                return (NIterator)NIteratorBuilder.of(NStreamBase.this.iterator()).flatMap(NFunction.of(t -> ((NStream)mapper.apply(t)).iterator())).build().redescribe(() -> NFunction.of(mapper).describe());
            }
        };
    }

    @Override
    public <K> Map<K, List<T>> groupBy(Function<? super T, ? extends K> classifier) {
        Stream<? super T> it = this.stream();
        return it.collect(Collectors.groupingBy(classifier));
    }

    @Override
    public <K> NStream<Map.Entry<K, List<T>>> groupedBy(Function<? super T, ? extends K> classifier) {
        Stream<? super T> it = this.stream();
        Set<Map.Entry<K, List<T>>> entries = it.collect(Collectors.groupingBy(classifier)).entrySet();
        return new NStreamFromNIterator<Map.Entry<K, List<T>>>(this.nutsBase, (NIterator)NIterator.of(entries.iterator()).redescribe(() -> NElement.ofObjectBuilder().name("GroupBy").set("by", NFunction.of(classifier).describe()).set("base", this.iterator().describe()).build()));
    }

    @Override
    public NOptional<T> findAny() {
        return NOptional.ofOptional(this.stream().findAny(), () -> NMsg.ofC("missing : %s", this.nutsBase));
    }

    @Override
    public NOptional<T> findFirst() {
        Iterator it = this.iterator();
        if (it.hasNext()) {
            return NOptional.of(it.next());
        }
        return NOptional.ofEmpty(() -> this.nutsBase == null ? NMsg.ofPlain("missing first") : NMsg.ofC("missing first %s", this.nutsBase));
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        return this.stream().flatMapToDouble(mapper);
    }

    @Override
    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        return this.stream().flatMapToInt(mapper);
    }

    @Override
    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        return this.stream().flatMapToLong(mapper);
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        return this.stream().allMatch(predicate);
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        return this.stream().anyMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        return this.stream().noneMatch(predicate);
    }

    @Override
    public NStream<T> limit(long maxSize) {
        return NStream.ofStream(this.stream().limit(maxSize));
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        return this.stream().collect(supplier, accumulator, combiner);
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.stream().collect(collector);
    }

    @Override
    public NOptional<T> min(Comparator<? super T> comparator) {
        return NOptional.ofOptional(this.stream().min(comparator), () -> NMsg.ofC("missing : %s", this.nutsBase));
    }

    @Override
    public NOptional<T> max(Comparator<? super T> comparator) {
        return NOptional.ofOptional(this.stream().max(comparator), () -> NMsg.ofC("missing : %s", this.nutsBase));
    }

    @Override
    public NElement describe() {
        return this.iterator().describe();
    }

    @Override
    public NStream<T> redescribe(Supplier<NElement> description) {
        if (description == null) {
            return this;
        }
        return new NStreamWithDescription(this, description);
    }

    @Override
    public NStream<T> skip(final long n) {
        return new NStreamBase<T>(this.nutsBase){

            @Override
            public NIterator<T> iterator() {
                Iterator iterator = NStreamBase.this.iterator();
                int count = 0;
                while ((long)count < n) {
                    if (!iterator.hasNext()) {
                        return iterator;
                    }
                    iterator.next();
                    ++count;
                }
                return iterator;
            }
        };
    }

    @Override
    public <V> NStream<V> instanceOf(Class<V> type) {
        NAssert.requireNonNull(type, "type");
        return this.map(a -> {
            if (type.isInstance(a)) {
                return a;
            }
            return null;
        }).nonNull();
    }

    @Override
    public void close() {
    }
}

