/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.jclass;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.logging.Level;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdBuilder;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.artifact.NVersionFilter;
import net.thevpc.nuts.artifact.NVersionFilters;
import net.thevpc.nuts.artifact.NVersionInterval;
import net.thevpc.nuts.command.NExecCmd;
import net.thevpc.nuts.concurrent.NConcurrent;
import net.thevpc.nuts.core.NClassLoaderNode;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.platform.NPlatformFamily;
import net.thevpc.nuts.platform.NPlatformHome;
import net.thevpc.nuts.platform.NPlatformLocation;
import net.thevpc.nuts.runtime.standalone.util.NCoreLogUtils;
import net.thevpc.nuts.runtime.standalone.util.jclass.JavaClassByteCode;
import net.thevpc.nuts.runtime.standalone.util.jclass.JavaJarUtils;
import net.thevpc.nuts.runtime.standalone.util.jclass.NClassLoaderNodeExt;
import net.thevpc.nuts.runtime.standalone.workspace.DefaultNWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.config.NSdkLocationComparator;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NStringUtils;

public class NJavaSdkUtils {
    private final NWorkspace workspace;

    private NJavaSdkUtils(NWorkspace workspace) {
        this.workspace = workspace;
    }

    public static NJavaSdkUtils of(NWorkspace ws) {
        return new NJavaSdkUtils(ws);
    }

    public static List<NClassLoaderNodeExt> loadNutsClassLoaderNodeExts(NClassLoaderNode[] n, boolean java9) {
        ArrayList<NClassLoaderNodeExt> list = new ArrayList<NClassLoaderNodeExt>();
        for (NClassLoaderNode nn : n) {
            NJavaSdkUtils.fillNodes(nn, list, java9);
        }
        return list;
    }

    private static void fillNodes(NClassLoaderNode n, List<NClassLoaderNodeExt> list, boolean java9) {
        NClassLoaderNodeExt k = new NClassLoaderNodeExt();
        k.node = n;
        k.id = n.getId();
        k.path = NPath.of(n.getURL());
        if (java9) {
            k.moduleInfo = JavaJarUtils.parseModuleInfo(k.path);
            if (k.moduleInfo != null) {
                k.moduleName = k.moduleInfo.module_name;
                for (JavaClassByteCode.ModuleInfoRequired r : k.moduleInfo.required) {
                    if (!r.req_name.startsWith("javafx")) continue;
                    k.requiredJfx.add(r.req_name);
                }
            } else {
                k.moduleName = JavaJarUtils.parseDefaultModuleName(k.path);
            }
            k.jfx = k.moduleName != null && k.moduleName.startsWith("javafx");
        } else {
            k.jfx = k.id.getArtifactId().startsWith("javafx") && k.id.getGroupId().startsWith("org.openjfx");
        }
        list.add(k);
        for (NClassLoaderNode d : n.getDependencies()) {
            NJavaSdkUtils.fillNodes(d, list, java9);
        }
    }

    public static boolean isJava(NId id) {
        if (id != null) {
            return NPlatformFamily.JAVA == NPlatformFamily.parse(id.getArtifactId()).orNull();
        }
        return false;
    }

    protected NLog _LOG() {
        return NLog.of(NJavaSdkUtils.class);
    }

    public Predicate<String> createVersionFilterPredicate(String requestedJavaVersion) {
        NVersionFilter versionFilter = this.createVersionFilter(requestedJavaVersion);
        return this.createVersionFilterPredicate(versionFilter);
    }

    public Predicate<String> createVersionFilterPredicate(final NVersionFilter versionFilter) {
        return new Predicate<String>(){

            @Override
            public boolean test(String sVersion) {
                String sVersion2;
                NVersion version2;
                NLiteral p;
                NVersion version = NVersion.get(sVersion).get();
                if (versionFilter.acceptVersion(version)) {
                    return true;
                }
                int a = sVersion.indexOf(46);
                return a > 0 && (p = NLiteral.of(sVersion.substring(0, a))).asInt().isPresent() && p.asInt().get() == 1 && versionFilter.acceptVersion(version2 = NVersion.get(sVersion2 = sVersion.substring(a + 1)).get());
            }
        };
    }

    public NVersionFilter createVersionFilter(String requestedJavaVersion) {
        NVersion vv = NVersion.get(requestedJavaVersion = NStringUtils.trim(requestedJavaVersion)).get();
        String singleVersion = vv.asSingleValue().orNull();
        if (singleVersion != null) {
            requestedJavaVersion = "[" + singleVersion + ",[";
        }
        return NVersionFilters.of().byValue(requestedJavaVersion).get();
    }

    public NPlatformLocation resolveJdkLocation(String requestedJavaVersion) {
        NVersionFilter requestedVersionFilter = this.createVersionFilter(requestedJavaVersion);
        NPlatformLocation bestJava = this.workspace.findPlatformByVersion(NPlatformFamily.JAVA, requestedVersionFilter).orNull();
        if (bestJava == null) {
            String appSuffix = NWorkspace.of().getOsFamily() == NOsFamily.WINDOWS ? ".exe" : "";
            String packaging = "jre";
            if (new File(System.getProperty("java.home"), "bin" + File.separator + "javac" + appSuffix).isFile()) {
                packaging = "jdk";
            }
            String product = "JDK";
            NPlatformLocation current = new NPlatformLocation(NWorkspace.of().getPlatform(), product, product + "-" + System.getProperty("java.version"), System.getProperty("java.home"), System.getProperty("java.version"), packaging, 0);
            current.setConfigVersion(DefaultNWorkspace.VERSION_SDK_LOCATION);
            NVersionFilter requestedJavaVersionFilter = NVersion.get(NStringUtils.trim(requestedJavaVersion)).get().filter();
            if (requestedJavaVersionFilter == null || requestedJavaVersionFilter.acceptVersion(NVersion.get(current.getVersion()).get())) {
                bestJava = current;
            }
            if (bestJava == null) {
                if (!NBlankable.isBlank(requestedJavaVersion)) {
                    this._LOG().log(NMsg.ofJ("no valid JRE found. recommended {0} . Using default java.home at {1}", requestedJavaVersion, System.getProperty("java.home")).asFineAlert());
                } else {
                    this._LOG().log(NMsg.ofJ("no valid JRE found. Using default java.home at {0}", System.getProperty("java.home")).asFineAlert());
                }
                bestJava = current;
            }
        }
        String sVersion = bestJava.getVersion();
        if (this.createVersionFilterPredicate(requestedVersionFilter).test(sVersion)) {
            return bestJava;
        }
        this._LOG().log(NMsg.ofJ("no valid JRE found for version {0}", requestedJavaVersion).asFineAlert());
        return null;
    }

    public NPlatformLocation[] searchJdkLocations() {
        String[] conf = new String[]{};
        switch (NWorkspace.of().getOsFamily()) {
            case LINUX: 
            case UNIX: 
            case UNKNOWN: {
                conf = new String[]{"/usr/java", "/usr/lib64/jvm", "/usr/lib/jvm"};
                break;
            }
            case WINDOWS: {
                conf = new String[]{NPlatformHome.USER.getWindowsProgramFiles() + "\\Java", NPlatformHome.USER.getWindowsProgramFilesX86() + "\\Java"};
                break;
            }
            case MACOS: {
                conf = new String[]{"/Library/Java/JavaVirtualMachines", "/System/Library/Frameworks/JavaVM.framework"};
            }
        }
        ArrayList<NPlatformLocation> all = new ArrayList<NPlatformLocation>();
        for (String s : conf) {
            all.addAll(Arrays.asList(this.searchJdkLocations(NPath.of(s))));
        }
        return all.toArray(new NPlatformLocation[0]);
    }

    public Future<NPlatformLocation[]> searchJdkLocationsFuture() {
        LinkedHashSet<String> conf = new LinkedHashSet<String>();
        NPath file = NPath.of(System.getProperty("java.home")).normalize();
        ArrayList<Future<NPlatformLocation[]>> all = new ArrayList<Future<NPlatformLocation[]>>();
        NPlatformLocation base = this.resolveJdkLocation(file, null);
        if (base != null) {
            all.add(CompletableFuture.completedFuture(new NPlatformLocation[]{base}));
        }
        switch (NWorkspace.of().getOsFamily()) {
            case LINUX: 
            case UNIX: 
            case UNKNOWN: {
                conf.addAll(Arrays.asList("/usr/java", "/usr/lib64/jvm", "/usr/lib/jvm"));
                break;
            }
            case WINDOWS: {
                conf.addAll(Arrays.asList(NPlatformHome.USER.getWindowsProgramFiles() + "\\Java", NPlatformHome.USER.getWindowsProgramFilesX86() + "\\Java"));
                break;
            }
            case MACOS: {
                conf.addAll(Arrays.asList("/Library/Java/JavaVirtualMachines", "/System/Library/Frameworks/JavaVM.framework"));
            }
        }
        for (String s : conf) {
            all.add(this.searchJdkLocationsFuture(NPath.of(s)));
        }
        return NConcurrent.of().executorService().submit(() -> {
            ArrayList<NPlatformLocation> locs = new ArrayList<NPlatformLocation>();
            for (Future nutsSdkLocationFuture : all) {
                NPlatformLocation[] e = (NPlatformLocation[])nutsSdkLocationFuture.get();
                if (e == null) continue;
                locs.addAll(Arrays.asList(e));
            }
            locs.sort(new NSdkLocationComparator());
            return locs.toArray(new NPlatformLocation[0]);
        });
    }

    public NPlatformLocation[] searchJdkLocations(NPath loc) {
        ArrayList<NPlatformLocation> all = new ArrayList<NPlatformLocation>();
        if (loc.isDirectory()) {
            for (NPath d : loc.list()) {
                NPlatformLocation r = this.resolveJdkLocation(d, null);
                if (r == null) continue;
                all.add(r);
            }
        }
        all.sort(new NSdkLocationComparator());
        return all.toArray(new NPlatformLocation[0]);
    }

    public Future<NPlatformLocation[]> searchJdkLocationsFuture(NPath s) {
        ArrayList<Future<NPlatformLocation>> all = new ArrayList<Future<NPlatformLocation>>();
        if (s == null) {
            return CompletableFuture.completedFuture(new NPlatformLocation[0]);
        }
        if (s.isDirectory()) {
            for (NPath d : s.list()) {
                all.add(NConcurrent.of().executorService().submit(() -> {
                    NPlatformLocation r;
                    block5: {
                        r = null;
                        try {
                            r = this.resolveJdkLocation(d, null);
                            if (r == null) break block5;
                            NWorkspace nWorkspace = this.workspace;
                            synchronized (nWorkspace) {
                                NTexts factory = NTexts.of();
                                this.workspace.currentSession().getTerminal().printProgress(NMsg.ofC("detected java %s %s at %s", r.getPackaging(), factory.ofStyled(r.getVersion(), NTextStyle.version()), NCoreLogUtils.forProgressPathString(r.getPath())));
                            }
                        }
                        catch (Exception ex) {
                            this._LOG().log(NMsg.ofC("error: %s", ex).asError(ex));
                        }
                    }
                    return r;
                }));
            }
        }
        return NConcurrent.of().executorService().submit(() -> {
            ArrayList<NPlatformLocation> locs = new ArrayList<NPlatformLocation>();
            for (Future nutsSdkLocationFuture : all) {
                NPlatformLocation e = (NPlatformLocation)nutsSdkLocationFuture.get();
                if (e == null) continue;
                locs.add(e);
            }
            this.workspace.currentSession().getTerminal().printProgress(NMsg.ofPlain(""));
            return locs.toArray(new NPlatformLocation[0]);
        });
    }

    public String detectJdkProvider(String name) {
        for (String s : new String[]{"bellsoft:Bellsoft", "oracle:Oracle", "openj9:Eclipse OpenJ9", "liberica:Bellsoft Liberica", "sap:SAP", "graalvm:GraalVM", "temurin:IBM Temurin", "sapmachine:SAP Machine", "corretto:Amazon Corretto", "jbr:Jetbrains", "azul:Azul Zulu", "zulu:Azul Zulu", "semeru:IBM Semeru"}) {
            String[] t = s.split(":");
            if (!name.toLowerCase().matches(".*\\b" + t[0].toLowerCase() + "\\b.*")) continue;
            return t[1];
        }
        return null;
    }

    public NPlatformLocation resolveJdkLocation(NPath path, String preferredName) {
        NAssert.requireNonBlank(path, "path");
        String appSuffix = NWorkspace.of().getOsFamily() == NOsFamily.WINDOWS ? ".exe" : "";
        NPath bin = path.resolve("bin");
        NPath javaExePath = bin.resolve("java" + appSuffix);
        if (!javaExePath.isRegularFile()) {
            return null;
        }
        String product = null;
        String jdkVersion = null;
        String cmdOutputString = null;
        int cmdRresult = 0;
        boolean loggedError = false;
        try {
            int MAX_ITER = 5;
            for (int i = 0; i < 5; ++i) {
                NExecCmd cmd = NExecCmd.of().system().addCommand(javaExePath.toString(), "-version").grabAll().failFast().run();
                cmdRresult = cmd.getResultCode();
                cmdOutputString = cmd.getGrabbedOutString();
                if (!cmdOutputString.isEmpty()) break;
                this._LOG().log(NMsg.ofJ("unable to execute {0}. returned empty string ({1}/{2})", javaExePath, i + 1, 5).withLevel(i == 4 ? Level.WARNING : Level.FINER).withIntent(NMsgIntent.ALERT));
            }
            if (!cmdOutputString.isEmpty()) {
                String uu;
                int j;
                String prefix = "java version \"";
                int i = cmdOutputString.indexOf(prefix);
                if (i >= 0) {
                    j = cmdOutputString.indexOf("\"", i += prefix.length());
                    if (i >= 0) {
                        jdkVersion = cmdOutputString.substring(i, j);
                        product = "JDK";
                    }
                }
                if (jdkVersion == null && (i = cmdOutputString.indexOf(prefix = "openjdk version \"")) >= 0) {
                    j = cmdOutputString.indexOf("\"", i += prefix.length());
                    if (i > 0) {
                        jdkVersion = cmdOutputString.substring(i, j);
                        product = "OpenJDK";
                    }
                }
                if ((uu = this.detectJdkProvider(path.getName())) != null) {
                    product = product + " " + uu.trim();
                }
            }
        }
        catch (Exception ex) {
            loggedError = true;
            this._LOG().log(NMsg.ofJ("unable to execute {0}. JDK Home ignored", javaExePath).asErrorAlert(ex));
        }
        if (jdkVersion == null) {
            if (!loggedError) {
                this._LOG().log(NMsg.ofJ("execute {0} failed with result code {1} and result string \"{2}\". JDK Home ignored", javaExePath.toString(), cmdRresult, cmdOutputString).withLevel(Level.SEVERE).withIntent(NMsgIntent.ALERT));
            }
            return null;
        }
        String packaging = "jre";
        if (bin.resolve("javac" + appSuffix).isRegularFile() && bin.resolve("jps" + appSuffix).isRegularFile()) {
            packaging = "jdk";
        }
        preferredName = NBlankable.isBlank(preferredName) ? product + "-" + jdkVersion : NStringUtils.trim(preferredName);
        NPlatformLocation r = new NPlatformLocation(NWorkspaceUtils.of(this.workspace).createSdkId("java", jdkVersion), product, preferredName, path.toString(), jdkVersion, packaging, 0);
        r.setConfigVersion(DefaultNWorkspace.VERSION_SDK_LOCATION);
        return r;
    }

    public NId createJdkId(String version) {
        NAssert.requireNonBlank(version, "version");
        NVersion jv = NVersion.get(version).get();
        long n1 = jv.getNumberLiteralAt(0).flatMap(NLiteral::asLong).orElse(0L);
        long n2 = jv.getNumberLiteralAt(1).flatMap(NLiteral::asLong).orElse(0L);
        long classFileId = 0L;
        String standard = n1 + "." + n2;
        if (n1 == 1L) {
            classFileId = 44L + n2;
        }
        if (classFileId == 0L) {
            classFileId = 52L;
        }
        return NIdBuilder.of().setArtifactId("java").setProperty("s", standard).setProperty("c", String.valueOf(classFileId)).setVersion(version).build();
    }

    public String resolveJavaCommandByVersion(String requestedJavaVersion, boolean javaw) {
        NPlatformLocation nutsPlatformLocation = this.resolveJdkLocation(requestedJavaVersion);
        return this.resolveJavaCommandByVersion(nutsPlatformLocation, javaw);
    }

    public String resolveJavaCommandByVersion(NPlatformLocation nutsPlatformLocation, boolean javaw) {
        boolean winOs;
        if (nutsPlatformLocation == null) {
            return null;
        }
        String bestJavaPath = nutsPlatformLocation.getPath();
        NPath file = NPath.of(bestJavaPath).toAbsolute(NWorkspace.of().getWorkspaceLocation());
        boolean bl = winOs = NWorkspace.of().getOsFamily() == NOsFamily.WINDOWS;
        bestJavaPath = winOs ? (javaw ? file.resolve("bin").resolve("javaw.exe").toString() : file.resolve("bin").resolve("java.exe").toString()) : file.resolve("bin").resolve("java").toString();
        return bestJavaPath;
    }

    public static int normalizeJavaVersionAsInt(NVersion version) {
        if (version == null) {
            return -1;
        }
        int min = -1;
        for (NVersionInterval nVersionInterval : (List)version.filter().intervals().orElse(new ArrayList())) {
            String lowerBound = nVersionInterval.getLowerBound();
            String upperBound = nVersionInterval.getLowerBound();
            int m = NJavaSdkUtils.normalizeJavaVersionAsInt0(lowerBound);
            if (m > 0 && min < m) {
                min = m;
            }
            if ((m = NJavaSdkUtils.normalizeJavaVersionAsInt0(upperBound)) <= 0 || min >= m) continue;
            min = m;
        }
        return min;
    }

    private static int normalizeJavaVersionAsInt0(String sVersion) {
        if (sVersion == null) {
            return -1;
        }
        NVersion v = NVersion.of(sVersion);
        int i1 = v.getIntegerAt(0).orElse(0);
        int i2 = v.getIntegerAt(1).orElse(0);
        if (i1 <= 0) {
            return -1;
        }
        if (i1 == 1) {
            if (i2 <= 1) {
                return i1;
            }
            return i2;
        }
        return -1;
    }

    public String resolveJavaCommandByHome(String javaHome) {
        String appSuffix = NWorkspace.of().getOsFamily() == NOsFamily.WINDOWS ? ".exe" : "";
        String exe = "java" + appSuffix;
        if ((javaHome == null || javaHome.isEmpty()) && (NBlankable.isBlank(javaHome = System.getProperty("java.home")) || "null".equals(javaHome))) {
            return exe;
        }
        return javaHome + File.separator + "bin" + File.separator + exe;
    }
}

