/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.jclass;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NVisitResult;
import net.thevpc.nuts.util.NIllegalArgumentException;

public class JavaClassByteCode {
    private static final int FLAG_UTF = 1;
    private static final int FLAG_FLOAT = 4;
    private static final int FLAG_INT = 3;
    private static final int FLAG_LONG = 5;
    private static final int FLAG_DOUBLE = 6;
    private static final int FLAG_CLASS = 7;
    private static final int FLAG_FIELD_REF = 9;
    private static final int FLAG_STRING = 8;
    private static final int FLAG_METHOD_REF = 10;
    private static final int FLAG_INTERFACE_METHOD_REF = 11;
    private static final int FLAG_NAME_AND_TYPE = 12;
    private static final int FLAG_METHOD_HANDLE = 15;
    private static final int FLAG_METHOD_TYPE = 16;
    private static final int FLAG_INVOKE_DYNAMIC = 18;
    private static final int FLAG_MODULE = 19;
    private static final int FLAG_PACKAGE = 20;
    private final DataInputStream stream;
    private final Visitor visitor;
    private Constant[] constants = new Constant[32];

    public JavaClassByteCode(InputStream stream) {
        this(stream, null);
    }

    public JavaClassByteCode(DataInputStream stream) {
        this(stream, null);
    }

    public JavaClassByteCode(InputStream stream, Visitor visitor) {
        this(stream instanceof DataInputStream ? (DataInputStream)stream : new DataInputStream(stream), visitor);
    }

    public JavaClassByteCode(DataInputStream stream, Visitor visitor) {
        this.stream = stream;
        this.visitor = visitor;
        try {
            int signature = stream.readInt();
            if (signature != -889275714) {
                throw new NIllegalArgumentException(NMsg.ofPlain("invalid Java signature"));
            }
            int minorVersion = stream.readUnsignedShort();
            int majorVersion = stream.readUnsignedShort();
            if (this.visitVersion(majorVersion, minorVersion) == NVisitResult.TERMINATE) {
                return;
            }
            this.readConstantPool();
            int accessFlags = stream.readUnsignedShort();
            int thisClassIndex = stream.readUnsignedShort();
            String thisClass = this.getConstant(thisClassIndex).asString();
            int superClassIndex = stream.readUnsignedShort();
            String superClass = superClassIndex == 0 ? null : this.getConstant(superClassIndex).asString();
            int interfacesCount = stream.readUnsignedShort();
            String[] interfaces = new String[interfacesCount];
            for (int i = 0; i < interfacesCount; ++i) {
                int index = stream.readUnsignedShort();
                interfaces[i] = this.getConstant(index).asString();
            }
            if (this.visitClassDeclaration(accessFlags, thisClass, superClass, interfaces) == NVisitResult.TERMINATE) {
                return;
            }
            int fieldsCount = stream.readUnsignedShort();
            for (int i = 0; i < fieldsCount; ++i) {
                if (this.readField() != NVisitResult.TERMINATE) continue;
                return;
            }
            int methodsCount = stream.readUnsignedShort();
            for (int i = 0; i < methodsCount; ++i) {
                if (this.readMethod() != NVisitResult.TERMINATE) continue;
                return;
            }
            int attributesCount = stream.readUnsignedShort();
            for (int i = 0; i < attributesCount; ++i) {
                DataInputStream q;
                ClassAttribute a = new ClassAttribute();
                if (a.entry.valString.equals("Module")) {
                    q = new DataInputStream(new ByteArrayInputStream(a.raw));
                    ModuleInfo mi = new ModuleInfo();
                    mi.module_name = this.getConstantModule(q.readUnsignedShort());
                    mi.module_flags = q.readUnsignedShort();
                    mi.module_version = this.getConstantUTF(q.readUnsignedShort());
                    int requires_count = q.readUnsignedShort();
                    mi.required = new ModuleInfoRequired[requires_count];
                    for (int j = 0; j < requires_count; ++j) {
                        ModuleInfoRequired rr = new ModuleInfoRequired();
                        rr.req_name = this.getConstantModule(q.readUnsignedShort());
                        rr.req_flags = q.readUnsignedShort();
                        rr.req_version = this.getConstantUTF(q.readUnsignedShort());
                        mi.required[j] = rr;
                    }
                    if (this.visitClassAttributeModule(mi) == NVisitResult.TERMINATE) {
                        return;
                    }
                }
                if (a.entry.valString.equals("RuntimeVisibleAnnotations") || a.entry.valString.equals("RuntimeInvisibleAnnotations")) {
                    q = new DataInputStream(new ByteArrayInputStream(a.raw));
                    int numAnnotations = q.readUnsignedShort();
                    for (int j = 0; j < numAnnotations; ++j) {
                        if (this.visitClassAnnotation(this.readAnnotation(q)) != NVisitResult.TERMINATE) continue;
                        return;
                    }
                }
                if (this.visitClassAttribute(thisClass, a) != NVisitResult.TERMINATE) continue;
                return;
            }
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    private AnnotationInfo readAnnotation(DataInputStream q) throws IOException {
        String type = this.getConstantUTF(q.readUnsignedShort());
        int numPairs = q.readUnsignedShort();
        LinkedHashMap<String, Object> elements = new LinkedHashMap<String, Object>();
        for (int i = 0; i < numPairs; ++i) {
            String elementName = this.getConstantUTF(q.readUnsignedShort());
            Object value = this.readElementValue(q);
            elements.put(elementName, value);
        }
        AnnotationInfo ai = new AnnotationInfo();
        ai.name = type;
        ai.args = elements;
        return ai;
    }

    private Object readElementValue(DataInputStream q) throws IOException {
        char tag = (char)q.readUnsignedByte();
        switch (tag) {
            case 's': {
                return this.getConstantUTF(q.readUnsignedShort());
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return this.getConstant(q.readUnsignedShort());
            }
            case 'e': {
                String typeName = this.getConstantUTF(q.readUnsignedShort());
                String constName = this.getConstantUTF(q.readUnsignedShort());
                return typeName + "." + constName;
            }
            case 'c': {
                return this.getConstantUTF(q.readUnsignedShort());
            }
            case '@': {
                return this.readAnnotation(q);
            }
            case '[': {
                int count = q.readUnsignedShort();
                ArrayList<Object> arr = new ArrayList<Object>();
                for (int i = 0; i < count; ++i) {
                    arr.add(this.readElementValue(q));
                }
                return arr;
            }
        }
        throw new UncheckedIOException(new IOException("Unknown annotation tag: " + tag));
    }

    private NVisitResult visitClassAnnotation(AnnotationInfo annotationInfo) {
        if (this.visitor != null) {
            return this.visitor.visitClassAnnotation(annotationInfo);
        }
        return NVisitResult.CONTINUE;
    }

    private NVisitResult visitClassAttribute(String thisClass, ClassAttribute a) {
        return NVisitResult.CONTINUE;
    }

    private NVisitResult visitClassAttributeModule(ModuleInfo mi) {
        if (this.visitor != null) {
            return this.visitor.visitClassAttributeModule(mi);
        }
        return NVisitResult.CONTINUE;
    }

    protected void readConstantPool() {
        try {
            int count = this.stream.readUnsignedShort();
            this.ensureConstants(count * 2);
            for (int i = 1; i < count; ++i) {
                Constant cst = this.getConstant(i, true);
                cst.read(this.stream, this);
                if (cst.tag != 6 && cst.tag != 5) continue;
                ++i;
            }
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    protected NVisitResult readField() {
        try {
            int accessFlags = this.stream.readUnsignedShort();
            int nameIndex = this.stream.readUnsignedShort();
            String name = this.getConstant(nameIndex).asString();
            int descriptorIndex = this.stream.readUnsignedShort();
            String descriptor = this.getConstant(descriptorIndex).asString();
            int attributeCount = this.stream.readUnsignedShort();
            FieldAttribute[] attributes = new FieldAttribute[attributeCount];
            for (int i = 0; i < attributeCount; ++i) {
                attributes[i] = new FieldAttribute();
            }
            return this.visitField(accessFlags, name, descriptor, attributes);
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    protected NVisitResult readMethod() {
        try {
            int accessFlags = this.stream.readUnsignedShort();
            int nameIndex = this.stream.readUnsignedShort();
            String name = this.getConstant(nameIndex).asString();
            int descriptorIndex = this.stream.readUnsignedShort();
            String descriptor = this.getConstant(descriptorIndex).asString();
            int attributeCount = this.stream.readUnsignedShort();
            MethodAttribute[] attributes = new MethodAttribute[attributeCount];
            for (int i = 0; i < attributeCount; ++i) {
                attributes[i] = new MethodAttribute();
            }
            return this.visitMethod(accessFlags, name, descriptor, attributes);
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    public String getConstantUTF(int index) throws IOException {
        Constant a = this.getConstant(index);
        if (a == null) {
            return null;
        }
        if (a.tag != 1) {
            throw new IllegalArgumentException("expected UTF");
        }
        return a.valString;
    }

    public String getConstantModule(int index) throws IOException {
        Constant a = this.getConstant(index);
        if (a == null) {
            return null;
        }
        if (a.tag != 19) {
            throw new IllegalArgumentException("expected MODULE");
        }
        if (a.valName.tag != 1) {
            throw new IllegalArgumentException("expected UTF");
        }
        return a.valName.valString;
    }

    public Constant getConstant(int index) throws IOException {
        if (index == 0) {
            return null;
        }
        Constant e = this.getConstant(index, false);
        if (e == null) {
            throw new IllegalArgumentException("jvm constant not found at index " + index);
        }
        return e;
    }

    public Constant getConstant(int index, boolean createNew) throws IOException {
        Constant cst;
        boolean tooBig = index >= this.constants.length;
        Constant constant = cst = tooBig ? null : this.constants[index];
        if (cst == null && createNew) {
            cst = new Constant(index);
            if (tooBig) {
                this.ensureConstants(index + 1);
            }
            this.constants[index] = cst;
        }
        return cst;
    }

    public NVisitResult visitVersion(int major, int minor) {
        if (this.visitor != null) {
            return this.visitor.visitVersion(major, minor);
        }
        return NVisitResult.CONTINUE;
    }

    public NVisitResult visitClassDeclaration(int accessFlags, String thisClass, String superClass, String[] interfaces) {
        if (this.visitor != null) {
            return this.visitor.visitClassDeclaration(accessFlags, thisClass, superClass, interfaces);
        }
        return NVisitResult.CONTINUE;
    }

    public NVisitResult visitField(int accessFlags, String name, String descriptor, FieldAttribute[] attributes) {
        if (this.visitor != null) {
            return this.visitor.visitField(accessFlags, name, descriptor);
        }
        return NVisitResult.CONTINUE;
    }

    public NVisitResult visitMethod(int accessFlags, String name, String descriptor, MethodAttribute[] attributes) {
        if (this.visitor != null) {
            return this.visitor.visitMethod(accessFlags, name, descriptor);
        }
        return NVisitResult.CONTINUE;
    }

    private void ensureConstants(int size) {
        int len = this.constants.length;
        if (len < size) {
            int len2 = size + 32;
            Constant[] n = new Constant[len2];
            System.arraycopy(this.constants, 0, n, 0, len);
            this.constants = n;
        }
    }

    public static interface Visitor {
        default public NVisitResult visitVersion(int major, int minor) {
            return NVisitResult.CONTINUE;
        }

        default public NVisitResult visitClassDeclaration(int accessFlags, String thisClass, String superClass, String[] interfaces) {
            return NVisitResult.CONTINUE;
        }

        default public NVisitResult visitField(int accessFlags, String name, String descriptor) {
            return NVisitResult.CONTINUE;
        }

        default public NVisitResult visitMethod(int accessFlags, String name, String descriptor) {
            return NVisitResult.CONTINUE;
        }

        default public NVisitResult visitClassAttributeModule(ModuleInfo mi) {
            return NVisitResult.CONTINUE;
        }

        default public NVisitResult visitClassAnnotation(AnnotationInfo annotationInfo) {
            return NVisitResult.CONTINUE;
        }
    }

    public static class Constant {
        int index;
        int tag;
        int valKind;
        Constant valName;
        Constant valRef;
        int valInt;
        float valFloat;
        long valLong;
        double valDouble;
        String valString;

        public Constant(int entryId) {
            this.index = entryId;
        }

        void read(DataInputStream stream, JavaClassByteCode s) {
            try {
                this.tag = stream.readUnsignedByte();
                switch (this.tag) {
                    case 1: {
                        int length = stream.readUnsignedShort();
                        byte[] bytes = new byte[length];
                        stream.readFully(bytes);
                        this.valString = new String(bytes, StandardCharsets.UTF_8);
                        break;
                    }
                    case 3: {
                        this.valInt = stream.readInt();
                        break;
                    }
                    case 4: {
                        this.valFloat = stream.readFloat();
                        break;
                    }
                    case 5: {
                        this.valLong = stream.readLong();
                        break;
                    }
                    case 6: {
                        this.valDouble = stream.readDouble();
                        break;
                    }
                    case 7: {
                        int index = stream.readUnsignedShort();
                        this.valRef = s.getConstant(index, true);
                        break;
                    }
                    case 8: {
                        int index = stream.readUnsignedShort();
                        this.valRef = s.getConstant(index, true);
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        int classIndex = stream.readUnsignedShort();
                        int nameAndTypeIndex = stream.readUnsignedShort();
                        this.valName = s.getConstant(classIndex, true);
                        this.valRef = s.getConstant(nameAndTypeIndex, true);
                        break;
                    }
                    case 15: {
                        this.valKind = stream.readUnsignedByte();
                        if (this.valKind < 1 || this.valKind > 9) {
                            throw new IllegalArgumentException("Unsupported");
                        }
                        this.valRef = s.getConstant(stream.readUnsignedShort(), true);
                        break;
                    }
                    case 16: {
                        this.valRef = s.getConstant(stream.readUnsignedShort(), true);
                        break;
                    }
                    case 18: {
                        this.valKind = stream.readUnsignedShort();
                        this.valRef = s.getConstant(stream.readUnsignedShort(), true);
                        break;
                    }
                    case 19: 
                    case 20: {
                        this.valName = s.getConstant(stream.readUnsignedShort(), true);
                        break;
                    }
                    default: {
                        throw new IOException("Unknown constant tag: " + this.tag);
                    }
                }
            }
            catch (IOException ex) {
                throw new NIOException(ex);
            }
        }

        public String asString() {
            switch (this.tag) {
                case 1: {
                    if (this.valString == null) {
                        throw new IllegalArgumentException("Expected String");
                    }
                    return this.valString;
                }
                case 7: {
                    return this.valRef.asString();
                }
                case 10: {
                    return this.valName.asString();
                }
            }
            throw new IllegalArgumentException("Unsupported");
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Constant[" + this.index + "]{");
            sb.append("tag=").append(this.tag).append(", ");
            switch (this.tag) {
                case 1: {
                    sb.append("UTF, ");
                    sb.append(this.valString);
                    break;
                }
                case 3: {
                    sb.append("INT, ");
                    sb.append(this.valInt);
                    break;
                }
                case 4: {
                    sb.append("FLOAT, ");
                    sb.append(this.valFloat);
                    break;
                }
                case 5: {
                    sb.append("LONG, ");
                    sb.append(this.valLong);
                    break;
                }
                case 6: {
                    sb.append("DOUBLE, ");
                    sb.append(this.valDouble);
                    break;
                }
                case 7: {
                    sb.append("CLASS, ");
                    sb.append(this.valRef);
                    break;
                }
                case 8: {
                    sb.append("STRING, ");
                    sb.append(this.valRef);
                    break;
                }
                case 16: {
                    sb.append("METHOD_TYPE, ");
                    sb.append(this.valRef);
                    break;
                }
                case 9: {
                    sb.append("FIELD_REF, ");
                    sb.append(this.valName).append(" ").append(this.valRef);
                    break;
                }
                case 11: {
                    sb.append("INTERFACE_METHOD_REF, ");
                    sb.append(this.valName).append(" ").append(this.valRef);
                    break;
                }
                case 18: {
                    sb.append("INVOKE_DYNAMIC, ");
                    sb.append(this.valKind).append(" ").append(this.valRef);
                    break;
                }
                case 15: {
                    sb.append("METHOD_HANDLE, ");
                    sb.append(this.valName).append(" ").append(this.valRef);
                    break;
                }
                case 10: {
                    sb.append("METHOD_REF, ");
                    sb.append(this.valName).append(" ").append(this.valRef);
                    break;
                }
                case 12: {
                    sb.append("NAME_AND_TYPE, ");
                    sb.append(this.valName).append(" ").append(this.valRef);
                    break;
                }
                case 19: {
                    sb.append("MODULE, ");
                    sb.append(this.valName);
                    break;
                }
                case 20: {
                    sb.append("PACKAGE, ");
                    sb.append(this.valName);
                }
            }
            sb.append('}');
            return sb.toString();
        }
    }

    public class ClassAttribute {
        int nameIndex;
        Constant entry;
        byte[] raw;

        public ClassAttribute() {
            try {
                this.nameIndex = JavaClassByteCode.this.stream.readUnsignedShort();
                this.entry = JavaClassByteCode.this.getConstant(this.nameIndex);
                if (this.entry.tag != 1) {
                    throw new IOException("unexpected");
                }
                int n = JavaClassByteCode.this.stream.readInt();
                this.raw = new byte[n];
                JavaClassByteCode.this.stream.readFully(this.raw);
            }
            catch (IOException ex) {
                throw new NIOException(ex);
            }
        }
    }

    public static class ModuleInfo {
        public String module_name;
        public int module_flags;
        public String module_version;
        ModuleInfoRequired[] required;
    }

    public static class ModuleInfoRequired {
        public String req_name;
        public int req_flags;
        public String req_version;
    }

    public static class AnnotationInfo {
        public String name;
        Map<String, Object> args;
    }

    public class FieldAttribute {
        Constant entry;
        Constant signature;
        Constant entry2;

        public FieldAttribute() throws IOException {
            int nameIndex = JavaClassByteCode.this.stream.readUnsignedShort();
            this.entry = JavaClassByteCode.this.getConstant(nameIndex);
            if (this.entry.tag != 1) {
                throw new IOException("unexpected");
            }
            JavaClassByteCode.this.stream.skipBytes(JavaClassByteCode.this.stream.readInt());
        }
    }

    public class MethodAttribute {
        Constant entry;
        Constant signature;
        Constant entry2;
        Constant[] exceptions;

        private MethodAttribute() throws IOException {
            int nameIndex = JavaClassByteCode.this.stream.readUnsignedShort();
            this.entry = JavaClassByteCode.this.getConstant(nameIndex);
            if (this.entry.tag != 1) {
                throw new IOException("unexpected");
            }
            JavaClassByteCode.this.stream.skipBytes(JavaClassByteCode.this.stream.readInt());
        }
    }

    public class CodeAttribute {
        public CodeAttribute() throws IOException {
            int nameIndex = JavaClassByteCode.this.stream.readUnsignedShort();
            Constant entry = JavaClassByteCode.this.getConstant(nameIndex);
            if (entry.tag != 1) {
                throw new IOException("unexpected");
            }
            JavaClassByteCode.this.stream.skipBytes(JavaClassByteCode.this.stream.readInt());
        }
    }
}

