/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.filters;

import net.thevpc.nuts.artifact.NTypedFilters;
import net.thevpc.nuts.runtime.standalone.util.filters.AbstractFilterParser2;
import net.thevpc.nuts.util.NFilter;

public abstract class NTypedFiltersParser<T extends NFilter>
extends AbstractFilterParser2<T> {
    public NTypedFiltersParser(String str) {
        super(str == null ? "" : str);
        this.addBoolOps();
    }

    @Override
    protected T nextDefault() {
        return this.getTManager().always();
    }

    protected abstract NTypedFilters<T> getTManager();

    @Override
    protected T buildPreOp(String op, T a) {
        if (a == null) {
            return this.getTManager().never();
        }
        return (T)a.neg();
    }

    @Override
    protected T buildBinOp(String op, T a, T r) {
        if (r == null) {
            throw new IllegalArgumentException("expected second operand");
        }
        switch (op) {
            case "&": 
            case "&&": {
                return (T)a.and((NFilter)r);
            }
            case "|": 
            case "||": {
                return (T)a.or((NFilter)r);
            }
        }
        throw new IllegalArgumentException("unexpected bin op " + op);
    }

    @Override
    protected T wordToPredicate(String word) {
        switch (word.toLowerCase()) {
            case "any": 
            case "always": {
                return this.getTManager().always();
            }
            case "none": 
            case "never": {
                return this.getTManager().never();
            }
        }
        throw new IllegalArgumentException("unsupported predicate name " + word);
    }
}

