/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.filters;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.thevpc.nuts.app.NApp;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NDefinitionFilters;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyFilter;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NEnvCondition;
import net.thevpc.nuts.artifact.NFilters;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdFilter;
import net.thevpc.nuts.artifact.NIdLocation;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.ext.NExtensionInformation;
import net.thevpc.nuts.platform.NArchFamily;
import net.thevpc.nuts.platform.NDesktopEnvironmentFamily;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.platform.NPlatformFamily;
import net.thevpc.nuts.platform.NPlatformLocation;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.spi.base.AbstractNPredicate;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NFilter;
import net.thevpc.nuts.util.NFilterOp;
import net.thevpc.nuts.util.NSimplifiable;
import net.thevpc.nuts.util.NStringMapFormat;
import net.thevpc.nuts.util.NStringUtils;

public class CoreFilterUtils {
    private static int andInts(Boolean a, Boolean b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return b != false ? 1 : -1;
        }
        if (b == null) {
            return a != false ? 1 : -1;
        }
        if (a.equals(b)) {
            return a != false ? 1 : -1;
        }
        return 2;
    }

    private static int orInts(Boolean a, Boolean b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return b != false ? 1 : -1;
        }
        if (b == null) {
            return a != false ? 1 : -1;
        }
        if (a.equals(b)) {
            return a != false ? 1 : -1;
        }
        return 0;
    }

    public static <T extends NFilter> T[] getTopLevelFilters(NFilter idFilter, Class<T> clazz) {
        return (NFilter[])CoreFilterUtils.getTopLevelFilters(idFilter).stream().map(x -> NFilters.of().as(clazz, (NFilter)x)).toArray(value -> (NFilter[])Array.newInstance(clazz, value));
    }

    public static List<NFilter> getTopLevelFilters(NFilter idFilter) {
        if (idFilter == null) {
            return Collections.emptyList();
        }
        if (idFilter.getFilterOp() == NFilterOp.AND) {
            return idFilter.getSubFilters();
        }
        return Collections.singletonList(idFilter);
    }

    public static NDefinitionFilter createNutsDefinitionFilter(String arch, String os, String osDist, String platform, String desktopEnv) {
        NDefinitionFilters d = NDefinitionFilters.of();
        return d.byArch(arch).and(d.byOs(os)).and(d.byOsDist(osDist)).and(d.byPlatform(platform)).and(d.byDesktopEnvironment(desktopEnv));
    }

    public static NDefinitionFilter createNutsDefinitionFilter(Map<String, String> faceMap) {
        return CoreFilterUtils.createNutsDefinitionFilter(faceMap == null ? null : faceMap.get("arch"), faceMap == null ? null : faceMap.get("os"), faceMap == null ? null : faceMap.get("osdist"), faceMap == null ? null : faceMap.get("platform"), faceMap == null ? null : faceMap.get("desktop"));
    }

    public static List<NExtensionInformation> filterNutsExtensionInfoByLatestVersion(List<NExtensionInformation> base) {
        LinkedHashMap<String, NExtensionInformation> valid = new LinkedHashMap<String, NExtensionInformation>();
        for (NExtensionInformation n : base) {
            NExtensionInformation old = (NExtensionInformation)valid.get(n.getId().getShortName());
            if (old != null && old.getId().getVersion().compareTo(n.getId().getVersion()) >= 0) continue;
            valid.put(n.getId().getShortName(), n);
        }
        return new ArrayList<NExtensionInformation>(valid.values());
    }

    public static List<NId> filterNutsIdByLatestVersion(List<NId> base) {
        LinkedHashMap<String, NId> valid = new LinkedHashMap<String, NId>();
        for (NId n : base) {
            NId old = (NId)valid.get(n.getShortName());
            if (old != null && old.getVersion().compareTo(n.getVersion()) >= 0) continue;
            valid.put(n.getShortName(), n);
        }
        return new ArrayList<NId>(valid.values());
    }

    public static boolean matchesPackaging(String packaging, NDescriptor desc) {
        if (NBlankable.isBlank(packaging)) {
            return true;
        }
        if (NBlankable.isBlank(desc.getPackaging())) {
            return true;
        }
        NId _v = NId.get(packaging).orNull();
        NId _v2 = NId.get(desc.getPackaging()).orNull();
        if (_v == null || _v2 == null) {
            return _v == _v2;
        }
        return _v.equalsShortId(_v2) && _v.getVersion().filter().acceptVersion(_v2.getVersion());
    }

    public static boolean acceptDependency(NDependency dep) {
        if (CoreFilterUtils.acceptCondition(dep.getCondition(), false)) {
            String[] a;
            String c;
            if (dep.getGroupId().equals("org.openjfx") && dep.getArtifactId().startsWith("javafx") && (c = NStringUtils.trim(dep.getClassifier())).length() > 0 && (a = c.split("-")).length > 0) {
                NArchFamily af;
                NOsFamily o = NOsFamily.parse(a[0]).orNull();
                if (o != null && o != NWorkspace.of().getOsFamily()) {
                    return false;
                }
                if (a.length > 1 && (af = NArchFamily.parse(a[1]).orNull()) != null && af != NWorkspace.of().getArchFamily()) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean matchAny(List<String> all, Function<String, Boolean> accepter) {
        boolean someFalse = false;
        if (all != null) {
            for (String s : all) {
                if (!NBlankable.isBlank(s)) continue;
                if (accepter.apply(s).booleanValue()) {
                    return true;
                }
                someFalse = true;
            }
        }
        return !someFalse;
    }

    public static boolean acceptCondition(NEnvCondition envCond, NEnvCondition cond2) {
        if (envCond == null || envCond.isBlank()) {
            return true;
        }
        if (cond2 == null || cond2.isBlank()) {
            return true;
        }
        if (!CoreFilterUtils.matchAny(cond2.getArch(), s -> CoreFilterUtils.matchesArch(s, envCond.getArch()))) {
            return false;
        }
        if (!CoreFilterUtils.matchAny(cond2.getOs(), s -> CoreFilterUtils.matchesOs(s, envCond.getOs()))) {
            return false;
        }
        if (!CoreFilterUtils.matchAny(cond2.getOsDist(), s -> CoreFilterUtils.matchesOsDist(s, envCond.getOsDist()))) {
            return false;
        }
        if (!CoreFilterUtils.matchAny(cond2.getPlatform(), s -> CoreFilterUtils.matchesOsDist(s, envCond.getPlatform()))) {
            return false;
        }
        if (!CoreFilterUtils.matchAny(cond2.getDesktopEnvironment(), s -> CoreFilterUtils.matchesOsDist(s, envCond.getDesktopEnvironment()))) {
            return false;
        }
        return CoreFilterUtils.matchesProperties(envCond.getProperties(), cond2.getProperties());
    }

    public static boolean acceptCondition(NEnvCondition envCond, boolean currentVMOnLy) {
        if (envCond == null || envCond.isBlank()) {
            return true;
        }
        NWorkspace workspace = NWorkspace.of();
        if (!CoreFilterUtils.matchesArch(workspace.getArchFamily().id(), envCond.getArch())) {
            return false;
        }
        if (!CoreFilterUtils.matchesOs(workspace.getOsFamily().id(), envCond.getOs())) {
            return false;
        }
        if (!CoreFilterUtils.matchesOsDist(workspace.getOsDist().toString(), envCond.getOsDist())) {
            return false;
        }
        if (currentVMOnLy ? !CoreFilterUtils.matchesPlatform(workspace.getPlatform().toString(), envCond.getPlatform()) : !CoreFilterUtils.matchesPlatform(workspace.findPlatforms().toList(), envCond.getPlatform())) {
            return false;
        }
        if (!CoreFilterUtils.matchesDesktopEnvironment(workspace.getDesktopEnvironments(), envCond.getDesktopEnvironment())) {
            return false;
        }
        return CoreFilterUtils.matchesProperties(envCond.getProperties());
    }

    private static boolean matchesProperties(Map<String, String> props) {
        for (Map.Entry<String, String> kv : props.entrySet()) {
            if (CoreFilterUtils.matchesProperty(kv.getKey(), kv.getValue())) continue;
            return false;
        }
        return true;
    }

    private static boolean matchesProperties(Map<String, String> props, Map<String, String> others) {
        for (Map.Entry<String, String> kv : props.entrySet()) {
            if (CoreFilterUtils.matchesProperty(kv.getKey(), kv.getValue(), x -> {
                String u = (String)others.get(x);
                if (u != null) {
                    return u;
                }
                return System.getProperty(x);
            })) continue;
            return false;
        }
        return true;
    }

    private static boolean matchesProperty(String k, String expected) {
        return CoreFilterUtils.matchesProperty(k, expected, x -> {
            Object u = NApp.of().getProperty((String)x, NScopeType.SESSION).orNull();
            if (u != null) {
                return String.valueOf(u);
            }
            return System.getProperty(x);
        });
    }

    private static boolean matchesProperty(String k, String expected, Function<String, String> props) {
        String f = props.apply(k);
        if (expected == null) {
            return f != null;
        }
        expected = NStringUtils.trim(expected);
        f = NStringUtils.trim(f);
        if (expected.startsWith("!")) {
            return !(expected = expected.substring(1).trim()).equals(f);
        }
        return expected.equals(f);
    }

    public static boolean matchesArch(String current, Collection<String> allConds) {
        if (NBlankable.isBlank(current)) {
            return true;
        }
        NId currentId = NId.get(current).get();
        if (allConds != null && allConds.size() > 0) {
            for (String cond : allConds) {
                if (NBlankable.isBlank(cond)) {
                    return true;
                }
                NId idCond = NId.get(cond).get();
                NArchFamily w = NArchFamily.parse(idCond.getArtifactId()).orNull();
                if (w != null) {
                    idCond = idCond.builder().setArtifactId(w.id()).build();
                }
                if (!idCond.equalsShortId(currentId) || !idCond.getVersion().filter().acceptVersion(currentId.getVersion())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean matchesOs(String os, Collection<String> allConds) {
        if (NBlankable.isBlank(os)) {
            return true;
        }
        NId currentId = NId.get(os).get();
        if (allConds != null && allConds.size() > 0) {
            Iterator<String> iterator = allConds.iterator();
            if (iterator.hasNext()) {
                String cond = iterator.next();
                if (NBlankable.isBlank(cond)) {
                    return true;
                }
                NId condId = NId.get(cond).get();
                NOsFamily w = NOsFamily.parse(condId.getArtifactId()).orNull();
                if (w != null) {
                    condId = condId.builder().setArtifactId(w.id()).build();
                }
                return condId.compatNewer().filter().acceptId(currentId);
            }
            return false;
        }
        return true;
    }

    public static boolean matchesOsDist(String current, Collection<String> allConditions) {
        if (NBlankable.isBlank(current)) {
            return true;
        }
        NId currentId = NId.get(current).get();
        if (allConditions != null && !allConditions.isEmpty()) {
            Iterator<String> iterator = allConditions.iterator();
            if (iterator.hasNext()) {
                String cond = iterator.next();
                if (NBlankable.isBlank(cond)) {
                    return true;
                }
                NId condId = NId.get(cond).get();
                return condId.compatNewer().filter().acceptId(currentId);
            }
            return false;
        }
        return true;
    }

    public static <T> boolean matchesEnum(T current, Collection<T> allConditions) {
        if (NBlankable.isBlank(current)) {
            return true;
        }
        if (allConditions != null && !allConditions.isEmpty()) {
            for (T cond : allConditions) {
                if (NBlankable.isBlank(cond)) {
                    return true;
                }
                if (cond != current) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean matchesPlatform(Collection<NPlatformLocation> platforms, Collection<String> allCond) {
        if (allCond == null || allCond.isEmpty()) {
            return true;
        }
        for (NPlatformLocation platform : platforms) {
            NId id = platform.getId();
            if (id == null || !CoreFilterUtils.matchesPlatform(id.toString(), allCond)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesPlatform(String current, Collection<String> allConds) {
        if (NBlankable.isBlank(current)) {
            return true;
        }
        NId currentId = NId.get(current).get();
        if (allConds != null && allConds.size() > 0) {
            Iterator<String> iterator = allConds.iterator();
            if (iterator.hasNext()) {
                String cond = iterator.next();
                if (NBlankable.isBlank(cond)) {
                    return true;
                }
                NId condId = NId.get(cond).get();
                NPlatformFamily w = NPlatformFamily.parse(condId.getArtifactId()).orNull();
                if (w != null) {
                    condId = condId.builder().setArtifactId(w.id()).build();
                }
                return condId.compatNewer().filter().acceptId(currentId);
            }
            return false;
        }
        return true;
    }

    public static boolean matchesDesktopEnvironment(Collection<NId> platforms, Collection<String> allConds) {
        for (NId platform : platforms) {
            if (!CoreFilterUtils.matchesDesktopEnvironment(platform.toString(), allConds)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesDesktopEnvironment(String current, Collection<String> allConds) {
        if (NBlankable.isBlank(current)) {
            return true;
        }
        NId currentId = NId.get(current).get();
        if (allConds != null && allConds.size() > 0) {
            Iterator<String> iterator = allConds.iterator();
            if (iterator.hasNext()) {
                String cond = iterator.next();
                if (NBlankable.isBlank(cond)) {
                    return true;
                }
                NId condId = NId.get(cond).get();
                NDesktopEnvironmentFamily w = NDesktopEnvironmentFamily.parse(condId.getArtifactId()).orNull();
                if (w != null) {
                    condId = condId.builder().setArtifactId(w.id()).build();
                }
                return condId.compatNewer().filter().acceptId(currentId);
            }
            return false;
        }
        return true;
    }

    public static boolean matchesEnv(String arch, String os, String dist, String platform, String de, NEnvCondition desc) {
        if (!CoreFilterUtils.matchesArch(arch, desc.getArch())) {
            return false;
        }
        if (!CoreFilterUtils.matchesOs(os, desc.getOs())) {
            return false;
        }
        if (!CoreFilterUtils.matchesOsDist(dist, desc.getOsDist())) {
            return false;
        }
        if (!CoreFilterUtils.matchesPlatform(platform, desc.getPlatform())) {
            return false;
        }
        return CoreFilterUtils.matchesDesktopEnvironment(de, desc.getDesktopEnvironment());
    }

    public static List<NDependency> filterDependencies(NId from, List<NDependency> d0, NDependencyFilter dependencyFilter) {
        if (dependencyFilter == null) {
            return d0;
        }
        ArrayList<NDependency> r = new ArrayList<NDependency>(d0.size());
        for (NDependency nutsDependency : d0) {
            if (!dependencyFilter.acceptDependency(nutsDependency, from)) continue;
            r.add(nutsDependency);
        }
        return r;
    }

    public static boolean matchesSimpleNameStaticVersion(NId id, NId pattern) {
        if (pattern == null) {
            return id == null;
        }
        if (id == null) {
            return false;
        }
        if (pattern.getVersion().isBlank()) {
            return pattern.getShortName().equals(id.getShortName());
        }
        return pattern.getLongName().equals(id.getLongName());
    }

    public static boolean acceptClassifier(NIdLocation location, String classifier) {
        if (location == null) {
            return false;
        }
        String c0 = NStringUtils.trim(classifier);
        String c1 = NStringUtils.trim(location.getClassifier());
        return c0.equals(c1);
    }

    public static Map<String, String> toMap(NEnvCondition condition) {
        Map<String, String> properties;
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        String s = condition.getArch().stream().map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.joining(","));
        if (!NBlankable.isBlank(s)) {
            m.put("arch", s);
        }
        if (!NBlankable.isBlank(s = condition.getOs().stream().map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.joining(",")))) {
            m.put("os", s);
        }
        if (!NBlankable.isBlank(s = condition.getOsDist().stream().map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.joining(",")))) {
            m.put("osdist", s);
        }
        if (!NBlankable.isBlank(s = String.join((CharSequence)",", condition.getPlatform()))) {
            m.put("platform", s);
        }
        if (!NBlankable.isBlank(s = condition.getDesktopEnvironment().stream().map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.joining(",")))) {
            m.put("desktop", s);
        }
        if (!NBlankable.isBlank(s = condition.getProfiles().stream().map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.joining(",")))) {
            m.put("profile", s);
        }
        if (!(properties = condition.getProperties()).isEmpty()) {
            m.put("cond-properties", NStringMapFormat.COMMA_FORMAT.format(properties));
        }
        return m;
    }

    public static <T extends NFilter> T simplifyFilterOr(Class<T> cls, T base, NFilter ... all) {
        if (all.length == 0) {
            return NFilters.of().always(cls);
        }
        if (all.length == 1) {
            return (T)all[0].simplify();
        }
        LinkedHashSet<NFilter> all2 = new LinkedHashSet<NFilter>();
        boolean updates = false;
        boolean someFalse = false;
        for (NFilter t : all) {
            NFilter t2;
            NFilter nFilter = t2 = t == null ? null : t.simplify();
            if (t2 != null) {
                switch (t2.getFilterOp()) {
                    case TRUE: {
                        return NFilters.of().always(cls);
                    }
                    case FALSE: {
                        someFalse = true;
                        break;
                    }
                    default: {
                        if (t2 != t) {
                            updates = true;
                        }
                        all2.add(t2);
                        break;
                    }
                }
                continue;
            }
            updates = true;
        }
        if (all2.isEmpty()) {
            if (someFalse) {
                return NFilters.of().never(cls);
            }
            return NFilters.of().always(cls);
        }
        if (all2.size() == 1) {
            return (T)((NFilter)all2.stream().findFirst().get());
        }
        if (!updates) {
            return base;
        }
        return NFilters.of().any(cls, all2.toArray((NFilter[])Array.newInstance(cls, 0)));
    }

    public static <T extends NFilter> T simplifyFilterAnd(Class<T> cls, T base, NFilter ... all) {
        if (all.length == 0) {
            return NFilters.of().always(cls);
        }
        if (all.length == 1) {
            return (T)all[0].simplify();
        }
        LinkedHashSet<NFilter> all2 = new LinkedHashSet<NFilter>();
        boolean updates = false;
        for (NFilter t : all) {
            NFilter t2;
            NFilter nFilter = t2 = t == null ? null : t.simplify();
            if (t2 != null) {
                switch (t2.getFilterOp()) {
                    case FALSE: {
                        return NFilters.of().never(cls);
                    }
                    case TRUE: {
                        updates = true;
                        break;
                    }
                    default: {
                        if (t2 != t) {
                            updates = true;
                        }
                        all2.add(t2);
                        break;
                    }
                }
                continue;
            }
            updates = true;
        }
        if (all2.isEmpty()) {
            return NFilters.of().always(cls);
        }
        if (all2.size() == 1) {
            return (T)((NFilter)all2.stream().findFirst().get());
        }
        if (!updates) {
            return base;
        }
        return NFilters.of().all(cls, all2.toArray((NFilter[])Array.newInstance(cls, 0)));
    }

    public static <T extends NFilter> T simplifyFilterNone(Class<T> cls, T base, NFilter ... all) {
        if (all.length == 0) {
            return NFilters.of().always(cls);
        }
        ArrayList<NFilter> all2 = new ArrayList<NFilter>();
        boolean updates = false;
        for (NFilter t : all) {
            NFilter t2;
            NFilter nFilter = t2 = t == null ? null : t.simplify();
            if (t2 != null) {
                switch (t2.getFilterOp()) {
                    case TRUE: {
                        return NFilters.of().never(cls);
                    }
                    case FALSE: {
                        updates = true;
                        break;
                    }
                    default: {
                        if (t2 != t) {
                            updates = true;
                        }
                        all2.add(t2);
                        break;
                    }
                }
                continue;
            }
            updates = true;
        }
        if (all2.size() == 0) {
            return NFilters.of().always(cls);
        }
        if (!updates) {
            return base;
        }
        return NFilters.of().none(cls, all2.toArray((NFilter[])Array.newInstance(cls, 0)));
    }

    public static <T> T simplify(T any) {
        if (any == null) {
            return null;
        }
        if (any instanceof NSimplifiable) {
            return ((NSimplifiable)any).simplify();
        }
        return any;
    }

    public static <T> T[] simplifyAndShrink(Class<T> cls, T ... any) {
        ArrayList<T> all = new ArrayList<T>();
        boolean updates = false;
        for (T t : any) {
            T t2 = CoreFilterUtils.simplify(t);
            if (t2 != null) {
                if (t2 != t) {
                    updates = true;
                }
                all.add(t2);
                continue;
            }
            updates = true;
        }
        if (!updates) {
            return null;
        }
        return all.toArray((Object[])Array.newInstance(cls, 0));
    }

    public static <T extends NFilter> T[] simplifyAndShrinkFilters(Class<T> cls, Predicate<T> onRemove, T ... any) {
        ArrayList<NFilter> all = new ArrayList<NFilter>();
        boolean updates = false;
        for (T t : any) {
            NFilter t2;
            NFilter nFilter = t2 = t == null ? null : t.simplify();
            if (t2 != null) {
                if (onRemove != null && onRemove.test(t2)) {
                    updates = true;
                    continue;
                }
                if (t2 != t) {
                    updates = true;
                }
                all.add(t2);
                continue;
            }
            updates = true;
        }
        if (!updates) {
            return null;
        }
        return all.toArray((NFilter[])Array.newInstance(cls, 0));
    }

    private static class NIdFilterToPredicate
    extends AbstractNPredicate<NId> {
        private final NIdFilter t;

        public NIdFilterToPredicate(NIdFilter t) {
            this.t = t;
        }

        @Override
        public boolean test(NId value) {
            return this.t.acceptId(value);
        }

        public int hashCode() {
            return Objects.hash(this.t);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NIdFilterToPredicate that = (NIdFilterToPredicate)o;
            return Objects.equals(this.t, that.t);
        }

        public String toString() {
            return this.t.toString();
        }
    }
}

