/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util.filters;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringReaderExt;

public abstract class AbstractFilterParser2<T> {
    protected StringReaderExt str;
    Set<String> preOps = new LinkedHashSet<String>();
    Set<String> binOps = new LinkedHashSet<String>();
    boolean acceptPars = true;
    String implicitOperator = null;

    public AbstractFilterParser2(String str) {
        this.str = new StringReaderExt(str);
    }

    protected void addBoolOps() {
        this.binOps.addAll(Arrays.asList("&&", "||", "&", "|"));
        this.preOps.add("!");
        this.acceptPars = true;
    }

    protected void skipWhites() {
        while (this.str.hasNext() && Character.isWhitespace(this.str.peekChar())) {
            this.str.readChar();
        }
    }

    protected abstract T nextDefault();

    public T parse() {
        T u = this.next();
        if (u != null) {
            return u;
        }
        return this.nextDefault();
    }

    private T next() {
        return this.next(-1);
    }

    private T next(int precedence) {
        Object a;
        block5: {
            block6: {
                a = null;
                while (true) {
                    this.skipWhites();
                    String preOp = this.peekPreOp();
                    if (preOp != null) {
                        T x = this.next(precedence);
                        a = this.buildPreOp(preOp, x);
                        continue;
                    }
                    if (this.acceptPars && this.str.readString("(")) {
                        a = this.next(-1);
                        this.skipWhites();
                        if (this.str.readString(")")) continue;
                        throw new IllegalArgumentException("expected ')'");
                    }
                    if (this.acceptPars && this.str.readString(")")) break block5;
                    String w = this.nextWord();
                    if (w == null) break block6;
                    a = this.wordToPredicate(w);
                    String op = this.peekBinOp();
                    if (op == null && this.implicitOperator != null) {
                        op = this.implicitOperator;
                    }
                    if (op == null) break;
                    int oprec = this.getOpPrecedence(op);
                    if (oprec >= precedence) {
                        T r = this.next(precedence);
                        a = this.buildBinOp(op, a, r);
                        continue;
                    }
                    break block5;
                    break;
                }
                throw new IllegalArgumentException("expected operator at: " + this.str.peekChars(5) + "...");
            }
            throw new IllegalArgumentException("unexpected at: " + this.str.peekChars(5) + "...");
        }
        return a;
    }

    protected abstract T buildPreOp(String var1, T var2);

    protected abstract T buildBinOp(String var1, T var2, T var3);

    protected int getOpPrecedence(String op) {
        switch (op) {
            case "&": 
            case "&&": {
                return 1;
            }
            case "|": 
            case "||": {
                return 2;
            }
        }
        return -1;
    }

    private String peekBinOp() {
        for (String s : this.binOps) {
            if (!this.str.peekChars(s)) continue;
            return s;
        }
        return null;
    }

    private String peekPreOp() {
        for (String s : this.preOps) {
            if (!this.str.peekChars(s)) continue;
            return s;
        }
        return null;
    }

    protected String nextWord() {
        if (this.str.hasNext() && Character.isLetterOrDigit(this.str.peekChar())) {
            StringBuilder sb = new StringBuilder();
            while (this.str.hasNext() && (Character.isLetterOrDigit(this.str.peekChar()) || this.str.peekChar() == '_')) {
                sb.append(this.str.readChar());
            }
            return sb.toString();
        }
        return null;
    }

    protected abstract T wordToPredicate(String var1);
}

