/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.thevpc.nuts.runtime.standalone.util.NScorableResultImpl;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NScorable;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NScorableQuery;
import net.thevpc.nuts.util.NScorableResult;
import net.thevpc.nuts.util.NStream;

public class NScorableNScorableQueryImpl<T extends NScorable>
implements NScorableQuery<T> {
    List<Src> all = new ArrayList<Src>();
    Supplier<NMsg> emptyMessage;
    NScorableContext context;

    public NScorableNScorableQueryImpl(NScorableContext context) {
        NAssert.requireNonNull(context, "context");
        this.context = context;
    }

    @Override
    public NScorableNScorableQueryImpl<T> withContext(NScorableContext context) {
        this.context = context;
        return this;
    }

    @Override
    public NScorableQuery<T> fromStreamOfSuppliers(Stream<Supplier<T>> source) {
        if (source != null) {
            this.all.add(new Src(source, SrcType.STREAM_SUPPLIER));
        }
        return this;
    }

    @Override
    public NScorableQuery<T> fromStream(Stream<T> source) {
        if (source != null) {
            this.all.add(new Src(source, SrcType.STREAM));
        }
        return this;
    }

    @Override
    public NScorableQuery<T> fromSingleton(T source) {
        if (source != null) {
            this.fromIterable(Arrays.asList(source));
        }
        return this;
    }

    @Override
    public NScorableQuery<T> fromSingletonSupplier(Supplier<T> source) {
        if (source != null) {
            this.fromIterableOfSuppliers(Arrays.asList(source));
        }
        return this;
    }

    @Override
    public NScorableQuery<T> fromStreamOfSuppliers(NStream<Supplier<T>> source) {
        if (source != null) {
            this.all.add(new Src(source, SrcType.NSTREAM_SUPPLIER));
        }
        return this;
    }

    @Override
    public NScorableQuery<T> fromStream(NStream<T> source) {
        if (source != null) {
            this.all.add(new Src(source, SrcType.NSTREAM));
        }
        return this;
    }

    @Override
    public NScorableQuery<T> fromIterable(Iterable<T> source) {
        if (source != null) {
            this.all.add(new Src(source, SrcType.ITERABLE));
        }
        return this;
    }

    @Override
    public NScorableQuery<T> fromIterator(Iterator<T> source) {
        if (source != null) {
            this.all.add(new Src(source, SrcType.ITERATOR));
        }
        return this;
    }

    @Override
    public NScorableQuery<T> fromIterableOfSuppliers(Iterable<Supplier<T>> source) {
        if (source != null) {
            this.all.add(new Src(source, SrcType.ITERABLE_SUPPLIER));
        }
        return this;
    }

    @Override
    public NScorableQuery<T> fromIteratorOfSuppliers(Iterator<Supplier<T>> source) {
        if (source != null) {
            this.all.add(new Src(source, SrcType.ITERATOR_SUPPLIER));
        }
        return this;
    }

    @Override
    public NScorableQuery<T> withName(NMsg source) {
        this.emptyMessage = source == null ? null : () -> source;
        return this;
    }

    @Override
    public NScorableQuery<T> withName(Supplier<NMsg> source) {
        this.emptyMessage = source == null ? null : () -> {
            NMsg u = (NMsg)source.get();
            return NMsg.ofC("missing %s", u == null ? "scorable" : u);
        };
        return this;
    }

    @Override
    public NScorableQuery<T> withEmptyMessage(Supplier<NMsg> source) {
        this.emptyMessage = source == null ? null : () -> {
            NMsg u = (NMsg)source.get();
            return u == null ? NMsg.ofC("missing scorable") : u;
        };
        return this;
    }

    @Override
    public List<T> getAll() {
        return this.getResults().stream().map(x -> x.value()).collect(Collectors.toList());
    }

    private NScorableResult<T> findBestFromIteratorOfSupplier(Iterator<Supplier<T>> srcOk, NScorableResult<T> track) {
        NScorableContext context;
        NScorableContext nScorableContext = context = this.context == null ? NScorableContext.of() : this.context;
        while (srcOk.hasNext()) {
            int score;
            NScorable s;
            Supplier<T> ss = srcOk.next();
            if (ss == null || (s = (NScorable)ss.get()) == null || (score = s.getScore(context)) <= 0 || track != null && score <= track.score()) continue;
            track = new NScorableResultImpl<NScorable>(s, score, context);
        }
        return track;
    }

    private NScorableResult<T> findBestFromIterator(Iterator<T> srcOk, NScorableResult<T> track) {
        NScorableContext context;
        NScorableContext nScorableContext = context = this.context == null ? NScorableContext.of() : this.context;
        while (srcOk.hasNext()) {
            int score;
            NScorable s = (NScorable)srcOk.next();
            if (s == null || (score = s.getScore(context)) <= 0 || track != null && score <= track.score()) continue;
            track = new NScorableResultImpl<NScorable>(s, score, context);
        }
        return track;
    }

    private void fillIterator(Iterator<T> srcOk, List<NScorableResult<T>> track) {
        NScorableContext context;
        NScorableContext nScorableContext = context = this.context == null ? NScorableContext.of() : this.context;
        while (srcOk.hasNext()) {
            int score;
            NScorable s = (NScorable)srcOk.next();
            if (s == null || (score = s.getScore(context)) <= 0) continue;
            track.add(new NScorableResultImpl<NScorable>(s, score, context));
        }
    }

    private void fillIteratorOfSupplier(Iterator<Supplier<T>> srcOk, List<NScorableResult<T>> track) {
        NScorableContext context;
        NScorableContext nScorableContext = context = this.context == null ? NScorableContext.of() : this.context;
        while (srcOk.hasNext()) {
            int score;
            NScorable s;
            Supplier<T> ss = srcOk.next();
            if (ss == null || (s = (NScorable)ss.get()) == null || (score = s.getScore(context)) <= 0) continue;
            track.add(new NScorableResultImpl<NScorable>(s, score, context));
        }
    }

    public List<NScorableResult<T>> getResults() {
        ArrayList<NScorableResult<T>> track = new ArrayList<NScorableResult<T>>();
        for (Src source : this.all) {
            if (source == null) continue;
            switch (source.type.ordinal()) {
                case 0: {
                    this.fillIterator(((Stream)source.value).iterator(), track);
                    break;
                }
                case 1: {
                    this.fillIteratorOfSupplier(((Stream)source.value).iterator(), track);
                    break;
                }
                case 2: {
                    this.fillIterator(((NStream)source.value).iterator(), track);
                    break;
                }
                case 3: {
                    this.fillIteratorOfSupplier(((NStream)source.value).iterator(), track);
                    break;
                }
                case 5: {
                    this.fillIteratorOfSupplier((Iterator)source.value, track);
                    break;
                }
                case 4: {
                    this.fillIterator((Iterator)source.value, track);
                    break;
                }
                case 7: {
                    this.fillIteratorOfSupplier(((Iterable)source.value).iterator(), track);
                    break;
                }
                case 6: {
                    this.fillIterator(((Iterable)source.value).iterator(), track);
                }
            }
        }
        if (track.size() > 1) {
            Collections.sort(track, (a, b) -> Integer.compare(b.score(), a.score()));
        }
        return track;
    }

    @Override
    public NOptional<T> getBest() {
        return this.getBestResult().map(x -> x.value());
    }

    @Override
    public NOptional<NScorableResult<T>> getBestResult() {
        NScorableResult<T> track = null;
        for (Src source : this.all) {
            if (source == null) continue;
            switch (source.type.ordinal()) {
                case 0: {
                    track = this.findBestFromIterator(((Stream)source.value).iterator(), track);
                    break;
                }
                case 1: {
                    track = this.findBestFromIteratorOfSupplier(((Stream)source.value).iterator(), track);
                    break;
                }
                case 2: {
                    track = this.findBestFromIterator(((NStream)source.value).iterator(), track);
                    break;
                }
                case 3: {
                    track = this.findBestFromIteratorOfSupplier(((NStream)source.value).iterator(), track);
                    break;
                }
                case 5: {
                    track = this.findBestFromIteratorOfSupplier((Iterator)source.value, track);
                    break;
                }
                case 4: {
                    track = this.findBestFromIterator((Iterator)source.value, track);
                    break;
                }
                case 7: {
                    track = this.findBestFromIteratorOfSupplier(((Iterable)source.value).iterator(), track);
                    break;
                }
                case 6: {
                    track = this.findBestFromIterator(((Iterable)source.value).iterator(), track);
                }
            }
        }
        return NOptional.of(track, this.emptyMessage == null ? () -> NMsg.ofC("missing scorable") : this.emptyMessage);
    }

    private class Src {
        SrcType type;
        Object value;

        public Src(Object value, SrcType type) {
            this.type = type;
            this.value = value;
        }
    }

    private static enum SrcType {
        STREAM,
        STREAM_SUPPLIER,
        NSTREAM,
        NSTREAM_SUPPLIER,
        ITERATOR,
        ITERATOR_SUPPLIER,
        ITERABLE,
        ITERABLE_SUPPLIER;

    }
}

