/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.util.NOptional;

public class NPropertiesHolder {
    private Map<String, NScopedPropertyValue> properties = new LinkedHashMap<String, NScopedPropertyValue>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NPropertiesHolder copy() {
        NPropertiesHolder h = new NPropertiesHolder();
        NPropertiesHolder nPropertiesHolder = this;
        synchronized (nPropertiesHolder) {
            h.properties = new LinkedHashMap<String, NScopedPropertyValue>();
            for (Map.Entry<String, NScopedPropertyValue> e : this.properties.entrySet()) {
                h.properties.put(e.getKey(), new NScopedPropertyValue(e.getValue()));
            }
        }
        return h;
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> lhm = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, NScopedPropertyValue> e : this.properties.entrySet()) {
            lhm.put(e.getKey(), e.getValue().value);
        }
        return lhm;
    }

    public Set<String> keySet() {
        return new LinkedHashSet<String>(this.properties.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(Map<String, Object> properties, NScopeType scope) {
        NPropertiesHolder nPropertiesHolder = this;
        synchronized (nPropertiesHolder) {
            this.properties.clear();
            for (Map.Entry<String, Object> e : properties.entrySet()) {
                this.properties.put(e.getKey(), new NScopedPropertyValue(scope, e.getValue()));
            }
        }
    }

    public Object getProperty(String key) {
        NScopedPropertyValue a = this.properties.get(key);
        return a == null ? null : a.value;
    }

    public NScopedPropertyValue getScopedValue(String key) {
        NScopedPropertyValue a = this.properties.get(key);
        return a;
    }

    public <T> NOptional<T> getOptional(String key) {
        NScopedPropertyValue a = this.properties.get(key);
        if (a != null) {
            return NOptional.of(a.value);
        }
        return NOptional.ofNamedEmpty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getOrComputeProperty(String key, Supplier<T> supplier, NScopeType scope) {
        NScopedPropertyValue v = this.properties.get(key);
        if (v != null) {
            return (T)v.value;
        }
        NPropertiesHolder nPropertiesHolder = this;
        synchronized (nPropertiesHolder) {
            v = this.properties.get(key);
            if (v != null) {
                return (T)v.value;
            }
            T z = supplier.get();
            this.properties.put(key, new NScopedPropertyValue(scope, z));
            return z;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setProperty(String key, Object value, NScopeType scope) {
        NPropertiesHolder nPropertiesHolder = this;
        synchronized (nPropertiesHolder) {
            if (this.properties == null) {
                if (value != null) {
                    this.properties = new LinkedHashMap<String, NScopedPropertyValue>();
                    NScopedPropertyValue o = this.properties.put(key, new NScopedPropertyValue(scope, value));
                    Object object = o == null ? null : o.value;
                    return object;
                }
            } else {
                if (value != null) {
                    NScopedPropertyValue o = this.properties.put(key, new NScopedPropertyValue(scope, value));
                    Object object = o == null ? null : o.value;
                    return object;
                }
                NScopedPropertyValue o = this.properties.remove(key);
                Object object = o == null ? null : o.value;
                return object;
            }
        }
        return null;
    }

    public String toString() {
        return String.valueOf(this.properties);
    }

    public int size() {
        return this.properties.size();
    }

    public static class NScopedPropertyValue {
        private NScopeType scope;
        private Object value;

        public NScopedPropertyValue(NScopeType scope, Object value) {
            this.scope = scope;
            this.value = value;
        }

        public NScopedPropertyValue(NScopedPropertyValue other) {
            this.scope = other.scope;
            this.value = other.value;
        }

        public NScopeType getScope() {
            return this.scope;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return this.scope + "(" + this.value + ')';
        }
    }
}

