/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util;

import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.boot.internal.util.NBootUtils;
import net.thevpc.nuts.core.NClassLoaderNode;

public class NDefaultClassLoaderNode
implements NClassLoaderNode {
    private final NId id;
    private final boolean includedInClasspath;
    private final URL url;
    private final boolean enabled;
    private final List<NClassLoaderNode> dependencies;

    public NDefaultClassLoaderNode(NId id, URL url, boolean enabled, boolean includedInClasspath, NClassLoaderNode ... dependencies) {
        this.id = id;
        this.url = url;
        this.enabled = enabled;
        this.includedInClasspath = includedInClasspath;
        this.dependencies = NBootUtils.nonNullList(Arrays.asList(dependencies));
    }

    @Override
    public boolean isIncludedInClasspath() {
        return this.includedInClasspath;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public NId getId() {
        return this.id;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public List<NClassLoaderNode> getDependencies() {
        return this.dependencies;
    }

    public int hashCode() {
        int result = Objects.hash(this.id, this.includedInClasspath, this.url, this.enabled, this.dependencies);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NDefaultClassLoaderNode that = (NDefaultClassLoaderNode)o;
        return this.includedInClasspath == that.includedInClasspath && this.enabled == that.enabled && Objects.equals(this.id, that.id) && Objects.equals(this.url, that.url) && Objects.equals(this.dependencies, that.dependencies);
    }

    public String toString() {
        return "NutsClassLoaderNode{id='" + this.id + '\'' + ", loaded=" + this.includedInClasspath + ", url=" + this.url + ", enabled=" + this.enabled + ", dependencies=" + this.dependencies + '}';
    }
}

