/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringTokenizerUtils;

public class NDebugString {
    private boolean all;
    private boolean enabled;
    private int port;
    private int maxPort;
    private boolean tcp;
    private boolean suspend;
    private final List<NArg> options = new ArrayList<NArg>();

    public static NDebugString of(String str) {
        NDebugString d = new NDebugString();
        if (str == null) {
            d.setEnabled(false);
        } else {
            d.setEnabled(true);
            d.setSuspend(true);
            block14: for (String a : StringTokenizerUtils.splitDefault(str)) {
                NArg na = NArg.of(a);
                switch (na.getKey().asString().orElse("")) {
                    case "s": 
                    case "suspend": {
                        d.setSuspend(!na.isNegated());
                        continue block14;
                    }
                    case "a": 
                    case "all": {
                        d.setAll(!na.isNegated());
                        continue block14;
                    }
                    case "tcp": {
                        d.setTcp(!na.isNegated());
                        continue block14;
                    }
                    case "port": {
                        String s = na.getValue().asString().orElse("").trim();
                        if (s.matches("[0-9]+-[0-9]+")) {
                            int sep = s.indexOf(45);
                            d.setPort(Integer.parseInt(s.substring(0, sep)));
                            d.setMaxPort(Integer.parseInt(s.substring(sep + 1)));
                            continue block14;
                        }
                        d.setPort(na.getValue().asInt().get());
                        continue block14;
                    }
                }
                if (na.getValue().isNull()) {
                    if (na.getKey().isBoolean()) {
                        boolean v = na.getKey().asBoolean().get();
                        d.setEnabled(na.isNegated() != v);
                        continue;
                    }
                    if (na.getKey().asInt().isPresent()) {
                        d.setPort(na.getKey().asInt().get());
                        continue;
                    }
                    d.options.add(na);
                    continue;
                }
                d.options.add(na);
            }
        }
        return d;
    }

    public List<NArg> getOptions() {
        return this.options;
    }

    public NArg getOption(String key) {
        for (NArg option : this.options) {
            if (!Objects.equals(option.getKey().asString(), key)) continue;
            return option;
        }
        return null;
    }

    public boolean isAll() {
        return this.all;
    }

    public NDebugString setAll(boolean all) {
        this.all = all;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public NDebugString setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public NDebugString setPort(int port) {
        this.port = port;
        return this;
    }

    public boolean isTcp() {
        return this.tcp;
    }

    public NDebugString setTcp(boolean tcp) {
        this.tcp = tcp;
        return this;
    }

    public boolean isSuspend() {
        return this.suspend;
    }

    public NDebugString setSuspend(boolean suspend) {
        this.suspend = suspend;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NDebugString that = (NDebugString)o;
        return this.all == that.all && this.enabled == that.enabled && this.port == that.port && this.maxPort == that.maxPort && this.tcp == that.tcp && this.suspend == that.suspend && Objects.equals(this.options, that.options);
    }

    public int hashCode() {
        return Objects.hash(this.all, this.enabled, this.port, this.maxPort, this.tcp, this.suspend, this.options);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.isEnabled() ? "enabled" : "disabled");
        if (this.all) {
            sb.append(",all");
        }
        if (this.port > 0) {
            sb.append(",").append(this.port);
        }
        if (this.maxPort > 0) {
            sb.append(",max-port=").append(this.maxPort);
        }
        if (this.isSuspend()) {
            sb.append(",suspend");
        }
        for (NArg option : this.options) {
            sb.append(",").append(option);
        }
        return sb.toString();
    }

    public int getMaxPort() {
        return this.maxPort;
    }

    public NDebugString setMaxPort(int maxPort) {
        this.maxPort = maxPort;
        return this;
    }
}

