/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.thevpc.nuts.Nuts;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.core.NClassLoaderNode;
import net.thevpc.nuts.internal.NReservedLangUtils;
import net.thevpc.nuts.internal.NReservedUtils;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.runtime.standalone.io.NCoreIOUtils;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.NReservedMavenUtils;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NIllegalArgumentException;

public class ExtraApiUtils {
    public static String resolveNutsVersionFromClassPath(NLog bLog) {
        return NReservedMavenUtils.resolveNutsApiVersionFromClassPath(bLog);
    }

    public static String resolveNutsIdDigestOrError() {
        String d = ExtraApiUtils.resolveNutsIdDigest();
        if (d == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Object[] urls = ExtraApiUtils.resolveClasspathURLs(cl, true);
            throw new NIllegalArgumentException(NMsg.ofPlain("unable to detect nuts digest. Most likely you are missing valid compilation of nuts.\n\t 'pom.properties' could not be resolved and hence, we are unable to resolve nuts version.\n\t java=" + System.getProperty("java.home") + " as " + System.getProperty("java.version") + "\n\t class-path=" + System.getProperty("java.class.path") + "\n\t urls=" + Arrays.toString(urls) + "\n\t class-loader=" + cl.getClass().getName() + " as " + cl));
        }
        return d;
    }

    public static String resolveNutsIdDigest() {
        return ExtraApiUtils.resolveNutsIdDigest(NId.getApi(Nuts.getVersion()).get(), ExtraApiUtils.resolveClasspathURLs(Nuts.class.getClassLoader(), true));
    }

    public static String resolveNutsIdDigest(NId id, URL[] urls) {
        return NCoreIOUtils.getURLDigest(ExtraApiUtils.findClassLoaderJar(id, urls), null);
    }

    public static boolean asBoolean(Boolean value) {
        return ExtraApiUtils.asBooleanOr(value, false);
    }

    public static boolean asBooleanOr(Boolean value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static URL findClassLoaderJar(NId id, URL[] urls) {
        for (URL url : urls) {
            NId[] nutsBootIds;
            for (NId i : nutsBootIds = NReservedMavenUtils.resolveJarIds(url)) {
                if (!NBlankable.isBlank(id.getGroupId()) && !i.getGroupId().equals(id.getGroupId()) || !NBlankable.isBlank(id.getArtifactId()) && !i.getArtifactId().equals(id.getArtifactId()) || !NBlankable.isBlank(id.getVersion()) && !i.getVersion().equals(id.getVersion())) continue;
                return url;
            }
        }
        return null;
    }

    public static URL[] resolveClasspathURLs(ClassLoader contextClassLoader, boolean includeClassPath) {
        String classPath;
        LinkedHashSet<URL> all = new LinkedHashSet<URL>();
        if (includeClassPath && (classPath = System.getProperty("java.class.path")) != null) {
            for (String s : classPath.split(System.getProperty("path.separator"))) {
                if ((s = s.trim()).length() <= 0) continue;
                try {
                    Path pp = Paths.get(s, new String[0]);
                    if (!Files.exists(pp, new LinkOption[0])) continue;
                    all.add(pp.toUri().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        if (contextClassLoader != null) {
            if (contextClassLoader instanceof URLClassLoader) {
                all.addAll(Arrays.asList(((URLClassLoader)contextClassLoader).getURLs()));
            } else {
                try {
                    Enumeration<URL> r = contextClassLoader.getResources("META-INF/MANIFEST.MF");
                    while (r.hasMoreElements()) {
                        URL u = r.nextElement();
                        if ("jrt".equals(u.getProtocol()) || !"jar".equals(u.getProtocol()) || !u.getFile().endsWith("!/META-INF/MANIFEST.MF")) continue;
                        String jar = u.getFile().substring(0, u.getFile().length() - "!/META-INF/MANIFEST.MF".length());
                        all.add(CoreIOUtils.urlOf(jar));
                    }
                }
                catch (IOException | UncheckedIOException exception) {
                    // empty catch block
                }
            }
        }
        return all.toArray(new URL[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isLoadedClassPath(URL url, ClassLoader contextClassLoader, NLog bLog) {
        block24: {
            try {
                if (url == null) break block24;
                if (contextClassLoader == null) {
                    return false;
                }
                File file = NCoreIOUtils.toFile(url);
                if (file == null) {
                    throw new NIllegalArgumentException(NMsg.ofC("unsupported classpath item; expected a file path: %s", url));
                }
                ZipFile zipFile = null;
                try {
                    zipFile = new ZipFile(file);
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry zipEntry = entries.nextElement();
                        String zname = zipEntry.getName();
                        if (zname.endsWith("/") || !zname.endsWith(".class") || zname.contains("$")) continue;
                        if (NReservedUtils.isInfiniteLoopThread(NReservedLangUtils.class.getName(), "isLoadedClassPath")) {
                            boolean bl = false;
                            return bl;
                        }
                        URL incp = contextClassLoader.getResource(zname);
                        String clz = zname.substring(0, zname.length() - 6).replace('/', '.');
                        if (incp != null) {
                            bLog.log(NMsg.ofC("url %s is already in classpath. checked class %s successfully", url, clz).asFinest().withIntent(NMsgIntent.SUCCESS));
                            boolean bl = true;
                            return bl;
                        }
                        bLog.log(NMsg.ofC("url %s is not in classpath. failed to check class %s", url, clz).asFinest().withIntent(NMsgIntent.FAIL));
                        boolean bl = false;
                        return bl;
                    }
                }
                finally {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        bLog.log(NMsg.ofC("url %s is not in classpath. no class found to check", url).asFinestFail());
        return false;
    }

    private static void fillBootDependencyNodes(NClassLoaderNode node, Set<URL> urls, Set<String> visitedIds, NLog bLog) {
        if (node.getId() == null) {
            if (!node.isIncludedInClasspath()) {
                urls.add(node.getURL());
            } else {
                bLog.log(NMsg.ofC("url will not be loaded (already in classloader) : %s", node.getURL()).asWarning().withIntent(NMsgIntent.CACHE));
            }
            for (NClassLoaderNode dependency : node.getDependencies()) {
                ExtraApiUtils.fillBootDependencyNodes(dependency, urls, visitedIds, bLog);
            }
            return;
        }
        String shortName = node.getId().getShortName();
        if (!visitedIds.contains(shortName)) {
            visitedIds.add(shortName);
            if (!node.isIncludedInClasspath()) {
                urls.add(node.getURL());
            } else {
                bLog.log(NMsg.ofC("url will not be loaded (already in classloader) : %s", node.getURL()).asWarning().withIntent(NMsgIntent.CACHE));
            }
            for (NClassLoaderNode dependency : node.getDependencies()) {
                ExtraApiUtils.fillBootDependencyNodes(dependency, urls, visitedIds, bLog);
            }
        }
    }

    public static URL[] resolveClassWorldURLs(NClassLoaderNode[] nodes, ClassLoader contextClassLoader, NLog bLog) {
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        HashSet<String> visitedIds = new HashSet<String>();
        for (NClassLoaderNode info : nodes) {
            if (info == null) continue;
            ExtraApiUtils.fillBootDependencyNodes(info, urls, visitedIds, bLog);
        }
        return urls.toArray(new URL[0]);
    }
}

