/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.thevpc.nuts.artifact.NArtifactNotFoundException;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorParser;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.command.NDeployCmd;
import net.thevpc.nuts.command.NFetchCmd;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NIOUtils;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.runtime.standalone.definition.DefaultNDefinitionBuilder;
import net.thevpc.nuts.runtime.standalone.io.util.UnzipOptions;
import net.thevpc.nuts.runtime.standalone.io.util.ZipUtils;
import net.thevpc.nuts.security.NWorkspaceSecurityManager;
import net.thevpc.nuts.text.NDescriptorFormat;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NStringUtils;
import net.thevpc.nuts.util.NUnsupportedOperationException;

public class DefaultSourceControlHelper {
    public DefaultSourceControlHelper(NWorkspace workspace) {
    }

    protected NLog _LOG() {
        return NLog.of(DefaultSourceControlHelper.class);
    }

    public NId commit(Path folder) {
        NWorkspaceSecurityManager.of().checkAllowed("deploy", "commit");
        if (folder == null || !Files.isDirectory(folder, new LinkOption[0])) {
            throw new NIllegalArgumentException(NMsg.ofC("not a directory %s", folder));
        }
        Path file = folder.resolve("nuts.json");
        NDescriptor d = NDescriptorParser.of().parse(file).get();
        String oldVersion = NStringUtils.trim(d.getId().getVersion().getValue());
        if (oldVersion.endsWith("-CHECKED-OUT")) {
            oldVersion = oldVersion.substring(0, oldVersion.length() - "-CHECKED-OUT".length());
            String newVersion = NVersion.get(oldVersion).get().inc().getValue();
            NDefinition newVersionFound = null;
            try {
                newVersionFound = NFetchCmd.of(d.getId().builder().setVersion(newVersion).build()).setDependencyFilter(NDependencyFilters.of().byRunnable()).getResultDefinition();
            }
            catch (NArtifactNotFoundException ex) {
                this._LOG().log(NMsg.ofC("failed to fetch %s", d.getId().builder().setVersion(newVersion).build()).asFine(ex));
            }
            d = newVersionFound == null ? d.builder().setId(d.getId().builder().setVersion(newVersion).build()).build() : d.builder().setId(d.getId().builder().setVersion(oldVersion + ".1").build()).build();
            NId newId = NDeployCmd.of().setContent(folder).setDescriptor(d).getResult().get(0);
            NDescriptorFormat.of(d).print(file);
            NIOUtils.delete(folder);
            return newId;
        }
        throw new NUnsupportedOperationException(NMsg.ofPlain("commit not supported"));
    }

    public NDefinition checkout(String id, Path folder) {
        return this.checkout(NId.get(id).get(), folder);
    }

    public NDefinition checkout(NId id, Path folder) {
        NWorkspaceSecurityManager.of().checkAllowed("install", "checkout");
        NDefinition nutToInstall = NFetchCmd.of(id).setDependencyFilter(NDependencyFilters.of().byRunnable()).getResultDefinition();
        if ("zip".equals(nutToInstall.getDescriptor().getPackaging())) {
            try {
                ZipUtils.unzip(nutToInstall.getContent().map(Object::toString).get(), NPath.of(folder).toAbsolute().toString(), new UnzipOptions().setSkipRoot(false));
            }
            catch (IOException ex) {
                throw new NIOException(ex);
            }
            Path file = folder.resolve("nuts.json");
            NDescriptor d = NDescriptorParser.of().parse(file).get();
            NVersion oldVersion = d.getId().getVersion();
            NId newId = d.getId().builder().setVersion(oldVersion + "-CHECKED-OUT").build();
            d = d.builder().setId(newId).build();
            NDescriptorFormat.of(d).print(file);
            return new DefaultNDefinitionBuilder().setRepositoryUuid(nutToInstall.getRepositoryUuid()).setRepositoryName(nutToInstall.getRepositoryName()).setId(newId.getLongId()).setDescriptor(d).setContent(NPath.of(folder).setUserCache(false).setUserTemporary(false)).setDependency(id.toDependency()).build();
        }
        throw new NUnsupportedOperationException(NMsg.ofPlain("checkout not supported"));
    }
}

