/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util;

import java.util.NoSuchElementException;
import net.thevpc.nuts.util.NEnum;

public class CoreEnumUtils {
    public static String getEnumString(Enum e) {
        return e.toString().toLowerCase().replace("_", "-");
    }

    public static <T extends Enum> T parseEnumString(String val, Class<T> e, boolean lenient) {
        if (NEnum.class.isAssignableFrom(e)) {
            Enum r = (Enum)NEnum.parse(e, val).orNull();
            if (r != null) {
                return (T)r;
            }
            if (lenient) {
                return null;
            }
            throw new NoSuchElementException(val + " of type " + e.getSimpleName());
        }
        val = val == null ? "" : val.trim();
        T r = null;
        if (!val.isEmpty()) {
            r = Enum.valueOf(e, val);
        }
        if (r != null) {
            return r;
        }
        if (lenient) {
            return null;
        }
        throw new NoSuchElementException(val + " of type " + e.getSimpleName());
    }
}

