/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.util;

import java.lang.reflect.Array;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thevpc.nuts.elem.NArrayElement;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.elem.NObjectElement;
import net.thevpc.nuts.elem.NPairElement;
import net.thevpc.nuts.elem.NPrimitiveElement;
import net.thevpc.nuts.runtime.standalone.util.CoreNUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.text.NFormattable;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTextStyles;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NStringUtils;

public class NTextUtils {
    public static NText stringValueFormatted(Object o, boolean escapeString) {
        ArrayList<Object> all;
        Object[] a;
        Object c;
        NTexts txt = NTexts.of();
        if (o == null) {
            return txt.ofBlank();
        }
        if (o instanceof NFormattable) {
            return txt.of(o);
        }
        if (o instanceof NPrimitiveElement) {
            o = ((NPrimitiveElement)o).asLiteral().asObject().orNull();
        } else if (o instanceof NArrayElement) {
            o = ((NArrayElement)o).children();
        } else {
            if (o instanceof NObjectElement) {
                List<NElement> c2 = ((NObjectElement)o).children();
                Object[] a2 = c2.toArray();
                if (a2.length == 0) {
                    return txt.ofBlank();
                }
                if (a2.length == 1) {
                    return txt.ofPlain(CoreStringUtils.stringValue(a2[0]));
                }
                return txt.ofBuilder().append("{").appendJoined(txt.ofPlain(", "), c2.stream().map(x -> NTextUtils.stringValueFormatted(x, escapeString)).collect(Collectors.toList())).append("}");
            }
            if (o instanceof NPairElement) {
                NPairElement ne = (NPairElement)o;
                NTextBuilder sb = NTextBuilder.of();
                sb.append(NTextUtils.stringValueFormatted(ne.key(), escapeString));
                sb.append("=");
                if (ne.value().type().isAnyString()) {
                    sb.append(txt.of(NStringUtils.formatStringLiteral(NTextUtils.stringValueFormatted(ne.value(), escapeString).toString(), ne.value().type())));
                } else {
                    sb.append(NTextUtils.stringValueFormatted(ne.value(), escapeString));
                }
                o = sb.toString();
            } else {
                if (o instanceof Map.Entry) {
                    Map.Entry ne = (Map.Entry)o;
                    NTextBuilder sb = NTextBuilder.of();
                    sb.append(NTextUtils.stringValueFormatted(ne.getKey(), escapeString));
                    sb.append("=");
                    if (ne.getValue() instanceof String || ne.getValue() instanceof NElement && ((NElement)ne.getValue()).isString()) {
                        sb.append(txt.of(NStringUtils.formatStringLiteral(NTextUtils.stringValueFormatted(ne.getValue(), escapeString).toString(), NElementType.DOUBLE_QUOTED_STRING)));
                    } else {
                        sb.append(NTextUtils.stringValueFormatted(ne.getValue(), escapeString));
                    }
                    return sb.immutable();
                }
                if (o instanceof Map) {
                    o = ((Map)o).entrySet();
                }
            }
        }
        if (o == null) {
            return txt.ofBlank();
        }
        if (o instanceof Instant) {
            return txt.ofPlain(CoreNUtils.DEFAULT_DATE_TIME_FORMATTER.format((Instant)o));
        }
        if (o instanceof Temporal) {
            return txt.ofPlain(CoreNUtils.DEFAULT_DATE_TIME_FORMATTER.format((Temporal)o));
        }
        if (o instanceof Date) {
            return txt.ofPlain(CoreNUtils.DEFAULT_DATE_TIME_FORMATTER.format(((Date)o).toInstant()));
        }
        if (o instanceof Collection) {
            c = (Collection)o;
            a = c.toArray();
            if (a.length == 0) {
                return txt.ofBlank();
            }
            if (a.length == 1) {
                return txt.ofPlain(CoreStringUtils.stringValue(a[0]));
            }
            List ll = c.stream().map(x -> NTextUtils.stringValueFormatted(x, escapeString)).collect(Collectors.toList());
            return txt.ofBuilder().append("[").appendJoined(txt.ofPlain(", "), ll).append("]");
        }
        if (o instanceof Map) {
            c = (Map)o;
            a = c.entrySet().toArray(new Map.Entry[0]);
            if (a.length == 0) {
                return txt.ofBlank();
            }
            if (a.length == 1) {
                return txt.ofPlain(CoreStringUtils.stringValue(a[0]));
            }
            List ll = Arrays.stream(a).map(x -> NTextUtils.stringValueFormatted(x, escapeString)).collect(Collectors.toList());
            return txt.ofBuilder().append("{").appendJoined(txt.ofPlain(", "), ll).append("}");
        }
        if (o.getClass().isArray()) {
            int len = Array.getLength(o);
            if (len == 0) {
                return txt.ofBlank();
            }
            if (len == 1) {
                return NTextUtils.stringValueFormatted(Array.get(o, 0), escapeString);
            }
            all = new ArrayList(len);
            for (int i = 0; i < len; ++i) {
                all.add(NTextUtils.stringValueFormatted(Array.get(o, i), escapeString));
            }
            return txt.ofBuilder().append("[").appendJoined(txt.ofPlain(", "), all).append("]");
        }
        if (o instanceof Iterator) {
            Iterator x2 = (Iterator)o;
            all = new ArrayList<Object>();
            while (x2.hasNext()) {
                all.add(NTextUtils.stringValueFormatted(x2.next(), escapeString).toString());
            }
            return NTextUtils.stringValueFormatted(all, escapeString);
        }
        return txt.of(o);
    }

    public static NText formatLogValue(NTexts text, Object unresolved, Object resolved) {
        NText b;
        NText a = NTextUtils.desc(unresolved, text);
        if (a.equals(b = NTextUtils.desc(resolved, text))) {
            return a;
        }
        return text.ofBuilder().append(a).append(" => ").append(b);
    }

    public static NText desc(Object s, NTexts text) {
        if (s == null || s instanceof String && ((String)s).isEmpty()) {
            return text.ofStyled("<EMPTY>", NTextStyle.option());
        }
        return text.of(s);
    }

    public static String escapeText0(String str) {
        if (str == null) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str.length());
        block3: for (char c : str.toCharArray()) {
            switch (c) {
                case '\u001e': 
                case '#': 
                case '\\': 
                case '`': {
                    sb.append('\\').append(c);
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static boolean isSpecialLiteral(Object m) {
        if (m == null) {
            return true;
        }
        if (m instanceof Number) {
            return true;
        }
        if (m instanceof Temporal) {
            return true;
        }
        if (m instanceof Date) {
            return true;
        }
        if (m instanceof Boolean) {
            return true;
        }
        if (m instanceof String) {
            return true;
        }
        return m instanceof StringBuilder;
    }

    public static NTextStyles getSpecialLiteralType(Object m) {
        if (m == null) {
            return NTextStyles.of(NTextStyle.warn());
        }
        if (m instanceof Number) {
            return NTextStyles.of(NTextStyle.number());
        }
        if (m instanceof Temporal) {
            return NTextStyles.of(NTextStyle.date());
        }
        if (m instanceof Date) {
            return NTextStyles.of(NTextStyle.date());
        }
        if (m instanceof Boolean) {
            return NTextStyles.of(NTextStyle.bool());
        }
        return NTextStyles.of(new NTextStyle[0]);
    }

    public static NText asLiteralOrText(Object m, String format, NTexts txt) {
        if (m == null) {
            return txt.ofStyled("null", NTextStyle.danger());
        }
        if (m instanceof Number) {
            return txt.ofStyled(String.valueOf(m), NTextStyle.number());
        }
        if (m instanceof Temporal) {
            return txt.ofStyled(String.valueOf(m), NTextStyle.date());
        }
        if (m instanceof Date) {
            return txt.ofStyled(String.valueOf(m), NTextStyle.date());
        }
        if (m instanceof Boolean) {
            return txt.ofStyled(String.valueOf(m), NTextStyle.keyword());
        }
        return txt.of(m);
    }
}

