/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.theme;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.UUID;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.runtime.standalone.text.theme.DefaultNTextFormatTheme;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringReaderExt;
import net.thevpc.nuts.runtime.standalone.xtra.web.DefaultNWebCli;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NTextFormatTheme;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTextStyleType;
import net.thevpc.nuts.text.NTextStyles;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NColor;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NLiteral;

public class NTextFormatPropertiesTheme
implements NTextFormatTheme {
    private final Properties props;
    private final NWorkspace workspace;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NTextFormatPropertiesTheme(String name, ClassLoader cls, NWorkspace workspace) {
        block26: {
            URL u;
            this.props = new Properties();
            this.workspace = workspace;
            if (name.indexOf(47) >= 0 || name.indexOf(92) >= 0) {
                try (InputStream is = NPath.of(name).getInputStream();){
                    this.props.load(is);
                    break block26;
                }
                catch (IOException e) {
                    throw new NIllegalArgumentException(NMsg.ofC("invalid theme: %s", name), (Throwable)e);
                }
            }
            if (cls == null) {
                cls = this.getClass().getClassLoader();
            }
            if ((u = cls.getResource("META-INF/ntf-themes/" + name + ".ntf-theme")) != null) {
                try {
                    InputStream inStream = null;
                    inStream = DefaultNWebCli.prepareGlobalOpenStream(u);
                    if (inStream == null) {
                        throw new NIllegalArgumentException(NMsg.ofC("invalid theme: %s", name));
                    }
                    try {
                        this.props.load(inStream);
                        break block26;
                    }
                    finally {
                        inStream.close();
                    }
                }
                catch (IOException e) {
                    throw new NIOException(e);
                }
            }
            NPath themeFile = NPath.ofIdStore(NId.getRuntime("SHARED").get(), NStoreType.CONF).resolve("themes").resolve(name);
            if (themeFile.isRegularFile()) {
                try (InputStream inStream = themeFile.getInputStream();){
                    this.props.load(inStream);
                    break block26;
                }
                catch (IOException e) {
                    throw new NIllegalArgumentException(NMsg.ofC("invalid theme: %s", name), (Throwable)e);
                }
            }
            throw new NIllegalArgumentException(NMsg.ofC("invalid theme: %s", name));
        }
    }

    @Override
    public String getName() {
        String themeName = this.props.getProperty("theme-name");
        if (NBlankable.isBlank(themeName)) {
            themeName = UUID.randomUUID().toString();
            this.props.put("theme-name", themeName);
        }
        return themeName;
    }

    @Override
    public NTextStyles toBasicStyles(NTextStyles styles, boolean basicTrueStyles) {
        NTextStyles ret = NTextStyles.PLAIN;
        if (styles != null) {
            for (NTextStyle style : styles) {
                ret = ret.append(this.toBasicStyles(style, basicTrueStyles));
            }
        }
        return ret;
    }

    private String getProp(NTextStyleType t, int variant) {
        String v = this.getProp(t, "" + variant);
        if (v != null) {
            return v;
        }
        v = this.getProp(t, "*");
        if (v != null) {
            StringReaderExt r = new StringReaderExt(v);
            StringBuilder sb = new StringBuilder();
            while (r.hasNext()) {
                if (r.peekChar() == '*') {
                    if (r.hasNext(1) && r.peekChar(1) == '%') {
                        r.readChar();
                        r.readChar();
                        StringBuilder mod = new StringBuilder();
                        while (r.hasNext() && r.peekChar() >= '0' && r.peekChar() <= '9') {
                            mod.append(r.readChar());
                        }
                        sb.append(variant % NLiteral.of(mod.toString()).asInt().orElse(1));
                        continue;
                    }
                    r.readChar();
                    sb.append(variant);
                    continue;
                }
                sb.append(r.readChar());
            }
            return sb.toString();
        }
        return v;
    }

    private int getVarValAsInt(String n) {
        return NLiteral.of(this.props.getProperty(n)).asInt().orElse(0);
    }

    private NColor getVarValAsColor(String n) {
        String b = this.props.getProperty(n);
        if (b != null && (b = b.trim()).startsWith("#")) {
            return NColor.of32(Integer.parseInt(b.substring(1), 16));
        }
        return null;
    }

    private String getProp(NTextStyleType t, String variant) {
        String name = t.name();
        String s = this.props.getProperty(name + "(" + variant + ")");
        if (s == null) {
            s = this.props.getProperty(name.toLowerCase() + "(" + variant + ")");
        }
        return s;
    }

    @Override
    public NTextStyles toBasicStyles(NTextStyle style, boolean basicTrueStyles) {
        if (style == null) {
            return NTextStyles.PLAIN;
        }
        if (style.getType().isBasic(basicTrueStyles)) {
            return NTextStyles.of(style);
        }
        return this.toBasicStyles(style, basicTrueStyles, 20);
    }

    public NTextStyles toBasicStyles(NTextStyle style, boolean basicTrueStyles, int maxLoop) {
        if (style == null) {
            return NTextStyles.PLAIN;
        }
        if (style.getType().isBasic(basicTrueStyles)) {
            return NTextStyles.of(style);
        }
        if (maxLoop <= 0) {
            throw new NIllegalArgumentException(NMsg.ofC("invalid ntf theme for %s(%s). infinite loop", style.getType(), style.getVariant()));
        }
        String s = this.getProp(style.getType(), style.getVariant());
        if (s == null) {
            switch (style.getType()) {
                case FORE_COLOR: {
                    return NTextStyles.of(NTextStyle.foregroundTrueColor(DefaultNTextFormatTheme.foregroundSimpleToTrueColor(style.getVariant())));
                }
                case BACK_COLOR: {
                    return NTextStyles.of(NTextStyle.foregroundTrueColor(DefaultNTextFormatTheme.backgroundSimpleToTrueColor(style.getVariant())));
                }
            }
            return NTextStyles.PLAIN;
        }
        NTextStyles ret = NTextStyles.PLAIN;
        for (String v : s.split(",")) {
            NTextStyles ss = this.toBasicStyles(v, basicTrueStyles, style.getVariant(), maxLoop - 1);
            ret = ret.append(ss);
        }
        return ret;
    }

    public NTextStyles toBasicStyles(String v, boolean basicTrueStyles, int defaultVariant, int maxLoop) {
        NTextStyleType st;
        int b;
        v = v.trim();
        int a = v.indexOf(40);
        String n = "";
        String k = v;
        if (a > 0 && (b = v.indexOf(41, a)) > 0) {
            n = v.substring(a + 1, b);
            k = v.substring(0, a);
        }
        n = n.trim();
        k = k.trim();
        if (n.equals("*") || n.isEmpty()) {
            n = "" + defaultVariant;
        }
        if ((st = NTextStyleType.parse(k).orNull()) == null) {
            if (NBlankable.isBlank(n)) {
                return NTextStyles.PLAIN;
            }
            String z = this.props.getProperty(n);
            if (z != null) {
                if (maxLoop < 0) {
                    return null;
                }
                return this.toBasicStyles(z, basicTrueStyles, defaultVariant, maxLoop - 1);
            }
            return NTextStyles.PLAIN;
        }
        switch (st) {
            case PLAIN: {
                return NTextStyles.of(NTextStyle.of(st, 0));
            }
            case FORE_COLOR: {
                NColor c = this.getVarValAsColor(n);
                if (c != null) {
                    return NTextStyles.of(NTextStyle.of(st, c.getRGB()));
                }
                Integer ii = NLiteral.of(n).asInt().orNull();
                if (ii == null) {
                    ii = this.getVarValAsInt(n);
                }
                if (basicTrueStyles) {
                    return this.toBasicStyles(NTextStyles.of(NTextStyle.foregroundTrueColor(DefaultNTextFormatTheme.foregroundSimpleToTrueColor(ii))), basicTrueStyles);
                }
            }
            case BACK_COLOR: {
                NColor c = this.getVarValAsColor(n);
                if (c != null) {
                    return NTextStyles.of(NTextStyle.of(st, c.getRGB()));
                }
                Integer ii = NLiteral.of(n).asInt().orNull();
                if (ii == null) {
                    ii = this.getVarValAsInt(n);
                }
                if (basicTrueStyles) {
                    return this.toBasicStyles(NTextStyles.of(NTextStyle.backgroundTrueColor(DefaultNTextFormatTheme.backgroundSimpleToTrueColor(ii))), basicTrueStyles);
                }
            }
            case FORE_TRUE_COLOR: 
            case BACK_TRUE_COLOR: {
                NColor c = this.getVarValAsColor(n);
                if (c != null) {
                    return NTextStyles.of(NTextStyle.of(st, c.getRGB()));
                }
                Integer ii = NLiteral.of(n).asInt().orNull();
                if (ii == null) {
                    ii = this.getVarValAsInt(n);
                }
                return NTextStyles.of(NTextStyle.of(st, ii));
            }
        }
        Integer ii = NLiteral.of(n).asInt().orNull();
        if (ii == null) {
            ii = this.getVarValAsInt(n);
        }
        return this.toBasicStyles(NTextStyle.of(st, ii), basicTrueStyles, maxLoop);
    }
}

