/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.theme;

import net.thevpc.nuts.text.NTextFormatTheme;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTextStyles;
import net.thevpc.nuts.util.NColor;

public class DefaultNTextFormatTheme
implements NTextFormatTheme {
    public static final int BLACK = 1;
    public static final int DARK_RED = 1;
    public static final int DARK_GREEN = 2;
    public static final int DARK_YELLOW = 3;
    public static final int DARK_BLUE = 4;
    public static final int DARK_VIOLET = 5;
    public static final int DARK_SKY = 6;
    public static final int LIGHT_GRAY = 7;
    public static final int DARK_GRAY = 8;
    public static final int BRIGHT_RED = 9;
    public static final int BRIGHT_GREEN = 10;
    public static final int BRIGHT_YELLOW = 11;
    public static final int BRIGHT_BLUE = 12;
    public static final int BRIGHT_VIOLET = 13;
    public static final int BRIGHT_SKY = 14;
    public static final int WHITE = 15;
    private static final int[] FG = new int[]{1, 4, 12, 6, 14, 2, 10, 5, 13, 3, 11, 1, 9, 8, 7, 15};
    private static final int[] BG = new int[]{1, 4, 12, 6, 14, 2, 10, 5, 13, 3, 11, 1, 9, 8, 7, 15};

    private static int mod16(int x) {
        return x >= 0 ? x % 16 : -x % 16;
    }

    private static int mod4(int x) {
        return x >= 0 ? x % 4 : -x % 4;
    }

    private static int mod2(int x) {
        return x >= 0 ? x % 2 : -x % 2;
    }

    @Override
    public String getName() {
        return "default";
    }

    public static int foregroundSimpleToTrueColor(int color) {
        if (color >= 0 && color < FG.length) {
            color = FG[color];
        }
        if (color < 0) {
            color = -color;
        }
        NColor c = NColor.ansiToColor(color %= 255);
        int rgb = c.getIntColor();
        return rgb;
    }

    public static int backgroundSimpleToTrueColor(int color) {
        if (color >= 0 && color < BG.length) {
            color = BG[color];
        }
        if (color < 0) {
            color = -color;
        }
        NColor c = NColor.ansiToColor(color %= 255);
        int rgb = c.getIntColor();
        return rgb;
    }

    @Override
    public NTextStyles toBasicStyles(NTextStyles styles, boolean basicTrueStyles) {
        NTextStyles ret = NTextStyles.PLAIN;
        if (styles != null) {
            for (NTextStyle style : styles) {
                ret = ret.append(this.toBasicStyles(style, basicTrueStyles));
            }
        }
        return ret;
    }

    @Override
    public NTextStyles toBasicStyles(NTextStyle style, boolean basicTrueStyles) {
        if (style == null) {
            return NTextStyles.PLAIN;
        }
        if (style.getType().isBasic(basicTrueStyles)) {
            return NTextStyles.of(style);
        }
        NTextStyles y = this.toBasicStyles0(style, basicTrueStyles);
        if (basicTrueStyles) {
            for (NTextStyle yy : y) {
                switch (yy.getType()) {
                    default: 
                }
            }
        }
        return y;
    }

    public NTextStyles toBasicStyles0(NTextStyle style, boolean basicTrueStyles) {
        if (style == null) {
            return NTextStyles.PLAIN;
        }
        switch (style.getType()) {
            case FORE_COLOR: {
                if (basicTrueStyles) {
                    return NTextStyles.of(NTextStyle.foregroundTrueColor(DefaultNTextFormatTheme.foregroundSimpleToTrueColor(style.getVariant())));
                }
                return NTextStyles.of(style);
            }
            case BACK_COLOR: {
                if (basicTrueStyles) {
                    return NTextStyles.of(NTextStyle.backgroundTrueColor(DefaultNTextFormatTheme.backgroundSimpleToTrueColor(style.getVariant())));
                }
                return NTextStyles.of(style);
            }
            case FORE_TRUE_COLOR: 
            case BACK_TRUE_COLOR: 
            case UNDERLINED: 
            case ITALIC: 
            case STRIKED: 
            case REVERSED: 
            case BOLD: 
            case BLINK: {
                return NTextStyles.of(style);
            }
            case PRIMARY: {
                return this.toBasicStyles(NTextStyle.foregroundColor(this.mapColor(style.getVariant())), basicTrueStyles);
            }
            case SECONDARY: {
                return this.toBasicStyles(NTextStyle.backgroundColor(this.mapColor(style.getVariant())), basicTrueStyles);
            }
            case TITLE: {
                return this.toBasicStyles(NTextStyle.primary(style.getVariant()), basicTrueStyles).append(NTextStyle.underlined());
            }
            case KEYWORD: {
                int x = DefaultNTextFormatTheme.mod4(style.getVariant());
                return this.toBasicStyles(NTextStyle.foregroundColor(x == 0 ? 4 : (x == 1 ? 6 : (x == 2 ? 5 : 13))), basicTrueStyles);
            }
            case OPTION: {
                int x = DefaultNTextFormatTheme.mod4(style.getVariant());
                return this.toBasicStyles(NTextStyle.foregroundColor(x == 0 ? 6 : (x == 1 ? 66 : (x == 2 ? 102 : 138))), basicTrueStyles);
            }
            case ERROR: {
                return this.toBasicStyles(NTextStyle.foregroundColor(1), basicTrueStyles);
            }
            case SUCCESS: {
                return this.toBasicStyles(NTextStyle.foregroundColor(2), basicTrueStyles);
            }
            case WARN: {
                return this.toBasicStyles(NTextStyle.foregroundColor(3), basicTrueStyles);
            }
            case INFO: {
                return this.toBasicStyles(NTextStyle.foregroundColor(6), basicTrueStyles);
            }
            case CONFIG: {
                return this.toBasicStyles(NTextStyle.foregroundColor(5), basicTrueStyles);
            }
            case DATE: 
            case NUMBER: 
            case BOOLEAN: {
                return this.toBasicStyles(NTextStyle.foregroundColor(5), basicTrueStyles);
            }
            case STRING: {
                return this.toBasicStyles(NTextStyle.foregroundColor(2), basicTrueStyles);
            }
            case COMMENTS: {
                return this.toBasicStyles(NTextStyle.foregroundColor(8), basicTrueStyles);
            }
            case SEPARATOR: {
                return this.toBasicStyles(NTextStyle.foregroundColor(208), basicTrueStyles);
            }
            case OPERATOR: {
                return this.toBasicStyles(NTextStyle.foregroundColor(208), basicTrueStyles);
            }
            case INPUT: {
                return this.toBasicStyles(NTextStyle.foregroundColor(11), basicTrueStyles);
            }
            case FAIL: {
                return this.toBasicStyles(NTextStyle.foregroundColor(124), basicTrueStyles);
            }
            case DANGER: {
                return this.toBasicStyles(NTextStyle.foregroundColor(124), basicTrueStyles);
            }
            case VAR: {
                return this.toBasicStyles(NTextStyle.foregroundColor(190), basicTrueStyles);
            }
            case PALE: {
                return this.toBasicStyles(NTextStyle.foregroundColor(250), basicTrueStyles);
            }
            case VERSION: {
                return this.toBasicStyles(NTextStyle.foregroundColor(220), basicTrueStyles);
            }
            case PATH: {
                return this.toBasicStyles(NTextStyle.foregroundColor(114), basicTrueStyles);
            }
        }
        throw new IllegalArgumentException("invalid text node style " + style);
    }

    private int mapColor(int v) {
        if (v == 0) {
            v = 1;
        }
        if (v < 0) {
            v = -v;
        }
        if (v < 16) {
            return FG[v];
        }
        return v;
    }
}

