/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.parser.v1;

import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.runtime.standalone.text.DefaultNTexts;
import net.thevpc.nuts.runtime.standalone.text.parser.v1.DefaultNTextNodeParser;
import net.thevpc.nuts.runtime.standalone.text.parser.v1.ParserStep;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NStringUtils;
import net.thevpc.nuts.util.NUnsupportedOperationException;

public class NewLineParserStep
extends ParserStep {
    StringBuilder start = new StringBuilder();

    public NewLineParserStep(char c) {
        this.start.append(c);
    }

    @Override
    public void consume(char c, DefaultNTextNodeParser.State state, boolean wasNewLine) {
        if (c == '\n') {
            this.start.append(c);
        } else {
            state.applyPopReplay(this, c);
        }
    }

    @Override
    public void appendChild(ParserStep tt) {
        throw new NUnsupportedOperationException();
    }

    @Override
    public NText toText() {
        DefaultNTexts factory0 = (DefaultNTexts)NTexts.of();
        return factory0.ofPlain(this.start.toString());
    }

    @Override
    public void end(DefaultNTextNodeParser.State p) {
        p.applyPop(this);
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NewLine(" + NStringUtils.formatStringLiteral(this.start.toString(), NElementType.DOUBLE_QUOTED_STRING));
        return sb.append(")").toString();
    }
}

