/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.runtime.standalone.text.DefaultNTextBuilder;
import net.thevpc.nuts.runtime.standalone.text.parser.AbstractNText;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNTextPlain;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNTextStyled;
import net.thevpc.nuts.text.NPrimitiveText;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTextStyles;
import net.thevpc.nuts.text.NTextTitle;
import net.thevpc.nuts.text.NTextType;
import net.thevpc.nuts.util.NStream;

public class DefaultNTextTitle
extends AbstractNText
implements NTextTitle {
    private final String start;
    private NText child;
    private int level;

    public DefaultNTextTitle(String start, int level, NText child) {
        this.start = start;
        this.level = level;
        this.child = child;
    }

    @Override
    public NTextType type() {
        return NTextType.TITLE;
    }

    public String getTextStyleCode() {
        String s = this.start.trim();
        int u = s.indexOf(41);
        return s.substring(0, u);
    }

    public String getStart() {
        return this.start;
    }

    @Override
    public NText getChild() {
        return this.child;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public int hashCode() {
        return Objects.hash(this.start, this.child, this.level);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNTextTitle that = (DefaultNTextTitle)o;
        return this.level == that.level && Objects.equals(this.start, that.start) && Objects.equals(this.child, that.child);
    }

    @Override
    public String filteredText() {
        return this.child.filteredText() + "\n";
    }

    @Override
    public boolean isEmpty() {
        return this.child.isEmpty();
    }

    @Override
    public int length() {
        return this.child.length() + 1;
    }

    @Override
    public NText immutable() {
        return this;
    }

    @Override
    public NText simplify() {
        NText c = this.child.simplify();
        if (!c.equals(this.child)) {
            return new DefaultNTextTitle(this.start, this.level, this.child);
        }
        return this;
    }

    @Override
    public boolean isWhitespace() {
        return false;
    }

    @Override
    public NStream<NPrimitiveText> toCharStream() {
        return this.child.toCharStream().concat(NStream.ofSingleton(new DefaultNTextPlain("\n")));
    }

    @Override
    public List<NPrimitiveText> toCharList() {
        ArrayList<NPrimitiveText> all = new ArrayList<NPrimitiveText>();
        for (NPrimitiveText aChar : this.child.toCharList()) {
            all.add((NPrimitiveText)DefaultNTextStyled.appendStyle(aChar, NTextStyles.of(NTextStyle.primary(this.level))));
        }
        all.add(new DefaultNTextPlain("\n"));
        return all;
    }

    @Override
    public NText substring(int start, int end) {
        return this.prerender().substring(start, end);
    }

    @Override
    public List<NText> split(String chars, boolean returnSeparator) {
        return this.prerender().split(chars, returnSeparator);
    }

    private NText prerender() {
        DefaultNTextBuilder sb = new DefaultNTextBuilder();
        sb.append(new DefaultNTextStyled(this.getChild(), NTextStyles.of(NTextStyle.primary(this.level))));
        sb.append("\n");
        return sb.build();
    }

    @Override
    public NText trimLeft() {
        NText c = this.getChild().trimLeft();
        return new DefaultNTextTitle(this.start, this.level, c);
    }

    @Override
    public NText trimRight() {
        NText c = this.getChild().trimRight();
        return new DefaultNTextTitle(this.start, this.level, c);
    }

    @Override
    public NText trim() {
        NText c = this.getChild().trim();
        return new DefaultNTextTitle(this.start, this.level, c);
    }
}

