/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.thevpc.nuts.runtime.standalone.text.parser.AbstractNText;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNTextPlain;
import net.thevpc.nuts.text.NPrimitiveText;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyled;
import net.thevpc.nuts.text.NTextStyles;
import net.thevpc.nuts.text.NTextType;
import net.thevpc.nuts.util.NStream;

public class DefaultNTextStyled
extends AbstractNText
implements NTextStyled {
    private final String start;
    private final String end;
    private NText child;
    private NTextStyles textStyles;
    private boolean completed;

    public static NText appendStyle(NText any, NTextStyles textStyles) {
        if (textStyles == null || textStyles.isPlain()) {
            return any;
        }
        if (any instanceof NTextStyled) {
            NTextStyled base = (NTextStyled)any;
            NTextStyles styles = base.getStyles();
            NTextStyles newStyles = styles.append(textStyles);
            return new DefaultNTextStyled(base.getChild(), newStyles);
        }
        return new DefaultNTextStyled(any, textStyles);
    }

    public DefaultNTextStyled(NText child, NTextStyles textStyle) {
        this("##", "##", child, true, textStyle);
    }

    public DefaultNTextStyled(String start, String end, NText child, boolean completed, NTextStyles textStyles) {
        this.start = start;
        this.end = end;
        this.child = child;
        this.completed = completed;
        this.textStyles = textStyles;
    }

    @Override
    public boolean isEmpty() {
        return this.child.isEmpty();
    }

    @Override
    public NTextStyles getStyles() {
        return this.textStyles;
    }

    @Override
    public NTextType type() {
        return NTextType.STYLED;
    }

    public String getEnd() {
        return this.end;
    }

    public String getStart() {
        return this.start;
    }

    @Override
    public NText getChild() {
        return this.child;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNTextStyled that = (DefaultNTextStyled)o;
        return this.completed == that.completed && Objects.equals(this.start, that.start) && Objects.equals(this.end, that.end) && Objects.equals(this.child, that.child) && Objects.equals(this.textStyles, that.textStyles);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.child, this.textStyles, this.completed);
    }

    @Override
    public String filteredText() {
        return this.child.filteredText();
    }

    @Override
    public int length() {
        return this.child.length();
    }

    @Override
    public NText immutable() {
        return this;
    }

    @Override
    public NText simplify() {
        NText c = this.child.simplify();
        if (this.child.equals(DefaultNTextPlain.EMPTY)) {
            return DefaultNTextPlain.EMPTY;
        }
        if (!c.equals(this.child)) {
            return new DefaultNTextStyled(this.start, this.end, c, this.completed, this.textStyles);
        }
        return this;
    }

    @Override
    public List<NPrimitiveText> toCharList() {
        ArrayList<NPrimitiveText> all = new ArrayList<NPrimitiveText>();
        for (NPrimitiveText child : this.child.toCharList()) {
            all.add((NPrimitiveText)DefaultNTextStyled.appendStyle(child, this.textStyles));
        }
        return all;
    }

    @Override
    public boolean isWhitespace() {
        return this.child.isWhitespace();
    }

    @Override
    public NStream<NPrimitiveText> toCharStream() {
        return this.child.toCharStream().map(x -> (NPrimitiveText)DefaultNTextStyled.appendStyle(x, this.textStyles));
    }

    @Override
    public NText substring(int start, int end) {
        return new DefaultNTextStyled(this.getStart(), this.getEnd(), this.child.substring(start, end), this.completed, this.textStyles);
    }

    @Override
    public List<NText> split(String separator, boolean returnSeparator) {
        return this.child.split(separator, returnSeparator).stream().map(x -> DefaultNTextStyled.appendStyle(x, this.textStyles)).collect(Collectors.toList());
    }

    @Override
    public NText trimLeft() {
        NText c = this.child.trimLeft();
        if (c == this.child) {
            return this;
        }
        return new DefaultNTextStyled(this.getStart(), this.getEnd(), c, this.completed, this.textStyles);
    }

    @Override
    public NText trimRight() {
        NText c = this.child.trimRight();
        if (c == this.child) {
            return this;
        }
        return new DefaultNTextStyled(this.getStart(), this.getEnd(), c, this.completed, this.textStyles);
    }

    @Override
    public NText trim() {
        NText c = this.child.trim();
        if (c == this.child) {
            return this;
        }
        return new DefaultNTextStyled(this.getStart(), this.getEnd(), c, this.completed, this.textStyles);
    }
}

