/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.runtime.standalone.text.parser.AbstractNText;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNTextPlain;
import net.thevpc.nuts.runtime.standalone.text.parser.NTextListSimplifier;
import net.thevpc.nuts.text.NPrimitiveText;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextList;
import net.thevpc.nuts.text.NTextType;
import net.thevpc.nuts.util.NStream;

public class DefaultNTextList
extends AbstractNText
implements NTextList {
    private final List<NText> children = new ArrayList<NText>();

    public DefaultNTextList(NText ... children) {
        if (children != null) {
            for (NText c : children) {
                if (c == null) continue;
                this.children.add(c);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        for (NText child : this.children) {
            if (child.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public NTextType type() {
        return NTextType.LIST;
    }

    @Override
    public int size() {
        return this.children.size();
    }

    @Override
    public NText get(int index) {
        return this.children.get(index);
    }

    @Override
    public List<NText> getChildren() {
        return new ArrayList<NText>(this.children);
    }

    @Override
    public NText simplify() {
        List<NText> all = new NTextListSimplifier().setInlineBuilders(false).addAll(this.children).toList();
        if (all.isEmpty()) {
            return DefaultNTextPlain.EMPTY;
        }
        if (all.size() == 1) {
            return all.get(0);
        }
        if (!all.equals(this.children)) {
            return new DefaultNTextList(all.toArray(new NText[0]));
        }
        return this;
    }

    @Override
    public boolean isNormalized() {
        for (NText child : this.children) {
            if (child.isNormalized()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<NText> iterator() {
        return Collections.unmodifiableList(this.children).iterator();
    }

    public int hashCode() {
        return Objects.hash(this.children);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNTextList nutsTexts = (DefaultNTextList)o;
        return Objects.equals(this.children, nutsTexts.children);
    }

    @Override
    public String filteredText() {
        StringBuilder sb = new StringBuilder();
        for (NText child : this.children) {
            sb.append(child.filteredText());
        }
        return sb.toString();
    }

    @Override
    public int length() {
        int count = 0;
        for (NText child : this.children) {
            count += child.length();
        }
        return count;
    }

    @Override
    public NText immutable() {
        return this;
    }

    @Override
    public NStream<NPrimitiveText> toCharStream() {
        if (this.children.isEmpty()) {
            return NStream.ofEmpty();
        }
        NStream<NPrimitiveText> s = this.children.get(0).toCharStream();
        for (int i = 1; i < this.children.size(); ++i) {
            s = s.concat(this.children.get(i).toCharStream());
        }
        return s;
    }

    @Override
    public boolean isWhitespace() {
        boolean hasContent = false;
        for (NText child : this.children) {
            if (child.isEmpty()) continue;
            if (!child.isWhitespace()) {
                return false;
            }
            hasContent = true;
        }
        return hasContent;
    }

    @Override
    public List<NPrimitiveText> toCharList() {
        ArrayList<NPrimitiveText> all = new ArrayList<NPrimitiveText>();
        for (NText child : this.children) {
            all.addAll(child.toCharList());
        }
        return all;
    }

    @Override
    public NText substring(int start, int end) {
        if (start < 0 || end < start || end > this.length()) {
            throw new IndexOutOfBoundsException("Invalid start or end");
        }
        ArrayList<NText> result = new ArrayList<NText>();
        int pos = 0;
        for (NText child : this.getChildren()) {
            int childLen = child.filteredText().length();
            int childStart = pos;
            int childEnd = pos + childLen;
            if (childEnd > start) {
                if (childStart >= end) break;
                int subStart = Math.max(start - childStart, 0);
                int subEnd = Math.min(end - childStart, childLen);
                result.add(child.substring(subStart, subEnd));
            }
            pos += childLen;
        }
        return new DefaultNTextList(result.toArray(new NText[0]));
    }

    @Override
    public List<NText> split(String separators, boolean keepSeparators) {
        ArrayList<NText> result = new ArrayList<NText>();
        NTextBuilder current = NTextBuilder.of();
        for (NText child : this.getChildren()) {
            List<NText> parts = child.split(separators, keepSeparators);
            for (NText part : parts) {
                String s = part.filteredText();
                if (keepSeparators && s.length() == 1 && separators.indexOf(s.charAt(0)) >= 0) {
                    if (current.length() > 0) {
                        result.add(current.build());
                        current = NTextBuilder.of();
                    }
                    result.add(part);
                    continue;
                }
                current.append(part);
            }
        }
        if (current.length() > 0) {
            result.add(current.build());
        }
        return result;
    }

    @Override
    public NText trimLeft() {
        ArrayList<NText> children = new ArrayList<NText>(this.getChildren());
        boolean trimmed = false;
        for (int i = 0; i < children.size(); ++i) {
            NText c;
            NText u = (NText)children.get(i);
            trimmed |= u != (c = u.trimLeft());
            int l = c.length();
            if (l > 0) {
                children.set(i, c);
                break;
            }
            children.remove(i);
            --i;
        }
        if (!trimmed) {
            return this;
        }
        return new DefaultNTextList(children.toArray(new NText[0]));
    }

    @Override
    public NText trimRight() {
        ArrayList<NText> children = new ArrayList<NText>(this.getChildren());
        boolean trimmed = false;
        for (int i = children.size() - 1; i >= 0; --i) {
            NText c;
            NText u = (NText)children.get(i);
            trimmed |= u != (c = u.trimRight());
            int l = c.length();
            if (l > 0) {
                children.set(i, c);
                break;
            }
            children.remove(i);
        }
        if (!trimmed) {
            return this;
        }
        return new DefaultNTextList(children.toArray(new NText[0]));
    }

    @Override
    public NText trim() {
        return this.trimLeft().trimRight();
    }
}

