/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNTextPlain;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNTextStyled;
import net.thevpc.nuts.runtime.standalone.text.parser.NTextSpecialBase;
import net.thevpc.nuts.text.NPrimitiveText;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextLink;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTextStyles;
import net.thevpc.nuts.text.NTextType;
import net.thevpc.nuts.util.NStream;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNTextLink
extends NTextSpecialBase
implements NTextLink {
    private String value;

    public DefaultNTextLink(String separator, String value) {
        super("```!", "link", separator, "```");
        this.value = value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public NTextType type() {
        return NTextType.LINK;
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultNTextLink that = (DefaultNTextLink)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public NText immutable() {
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }

    @Override
    public String filteredText() {
        return this.value == null ? "" : this.value;
    }

    @Override
    public int length() {
        return this.value == null ? 0 : this.value.length();
    }

    @Override
    public NText simplify() {
        if (this.value.isEmpty()) {
            return DefaultNTextPlain.EMPTY;
        }
        return this;
    }

    @Override
    public List<NPrimitiveText> toCharList() {
        ArrayList<NPrimitiveText> all = new ArrayList<NPrimitiveText>();
        for (char aChar : this.value.toCharArray()) {
            all.add(new DefaultNTextStyled(new DefaultNTextPlain(String.valueOf(aChar)), NTextStyles.of(NTextStyle.underlined())));
        }
        return all;
    }

    @Override
    public NStream<NPrimitiveText> toCharStream() {
        return NStream.ofStream(this.value.codePoints().mapToObj(c -> new DefaultNTextStyled(new DefaultNTextPlain(new String(Character.toChars(c))), NTextStyles.of(NTextStyle.underlined()))));
    }

    @Override
    public boolean isWhitespace() {
        return !this.value.isEmpty() && this.value.trim().isEmpty();
    }

    @Override
    public NText substring(int start, int end) {
        return this.prerender().substring(start, end);
    }

    @Override
    public List<NText> split(String chars, boolean returnSeparator) {
        return this.prerender().split(chars, returnSeparator);
    }

    private NText prerender() {
        return new DefaultNTextStyled(new DefaultNTextPlain(this.value), NTextStyles.of(NTextStyle.underlined()));
    }

    @Override
    public NText trimLeft() {
        String c = NStringUtils.trimLeft(this.value);
        if (Objects.equals(this.value, c)) {
            return this;
        }
        return new DefaultNTextLink(this.getSeparator(), c);
    }

    @Override
    public NText trimRight() {
        String c = NStringUtils.trimRight(this.value);
        if (Objects.equals(this.value, c)) {
            return this;
        }
        return new DefaultNTextLink(this.getSeparator(), c);
    }

    @Override
    public NText trim() {
        String c = NStringUtils.trim(this.value);
        if (Objects.equals(this.value, c)) {
            return this;
        }
        return new DefaultNTextLink(this.getSeparator(), c);
    }
}

