/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNTextPlain;
import net.thevpc.nuts.runtime.standalone.text.parser.NTextSpecialBase;
import net.thevpc.nuts.text.NPrimitiveText;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextInclude;
import net.thevpc.nuts.text.NTextType;
import net.thevpc.nuts.util.NStream;

public class DefaultNTextInclude
extends NTextSpecialBase
implements NTextInclude {
    private String value;

    public DefaultNTextInclude(String separator, String value) {
        super("```!", "include", separator, "```");
        this.value = value == null ? "" : value;
    }

    @Override
    public String getText() {
        return this.value;
    }

    @Override
    public NTextType type() {
        return NTextType.INCLUDE;
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultNTextInclude that = (DefaultNTextInclude)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public NText immutable() {
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }

    @Override
    public String filteredText() {
        return "";
    }

    @Override
    public int length() {
        return 0;
    }

    @Override
    public NText simplify() {
        if (this.value.isEmpty()) {
            return DefaultNTextPlain.EMPTY;
        }
        return this;
    }

    @Override
    public boolean isWhitespace() {
        return false;
    }

    @Override
    public NStream<NPrimitiveText> toCharStream() {
        return NStream.ofEmpty();
    }

    @Override
    public NText substring(int start, int end) {
        return new DefaultNTextPlain("");
    }

    @Override
    public List<NText> split(String chars, boolean returnSeparator) {
        return new ArrayList<NText>();
    }

    @Override
    public NText trim() {
        return this;
    }

    @Override
    public NText trimLeft() {
        return this;
    }

    @Override
    public NText trimRight() {
        return this;
    }
}

