/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.parser;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.thevpc.nuts.runtime.standalone.text.DefaultNTexts;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNTextPlain;
import net.thevpc.nuts.runtime.standalone.text.parser.NTextSpecialBase;
import net.thevpc.nuts.spi.NCodeHighlighter;
import net.thevpc.nuts.text.NPrimitiveText;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextCode;
import net.thevpc.nuts.text.NTextType;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NStream;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNTextCode
extends NTextSpecialBase
implements NTextCode {
    private final String text;

    public DefaultNTextCode(String start, String kind, String separator, String end, String text) {
        super(start, kind, kind != null && kind.length() > 0 && text != null && text.length() > 0 && (separator == null || separator.isEmpty()) ? " " : separator, end);
        this.text = text;
    }

    @Override
    public boolean isEmpty() {
        return this.text.isEmpty();
    }

    @Override
    public NText highlight() {
        NTexts txt = NTexts.of();
        NCodeHighlighter t = ((DefaultNTexts)txt).resolveCodeHighlighter(this.getKind());
        return t.stringToText(this.text, txt);
    }

    @Override
    public NText immutable() {
        return this;
    }

    @Override
    public NTextType type() {
        return NTextType.CODE;
    }

    @Override
    public String getValue() {
        return this.text;
    }

    @Override
    public String getQualifier() {
        return this.getKind();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultNTextCode that = (DefaultNTextCode)o;
        return Objects.equals(this.text, that.text) && Objects.equals(this.getQualifier(), that.getQualifier());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.text);
    }

    @Override
    public String filteredText() {
        return this.text == null ? "" : this.text;
    }

    @Override
    public int length() {
        return this.text == null ? 0 : this.text.length();
    }

    @Override
    public NText simplify() {
        if (this.text.isEmpty()) {
            return DefaultNTextPlain.EMPTY;
        }
        return this;
    }

    @Override
    public boolean isWhitespace() {
        return this.highlight().isWhitespace();
    }

    @Override
    public NStream<NPrimitiveText> toCharStream() {
        return this.highlight().toCharStream();
    }

    @Override
    public NText substring(int start, int end) {
        return new DefaultNTextCode(this.getStart(), this.getKind(), this.getSeparator(), this.getEnd(), this.getValue().substring(start, end));
    }

    @Override
    public List<NText> split(String chars, boolean returnSeparator) {
        return NStringUtils.split(this.getValue(), chars, false, false).stream().map(x -> new DefaultNTextCode(this.getStart(), this.getKind(), this.getSeparator(), this.getEnd(), (String)x)).collect(Collectors.toList());
    }

    @Override
    public NText trimLeft() {
        String c = NStringUtils.trimLeft(this.text);
        if (Objects.equals(this.text, c)) {
            return this;
        }
        return new DefaultNTextCode(this.getStart(), this.getKind(), this.getSeparator(), this.getEnd(), c);
    }

    @Override
    public NText trimRight() {
        String c = NStringUtils.trimRight(this.text);
        if (Objects.equals(this.text, c)) {
            return this;
        }
        return new DefaultNTextCode(this.getStart(), this.getKind(), this.getSeparator(), this.getEnd(), c);
    }

    @Override
    public NText trim() {
        String c = NStringUtils.trim(this.text);
        if (Objects.equals(this.text, c)) {
            return this;
        }
        return new DefaultNTextCode(this.getStart(), this.getKind(), this.getSeparator(), this.getEnd(), c);
    }
}

