/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.highlighter;

import java.util.ArrayList;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringReaderExt;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextPlain;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTexts;

public class StringReaderExtUtils {
    public static NText[] readSpaces(StringReaderExt ar) {
        NTexts factory = NTexts.of();
        StringBuilder sb = new StringBuilder();
        while (ar.hasNext() && ar.peekChar() <= ' ') {
            sb.append(ar.readChar());
        }
        return new NText[]{factory.ofPlain(sb.toString())};
    }

    public static NText[] readSlashSlashComments(StringReaderExt ar) {
        NTexts factory = NTexts.of();
        StringBuilder sb = new StringBuilder();
        if (!ar.peekChars("//")) {
            return null;
        }
        sb.append(ar.nextChars(2));
        boolean inLoop = true;
        block3: while (inLoop && ar.hasNext()) {
            switch (ar.peekChar()) {
                case '\n': 
                case '\r': {
                    sb.append(ar.readChar());
                    if (ar.hasNext() && ar.peekChar() == '\n') {
                        sb.append(ar.readChar());
                    }
                    inLoop = false;
                    continue block3;
                }
            }
            sb.append(ar.readChar());
        }
        return new NText[]{factory.ofStyled(sb.toString(), NTextStyle.comments())};
    }

    public static NText[] readSlashStarComments(StringReaderExt ar) {
        NTexts factory = NTexts.of();
        StringBuilder sb = new StringBuilder();
        if (!ar.peekChars("/*")) {
            return null;
        }
        sb.append(ar.nextChars(2));
        boolean inLoop = true;
        block3: while (inLoop && ar.hasNext()) {
            switch (ar.peekChar()) {
                case '*': {
                    if (ar.peekChars("*/")) {
                        sb.append(ar.nextChars(2));
                        inLoop = false;
                        continue block3;
                    }
                    sb.append(ar.readChar());
                    continue block3;
                }
            }
            sb.append(ar.readChar());
        }
        return new NText[]{factory.ofStyled(sb.toString(), NTextStyle.comments(2))};
    }

    public static NText[] readJSDoubleQuotesString(StringReaderExt ar) {
        NTexts factory = NTexts.of();
        ArrayList<NText> all = new ArrayList<NText>();
        boolean inLoop = true;
        StringBuilder sb = new StringBuilder();
        if (ar.hasNext() && ar.peekChars("\"")) {
            sb.append(ar.readChar());
            block4: while (inLoop && ar.hasNext()) {
                switch (ar.peekChar()) {
                    case '\\': {
                        if (sb.length() > 0) {
                            all.add(factory.ofStyled(sb.toString(), NTextStyle.string()));
                            sb.setLength(0);
                        }
                        StringBuilder sb2 = new StringBuilder();
                        sb2.append(ar.readChar());
                        if (ar.hasNext()) {
                            sb2.append(ar.readChar());
                            if (ar.peekChar() == 'u') {
                                for (int i = 0; i < 4; ++i) {
                                    char c2 = ar.peekChar();
                                    if (!Character.isDigit(c2) && (Character.toUpperCase(c2) < 'A' || Character.toUpperCase(c2) > 'F')) continue;
                                    sb2.append(ar.readChar());
                                }
                            }
                        }
                        all.add(factory.ofStyled(sb2.toString(), NTextStyle.separator()));
                        continue block4;
                    }
                    case '\"': {
                        sb.append(ar.readChar());
                        inLoop = false;
                        continue block4;
                    }
                }
                sb.append(ar.readChar());
            }
            if (sb.length() > 0) {
                all.add(factory.ofStyled(sb.toString(), NTextStyle.string()));
                sb.setLength(0);
            }
            return all.toArray(new NText[0]);
        }
        return null;
    }

    public static NText[] readJSSimpleQuotes(StringReaderExt ar) {
        NTexts factory = NTexts.of();
        ArrayList<NText> all = new ArrayList<NText>();
        boolean inLoop = true;
        StringBuilder sb = new StringBuilder();
        if (ar.hasNext() && ar.peekChars("'")) {
            sb.append(ar.readChar());
            block4: while (inLoop && ar.hasNext()) {
                switch (ar.peekChar()) {
                    case '\\': {
                        if (sb.length() > 0) {
                            all.add(factory.ofStyled(sb.toString(), NTextStyle.string()));
                            sb.setLength(0);
                        }
                        StringBuilder sb2 = new StringBuilder();
                        sb2.append(ar.readChar());
                        if (ar.hasNext()) {
                            sb2.append(ar.readChar());
                            if (ar.peekChar() == 'u') {
                                for (int i = 0; i < 4; ++i) {
                                    char c2 = ar.peekChar();
                                    if (!Character.isDigit(c2) && (Character.toUpperCase(c2) < 'A' || Character.toUpperCase(c2) > 'F')) continue;
                                    sb2.append(ar.readChar());
                                }
                            }
                        }
                        all.add(factory.ofStyled(sb2.toString(), NTextStyle.separator()));
                        continue block4;
                    }
                    case '\'': {
                        sb.append(ar.readChar());
                        inLoop = false;
                        continue block4;
                    }
                }
                sb.append(ar.readChar());
            }
            if (sb.length() > 0) {
                all.add(factory.ofStyled(sb.toString(), NTextStyle.string(2)));
                sb.setLength(0);
            }
            return all.toArray(new NText[0]);
        }
        return null;
    }

    public static NText[] readJSIdentifier(StringReaderExt ar) {
        NTexts factory = NTexts.of();
        ArrayList<NTextPlain> all = new ArrayList<NTextPlain>();
        StringBuilder sb = new StringBuilder();
        if (!ar.hasNext() || !Character.isJavaIdentifierStart(ar.peekChar())) {
            return null;
        }
        sb.append(ar.readChar());
        while (ar.hasNext() && Character.isJavaIdentifierPart(ar.peekChar())) {
            sb.append(ar.readChar());
        }
        all.add(factory.ofPlain(sb.toString()));
        return all.toArray(new NText[0]);
    }

    public static NText[] readNumber(StringReaderExt ar) {
        NTexts factory = NTexts.of();
        boolean nbrVisited = false;
        boolean minusVisited = false;
        boolean EminusVisited = false;
        boolean dotVisited = false;
        boolean EVisited = false;
        boolean Enbr = false;
        int index = 0;
        int lastOk = -1;
        boolean inLoop = true;
        while (inLoop && ar.hasNext(index)) {
            char c = ar.peekChar(index);
            switch (c) {
                case 'E': {
                    if (EVisited || !nbrVisited) {
                        inLoop = false;
                        break;
                    }
                    EVisited = true;
                    break;
                }
                case '.': {
                    if (dotVisited) {
                        inLoop = false;
                        break;
                    }
                    lastOk = index;
                    dotVisited = true;
                    break;
                }
                case '-': {
                    if (EVisited) {
                        if (EminusVisited || Enbr) {
                            inLoop = false;
                            break;
                        }
                        EminusVisited = true;
                        break;
                    }
                    nbrVisited = true;
                    break;
                }
                default: {
                    if (Character.isDigit(c)) {
                        if (EVisited) {
                            Enbr = true;
                        } else {
                            nbrVisited = true;
                        }
                        lastOk = index;
                        break;
                    }
                    inLoop = false;
                }
            }
            ++index;
        }
        if (lastOk >= 0) {
            return new NText[]{factory.ofStyled(ar.nextChars(lastOk + 1), NTextStyle.number())};
        }
        return null;
    }
}

