/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.highlighter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.thevpc.nuts.runtime.standalone.text.highlighter.TsonCodeHighlighter;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTextStyles;
import net.thevpc.nuts.util.NColor;
import net.thevpc.nuts.util.NNameFormat;
import net.thevpc.nuts.util.NScorableContext;

public class NTexupCodeHighlighter
extends TsonCodeHighlighter {
    public static final Set<String> ctrl = new HashSet<String>(Arrays.asList("import;page;page-group;styles;if;for".split(";")));
    public static final Set<String> attrs = new HashSet<String>(Arrays.asList("anchor;at;background;bg;bottom;class;color;columns;debug;disabled;draw-contour;fg;fill;font-bold;font-crossthrough;margin;columns-weight;from;to;ctrl;ctrl1;start-arrow;end-arrow;rows-weight;font-family;font-italic;font-size;font-underline;grid-color;hide;left;line-color;name;origin;position;preserve-aspect-ratio;right;rotate;rows;show;size;sphere;stroke;top;weights".split(";")));
    public static final Set<String> components = new HashSet<String>(Arrays.asList("arc;circle;ellipse;eq;equation;flow;grid;image;img;line;octagon;ol;pentagon;plain;points;polygon;polyline;rectangle;sphere;square;group;text;triangle;txt;ul;void;ntf;source;col;column;row;rhombus;diamond;parallelogram;trapezoid;quad-curve;cubic-curve;plot2d;plot3d;hexagon;helptagon;nonagon;decagon;arrow;donut;cylinder;pie;image;gantt;nwdiag;uml;wireframe;".split(";")));
    public static final Set<String> values = new HashSet<String>(Arrays.asList("center;left;right;true;false;red".split(";")));

    @Override
    public String getId() {
        return "ntexup";
    }

    @Override
    public int getScore(NScorableContext context) {
        String s = (String)context.getCriteria();
        if (s == null) {
            return 10;
        }
        switch (s) {
            case "ntexup": 
            case "application/ntexup": 
            case "text/ntexup": {
                return 10;
            }
        }
        return -1;
    }

    @Override
    protected NTextStyles resolveTokenStyle(String token, String next, NText last) {
        if ("(".equals(next) || "{".equals(next)) {
            if (ctrl.contains(token)) {
                return NTextStyles.of(NTextStyle.primary2());
            }
            if (components.contains(token)) {
                return NTextStyles.of(NTextStyle.primary1());
            }
            return NTextStyles.of(NTextStyle.primary1());
        }
        if (":".equals(next)) {
            if (attrs.contains(token)) {
                return NTextStyles.of(NTextStyle.primary3());
            }
            return NTextStyles.of(NTextStyle.primary3());
        }
        if (last != null) {
            String s = last.filteredText();
            if (s.equals(":")) {
                if (values.contains(token)) {
                    return NTextStyles.of(NTextStyle.primary4());
                }
                return NTextStyles.of(NTextStyle.primary4());
            }
            if (attrs.contains(token)) {
                return NTextStyles.of(NTextStyle.primary3());
            }
        }
        return super.resolveTokenStyle(token, next, last);
    }

    static {
        for (NColor c : NColor.ALL) {
            values.add(c.getName());
            values.add(NNameFormat.VAR_NAME.format(c.getName()));
            values.add(NNameFormat.SNAKE_CASE.format(c.getName()));
        }
    }
}

