/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.highlighter;

import java.util.ArrayList;
import java.util.Arrays;
import net.thevpc.nuts.runtime.standalone.text.highlighter.StringReaderExtUtils;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringReaderExt;
import net.thevpc.nuts.spi.NCodeHighlighter;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextPlain;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTextType;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NScorableContext;

public class JsonCodeHighlighter
implements NCodeHighlighter {
    @Override
    public String getId() {
        return "json";
    }

    @Override
    public NText tokenToText(String text, String nodeType, NTexts txt) {
        return txt.ofPlain(text);
    }

    @Override
    public int getScore(NScorableContext context) {
        String s = (String)context.getCriteria();
        if (s == null) {
            return 10;
        }
        switch (s) {
            case "json": 
            case "application/json": 
            case "text/json": {
                return 10;
            }
        }
        return -1;
    }

    @Override
    public NText stringToText(String text, NTexts txt) {
        ArrayList<NText> all = new ArrayList<NText>();
        StringReaderExt ar = new StringReaderExt(text);
        block15: while (ar.hasNext()) {
            NText[] d;
            switch (ar.peekChar()) {
                case ':': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    all.add(txt.ofStyled(String.valueOf(ar.readChar()), NTextStyle.separator()));
                    continue block15;
                }
                case '\'': {
                    all.addAll(Arrays.asList(StringReaderExtUtils.readJSSimpleQuotes(ar)));
                    continue block15;
                }
                case '\"': {
                    all.addAll(Arrays.asList(StringReaderExtUtils.readJSDoubleQuotesString(ar)));
                    continue block15;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    all.addAll(Arrays.asList(StringReaderExtUtils.readNumber(ar)));
                    continue block15;
                }
                case '-': 
                case '.': {
                    d = StringReaderExtUtils.readNumber(ar);
                    if (d != null) {
                        all.addAll(Arrays.asList(d));
                        continue block15;
                    }
                    all.add(txt.ofStyled(String.valueOf(ar.readChar()), NTextStyle.separator()));
                    continue block15;
                }
                case '/': {
                    if (ar.peekChars("//")) {
                        all.addAll(Arrays.asList(StringReaderExtUtils.readSlashSlashComments(ar)));
                        continue block15;
                    }
                    if (ar.peekChars("/*")) {
                        all.addAll(Arrays.asList(StringReaderExtUtils.readSlashStarComments(ar)));
                        continue block15;
                    }
                    all.add(txt.ofStyled(String.valueOf(ar.readChar()), NTextStyle.separator()));
                    continue block15;
                }
            }
            if (Character.isWhitespace(ar.peekChar())) {
                all.addAll(Arrays.asList(StringReaderExtUtils.readSpaces(ar)));
                continue;
            }
            d = StringReaderExtUtils.readJSIdentifier(ar);
            if (d != null) {
                if (d.length == 1 && d[0].type() == NTextType.PLAIN) {
                    String txt2;
                    switch (txt2 = ((NTextPlain)d[0]).getValue()) {
                        case "true": 
                        case "false": {
                            d[0] = txt.ofStyled(d[0], NTextStyle.bool());
                        }
                    }
                }
                all.addAll(Arrays.asList(d));
                continue;
            }
            all.add(txt.ofStyled(String.valueOf(ar.readChar()), NTextStyle.separator()));
        }
        return txt.ofList(all.toArray(new NText[0]));
    }
}

