/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.highlighter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.thevpc.nuts.runtime.standalone.text.highlighter.NCodeHighlighterHelper;
import net.thevpc.nuts.runtime.standalone.text.highlighter.StringReaderExtUtils;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringReaderExt;
import net.thevpc.nuts.spi.NCodeHighlighter;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextPlain;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTextType;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NScorableContext;

public class JavaCodeHighlighter
implements NCodeHighlighter {
    private Set<String> reservedWords = new HashSet<String>();

    public JavaCodeHighlighter() {
        this.reservedWords.addAll(NCodeHighlighterHelper.loadNames("java.kw1", this.getClass()));
    }

    @Override
    public String getId() {
        return "java";
    }

    @Override
    public NText tokenToText(String text, String nodeType, NTexts txt) {
        return txt.ofPlain(text);
    }

    @Override
    public int getScore(NScorableContext context) {
        String s = (String)context.getCriteria();
        if (s == null) {
            return 10;
        }
        switch (s) {
            case "java": 
            case "jav": 
            case "text/x-java": {
                return 10;
            }
        }
        return -1;
    }

    @Override
    public NText stringToText(String text, NTexts txt) {
        ArrayList<NText> all = new ArrayList<NText>();
        StringReaderExt ar = new StringReaderExt(text);
        block8: while (ar.hasNext()) {
            NText[] d;
            switch (ar.peekChar()) {
                case '!': 
                case '%': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    all.add(txt.ofStyled(String.valueOf(ar.readChar()), NTextStyle.separator()));
                    continue block8;
                }
                case '\'': {
                    all.addAll(Arrays.asList(StringReaderExtUtils.readJSSimpleQuotes(ar)));
                    continue block8;
                }
                case '\"': {
                    all.addAll(Arrays.asList(StringReaderExtUtils.readJSDoubleQuotesString(ar)));
                    continue block8;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    all.addAll(Arrays.asList(StringReaderExtUtils.readNumber(ar)));
                    continue block8;
                }
                case '-': 
                case '.': {
                    d = StringReaderExtUtils.readNumber(ar);
                    if (d != null) {
                        all.addAll(Arrays.asList(d));
                        continue block8;
                    }
                    all.add(txt.ofStyled(String.valueOf(ar.readChar()), NTextStyle.separator()));
                    continue block8;
                }
                case '/': {
                    if (ar.peekChars("//")) {
                        all.addAll(Arrays.asList(StringReaderExtUtils.readSlashSlashComments(ar)));
                        continue block8;
                    }
                    if (ar.peekChars("/*")) {
                        all.addAll(Arrays.asList(StringReaderExtUtils.readSlashStarComments(ar)));
                        continue block8;
                    }
                    all.add(txt.ofStyled(String.valueOf(ar.readChar()), NTextStyle.separator()));
                    continue block8;
                }
            }
            if (Character.isWhitespace(ar.peekChar())) {
                all.addAll(Arrays.asList(StringReaderExtUtils.readSpaces(ar)));
                continue;
            }
            d = StringReaderExtUtils.readJSIdentifier(ar);
            if (d != null) {
                String txt2;
                if (d.length == 1 && d[0].type() == NTextType.PLAIN && this.reservedWords.contains(txt2 = ((NTextPlain)d[0]).getValue())) {
                    d[0] = txt.ofStyled(d[0], NTextStyle.keyword());
                }
                all.addAll(Arrays.asList(d));
                continue;
            }
            all.add(txt.ofStyled(String.valueOf(ar.readChar()), NTextStyle.separator()));
        }
        return txt.ofList(all.toArray(new NText[0]));
    }
}

