/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.highlighter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.platform.NShellFamily;
import net.thevpc.nuts.runtime.standalone.text.highlighter.StringReaderExtUtils;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNTextPlain;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringReaderExt;
import net.thevpc.nuts.spi.NCodeHighlighter;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextPlain;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTextType;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NScorableContext;

public class BashCodeHighlighter
implements NCodeHighlighter {
    @Override
    public String getId() {
        return "sh";
    }

    @Override
    public int getScore(NScorableContext context) {
        String s = (String)context.getCriteria();
        if (s == null) {
            return 10;
        }
        switch (s) {
            case "sh": 
            case "bash": 
            case "csh": 
            case "zsh": 
            case "ksh": 
            case "text/x-shellscript": {
                return 10;
            }
            case "system": {
                switch (NShellFamily.getCurrent()) {
                    case SH: 
                    case BASH: 
                    case CSH: 
                    case ZSH: 
                    case KSH: {
                        return 20;
                    }
                }
                return 10;
            }
        }
        return -1;
    }

    @Override
    public NText tokenToText(String text, String nodeType, NTexts txt) {
        return txt.ofPlain(text);
    }

    private NText[] parseCmdLine_readSimpleQuotes(StringReaderExt ar, NTexts txt) {
        StringBuilder sb = new StringBuilder();
        sb.append(ar.readChar());
        ArrayList<NText> ret = new ArrayList<NText>();
        while (ar.hasNext()) {
            char c = ar.peekChar();
            if (c == '\\') {
                StringBuilder sb2 = new StringBuilder();
                sb2.append(ar.readChar());
                if (sb.length() > 0) {
                    ret.add(txt.ofStyled(sb.toString(), NTextStyle.string(2)));
                    sb.setLength(0);
                }
                if (ar.hasNext()) {
                    sb2.append(ar.readChar());
                }
                ret.add(txt.ofStyled(sb2.toString(), NTextStyle.separator()));
                break;
            }
            if (c == '\'') {
                sb.append(ar.readChar());
                break;
            }
            sb.append(ar.readChar());
        }
        if (sb.length() > 0) {
            ret.add(txt.ofStyled(sb.toString(), NTextStyle.string(2)));
            sb.setLength(0);
        }
        return ret.toArray(new NText[0]);
    }

    private NText[] parseCmdLine_readWord(StringReaderExt ar, NTexts txt) {
        StringBuilder sb = new StringBuilder();
        ArrayList<NText> ret = new ArrayList<NText>();
        boolean inLoop = true;
        boolean endsWithSep = false;
        block6: while (inLoop && ar.hasNext()) {
            char c = ar.peekChar();
            switch (c) {
                case '\\': {
                    if (sb.length() > 0) {
                        ret.add(txt.ofPlain(sb.toString()));
                        sb.setLength(0);
                    }
                    ret.addAll(Arrays.asList(BashCodeHighlighter.parseCmdLine_readAntiSlash(ar)));
                    continue block6;
                }
                case ';': {
                    endsWithSep = true;
                    inLoop = false;
                    continue block6;
                }
                case ':': {
                    endsWithSep = true;
                    inLoop = false;
                    continue block6;
                }
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case ']': 
                case '`': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    inLoop = false;
                    continue block6;
                }
            }
            if (c <= ' ') {
                endsWithSep = true;
                inLoop = false;
                continue;
            }
            sb.append(ar.readChar());
        }
        if (sb.length() > 0) {
            ret.add(txt.ofPlain(sb.toString()));
            sb.setLength(0);
        }
        if (ret.isEmpty()) {
            throw new IllegalArgumentException("was not expecting " + ar.peekChar() + " as part of word");
        }
        if (((NText)ret.get(0)).type() == NTextType.PLAIN && BashCodeHighlighter.isOption(((NTextPlain)ret.get(0)).getValue())) {
            ret.set(0, txt.ofStyled((NText)ret.get(0), NTextStyle.option()));
        }
        return ret.toArray(new NText[0]);
    }

    private static NText[] parseCmdLine_readAntiSlash(StringReaderExt ar) {
        StringBuilder sb2 = new StringBuilder();
        sb2.append(ar.readChar());
        if (ar.hasNext()) {
            sb2.append(ar.readChar());
        }
        NTexts factory = NTexts.of();
        return new NText[]{factory.ofStyled(sb2.toString(), NTextStyle.separator())};
    }

    private NText[] parseCmdLine_readDollar(StringReaderExt ar, NTexts txt) {
        char c;
        if (ar.peekChars("$((")) {
            return this.parseCmdLine_readDollarPar2(ar, txt);
        }
        StringBuilder sb2 = new StringBuilder();
        if (ar.hasNext(1)) {
            switch (ar.peekChar(1)) {
                case '(': {
                    return this.parseCmdLine_readDollarPar2(ar, txt);
                }
                case '{': {
                    return this.parseCmdLine_readDollarCurlyBrackets(ar, txt);
                }
                case '*': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case '?': 
                case '@': {
                    sb2.append(ar.readChar());
                    sb2.append(ar.readChar());
                    return new NText[]{txt.ofStyled(sb2.toString(), NTextStyle.separator())};
                }
            }
        }
        ar.readChar();
        while (ar.hasNext() && (Character.isAlphabetic(c = ar.peekChar()) || Character.isDigit(c) || c == '_')) {
            sb2.append(ar.readChar());
        }
        if (sb2.length() > 0) {
            return new NText[]{txt.ofStyled("$", NTextStyle.separator()), txt.ofStyled(sb2.toString(), NTextStyle.keyword(4))};
        }
        return new NText[]{txt.ofStyled("$", NTextStyle.separator())};
    }

    private NText[] parseCmdLine_readDoubleQuotes(StringReaderExt ar, NTexts txt) {
        ArrayList<NText> ret = new ArrayList<NText>();
        StringBuilder sb = new StringBuilder();
        ret.add(txt.ofStyled(String.valueOf(ar.readChar()), NTextStyle.string()));
        while (ar.hasNext()) {
            char c = ar.peekChar();
            if (c == '\\') {
                if (sb.length() > 0) {
                    ret.add(txt.ofStyled(sb.toString(), NTextStyle.string()));
                    sb.setLength(0);
                }
                ret.addAll(Arrays.asList(BashCodeHighlighter.parseCmdLine_readAntiSlash(ar)));
                continue;
            }
            if (c == '$') {
                if (sb.length() > 0) {
                    ret.add(txt.ofStyled(sb.toString(), NTextStyle.string()));
                    sb.setLength(0);
                }
                ret.addAll(Arrays.asList(this.parseCmdLine_readDollar(ar, txt)));
                continue;
            }
            if (c == '\"') {
                if (sb.length() > 0) {
                    ret.add(txt.ofStyled(sb.toString(), NTextStyle.string()));
                    sb.setLength(0);
                }
                ret.add(txt.ofStyled(String.valueOf(ar.readChar()), NTextStyle.string()));
                break;
            }
            sb.append(ar.readChar());
        }
        if (sb.length() > 0) {
            ret.add(txt.ofStyled(sb.toString(), NTextStyle.string()));
            sb.setLength(0);
        }
        return ret.toArray(new NText[0]);
    }

    private static TokenType resolveTokenType(NText n) {
        if (n instanceof DefaultNTextPlain) {
            String text = ((DefaultNTextPlain)n).getValue();
            if (text.length() > 0) {
                char c = text.charAt(0);
                switch (c) {
                    case '\"': 
                    case '\'': 
                    case '`': {
                        return TokenType.QUOTES;
                    }
                    case '&': 
                    case '(': 
                    case ')': 
                    case ',': 
                    case ';': 
                    case '[': 
                    case ']': 
                    case '|': {
                        return TokenType.SEPARATORS;
                    }
                }
                if (Character.isWhitespace(c)) {
                    return TokenType.SPACE;
                }
                return TokenType.WORD;
            }
            return TokenType.EMPTY;
        }
        return TokenType.OTHER;
    }

    private static boolean isWhites(NText n) {
        return n instanceof DefaultNTextPlain && Character.isWhitespace(((DefaultNTextPlain)n).getValue().charAt(0));
    }

    private static int indexOfFirstWord(List<NText> all, int from) {
        block7: for (int i = from; i < all.size(); ++i) {
            NText n = all.get(i);
            switch (BashCodeHighlighter.resolveTokenType(n).ordinal()) {
                case 0: 
                case 2: 
                case 4: {
                    continue block7;
                }
                case 1: {
                    if (i == all.size() - 1) {
                        return i;
                    }
                    NText p = all.get(i + 1);
                    switch (BashCodeHighlighter.resolveTokenType(n).ordinal()) {
                        case 2: 
                        case 4: {
                            return i;
                        }
                    }
                    continue block7;
                }
            }
        }
        return -1;
    }

    private NText[] parseCmdLine_readAntiQuotes(StringReaderExt ar, NTexts txt) {
        ArrayList<NText> all = new ArrayList<NText>();
        all.add(txt.ofStyled(String.valueOf(ar.readChar()), NTextStyle.separator()));
        boolean inLoop = true;
        boolean wasSpace = true;
        block3: while (inLoop && ar.hasNext()) {
            char c = ar.peekChar();
            switch (c) {
                case '`': {
                    wasSpace = false;
                    all.add(txt.ofStyled(String.valueOf(ar.readChar()), NTextStyle.separator()));
                    inLoop = false;
                    continue block3;
                }
            }
            wasSpace = this.parseCmdLineStep(ar, all, 1, wasSpace, txt);
        }
        return all.toArray(new NText[0]);
    }

    private NText[] parseCmdLine_readDollarPar(NWorkspace ws, StringReaderExt ar, NTexts txt) {
        ArrayList<NText> all = new ArrayList<NText>();
        all.add(txt.ofStyled(String.valueOf(ar.readChar()) + ar.readChar(), NTextStyle.separator()));
        boolean inLoop = true;
        boolean wasSpace = false;
        block3: while (inLoop && ar.hasNext()) {
            char c = ar.peekChar();
            switch (c) {
                case ')': {
                    all.add(txt.ofStyled(String.valueOf(ar.readChar()), NTextStyle.separator()));
                    inLoop = false;
                    continue block3;
                }
            }
            wasSpace = this.parseCmdLineStep(ar, all, 2, wasSpace, txt);
        }
        return all.toArray(new NText[0]);
    }

    private NText[] parseCmdLine_readDollarPar2(StringReaderExt ar, NTexts txt) {
        ArrayList<NText> all = new ArrayList<NText>();
        all.add(txt.ofStyled(String.valueOf(ar.readChar()) + ar.readChar() + ar.readChar(), NTextStyle.separator()));
        boolean inLoop = true;
        boolean wasSpace = true;
        block4: while (inLoop && ar.hasNext()) {
            char c = ar.peekChar();
            switch (c) {
                case '%': 
                case '*': 
                case '+': 
                case '-': 
                case '/': {
                    wasSpace = false;
                    all.add(txt.ofStyled(String.valueOf(ar.nextChars(2)), NTextStyle.operator()));
                    continue block4;
                }
                case ')': {
                    if (ar.peekChars(2).equals("))")) {
                        wasSpace = false;
                        all.add(txt.ofStyled(String.valueOf(ar.nextChars(2)), NTextStyle.separator()));
                        inLoop = false;
                        continue block4;
                    }
                    wasSpace = this.parseCmdLineStep(ar, all, 2, wasSpace, txt);
                    continue block4;
                }
            }
            wasSpace = this.parseCmdLineStep(ar, all, 2, wasSpace, txt);
        }
        return all.toArray(new NText[0]);
    }

    private NText[] parseCmdLine_readDollarCurlyBrackets(StringReaderExt ar, NTexts txt) {
        ArrayList<NText> all = new ArrayList<NText>();
        all.add(txt.ofStyled(String.valueOf(ar.readChar()) + ar.readChar(), NTextStyle.separator()));
        boolean inLoop = true;
        int startIndex = 0;
        boolean expectedName = true;
        boolean wasSpace = true;
        block3: while (inLoop && ar.hasNext()) {
            TokenType t;
            char c = ar.peekChar();
            switch (c) {
                case '}': {
                    all.add(txt.ofStyled(String.valueOf(ar.readChar()), NTextStyle.separator()));
                    inLoop = false;
                    continue block3;
                }
            }
            startIndex = all.size();
            wasSpace = this.parseCmdLineStep(ar, all, -1, wasSpace, txt);
            if (!expectedName) continue;
            expectedName = false;
            if (all.size() <= startIndex || (t = BashCodeHighlighter.resolveTokenType((NText)all.get(startIndex))) != TokenType.ENV && t != TokenType.WORD) continue;
            all.set(startIndex, txt.ofStyled((NText)all.get(startIndex), NTextStyle.keyword(4)));
            wasSpace = false;
        }
        return all.toArray(new NText[0]);
    }

    private NText[] parseCmdLine_readPar2(StringReaderExt ar, NTexts txt) {
        ArrayList<NText> all = new ArrayList<NText>();
        all.add(txt.ofStyled(String.valueOf(ar.readChar()) + ar.readChar(), NTextStyle.separator()));
        boolean inLoop = true;
        boolean wasSpace = true;
        block3: while (inLoop && ar.hasNext()) {
            char c = ar.peekChar();
            switch (c) {
                case ')': {
                    if (ar.peekChars(2).equals("))")) {
                        all.add(txt.ofStyled(String.valueOf(ar.nextChars(2)), NTextStyle.separator()));
                        inLoop = false;
                        continue block3;
                    }
                    wasSpace = this.parseCmdLineStep(ar, all, 2, wasSpace, txt);
                    continue block3;
                }
            }
            wasSpace = this.parseCmdLineStep(ar, all, 2, wasSpace, txt);
        }
        return all.toArray(new NText[0]);
    }

    private boolean parseCmdLineStep(StringReaderExt ar, List<NText> all, int startIndex, boolean wasSpace, NTexts txt) {
        char c = ar.peekChar();
        if (c <= ' ') {
            all.addAll(Arrays.asList(StringReaderExtUtils.readSpaces(ar)));
            return true;
        }
        switch (c) {
            case '\'': {
                all.addAll(Arrays.asList(this.parseCmdLine_readSimpleQuotes(ar, txt)));
                break;
            }
            case '`': {
                all.addAll(Arrays.asList(this.parseCmdLine_readAntiQuotes(ar, txt)));
                break;
            }
            case '\"': {
                all.addAll(Arrays.asList(this.parseCmdLine_readDoubleQuotes(ar, txt)));
                break;
            }
            case '$': {
                all.addAll(Arrays.asList(this.parseCmdLine_readDollar(ar, txt)));
                break;
            }
            case ';': {
                all.add(txt.ofStyled(String.valueOf(ar.readChar()), NTextStyle.separator()));
                break;
            }
            case ':': {
                all.add(txt.ofStyled(String.valueOf(ar.readChar()), NTextStyle.separator(2)));
                break;
            }
            case '|': {
                if (ar.peekChars(2).equals("||")) {
                    all.add(txt.ofStyled(ar.nextChars(2), NTextStyle.separator()));
                    break;
                }
                all.add(txt.ofStyled(String.valueOf(ar.readChar()), NTextStyle.separator()));
                break;
            }
            case '&': {
                if (ar.peekChars(2).equals("&&")) {
                    all.add(txt.ofStyled(ar.nextChars(2), NTextStyle.separator()));
                    break;
                }
                if (ar.peekChars(3).equals("&>>")) {
                    all.add(txt.ofStyled(ar.nextChars(3), NTextStyle.separator()));
                    break;
                }
                if (ar.peekChars(2).equals("&>")) {
                    all.add(txt.ofStyled(ar.nextChars(2), NTextStyle.separator()));
                    break;
                }
                all.add(txt.ofStyled(String.valueOf(ar.readChar()), NTextStyle.separator()));
                break;
            }
            case '>': {
                if (ar.peekChars(2).equals(">>")) {
                    all.add(txt.ofStyled(ar.nextChars(2), NTextStyle.separator()));
                    break;
                }
                if (ar.peekChars(2).equals(">&")) {
                    all.add(txt.ofStyled(ar.nextChars(2), NTextStyle.separator()));
                    break;
                }
                all.add(txt.ofStyled(String.valueOf(ar.readChar()), NTextStyle.separator()));
                break;
            }
            case '<': {
                if (ar.peekChars(2).equals("<<")) {
                    all.add(txt.ofStyled(ar.nextChars(2), NTextStyle.separator()));
                    break;
                }
                StringBuilder sb = new StringBuilder();
                sb.append(ar.peekChar(0));
                boolean ok = true;
                int i = 1;
                while (ok && ar.isAvailable(i)) {
                    char c1 = ar.peekChar(i);
                    if (c1 == '>') {
                        sb.append(c1);
                        break;
                    }
                    if (c1 == '-' || c1 == '+' || Character.isAlphabetic(c1)) {
                        sb.append(c1);
                    } else {
                        ok = false;
                    }
                    ++i;
                }
                if (sb.charAt(sb.length() - 1) != '>') {
                    ok = false;
                }
                if (ok) {
                    String s = ar.nextChars(sb.length());
                    String s0 = s.substring(1, s.length() - 1);
                    if (BashCodeHighlighter.isSynopsisOption(s0)) {
                        all.add(txt.ofStyled("<", NTextStyle.input()));
                        all.add(txt.ofStyled(s0, NTextStyle.option()));
                        all.add(txt.ofStyled(">", NTextStyle.input()));
                        break;
                    }
                    if (BashCodeHighlighter.isSynopsisWord(s0)) {
                        all.add(txt.ofStyled("<", NTextStyle.input()));
                        all.add(txt.ofStyled(s0, NTextStyle.input()));
                        all.add(txt.ofStyled(">", NTextStyle.input()));
                        break;
                    }
                    all.add(txt.ofStyled(String.valueOf(ar.readChar()), NTextStyle.separator()));
                    break;
                }
                all.add(txt.ofStyled(String.valueOf(ar.readChar()), NTextStyle.separator()));
                break;
            }
            case '(': {
                if (ar.peekChars("((")) {
                    all.addAll(Arrays.asList(this.parseCmdLine_readPar2(ar, txt)));
                } else {
                    all.add(txt.ofStyled(String.valueOf(ar.readChar()), NTextStyle.separator()));
                }
            }
            case '!': 
            case ')': 
            case '{': 
            case '}': 
            case '~': {
                all.add(txt.ofStyled(String.valueOf(ar.readChar()), NTextStyle.separator()));
                break;
            }
            case '*': 
            case '=': 
            case '?': 
            case '[': 
            case ']': {
                all.add(txt.ofStyled(String.valueOf(ar.readChar()), NTextStyle.separator()));
                break;
            }
            case '#': {
                if (wasSpace) {
                    StringBuilder sb = new StringBuilder();
                    while (ar.hasNext() && (c = ar.peekChar()) != '\n' && c != '\r') {
                        sb.append(ar.readChar());
                    }
                    all.add(txt.ofStyled(sb.toString(), NTextStyle.comments()));
                    break;
                }
                all.add(txt.ofStyled(String.valueOf(ar.readChar()), NTextStyle.separator()));
                break;
            }
            default: {
                if (startIndex >= 0) {
                    int i;
                    boolean first = all.size() == startIndex;
                    all.addAll(Arrays.asList(this.parseCmdLine_readWord(ar, txt)));
                    if (!first || (i = BashCodeHighlighter.indexOfFirstWord(all, startIndex)) < 0) break;
                    all.set(i, txt.ofStyled(all.get(i), NTextStyle.keyword()));
                    break;
                }
                all.addAll(Arrays.asList(this.parseCmdLine_readWord(ar, txt)));
            }
        }
        return false;
    }

    private NText[] parseCmdLine(String commandLineString, NTexts txt) {
        StringReaderExt ar = new StringReaderExt(commandLineString);
        ArrayList<NText> all = new ArrayList<NText>();
        boolean wasSpace = true;
        while (ar.hasNext()) {
            wasSpace = this.parseCmdLineStep(ar, all, 0, wasSpace, txt);
        }
        return all.toArray(new NText[0]);
    }

    private static boolean isSynopsisOption(String s2) {
        return s2.startsWith("--") && BashCodeHighlighter.isSynopsisWord(s2.substring(2)) || s2.startsWith("++") && BashCodeHighlighter.isSynopsisWord(s2.substring(2)) || s2.startsWith("-") && BashCodeHighlighter.isSynopsisWord(s2.substring(1)) || s2.startsWith("+") && BashCodeHighlighter.isSynopsisWord(s2.substring(1)) || s2.startsWith("--!") && BashCodeHighlighter.isSynopsisWord(s2.substring(3)) || s2.startsWith("++!") && BashCodeHighlighter.isSynopsisWord(s2.substring(3)) || s2.startsWith("-!") && BashCodeHighlighter.isSynopsisWord(s2.substring(2)) || s2.startsWith("+!") && BashCodeHighlighter.isSynopsisWord(s2.substring(2)) || s2.startsWith("--~") && BashCodeHighlighter.isSynopsisWord(s2.substring(3)) || s2.startsWith("++~") && BashCodeHighlighter.isSynopsisWord(s2.substring(3)) || s2.startsWith("-~") && BashCodeHighlighter.isSynopsisWord(s2.substring(2)) || s2.startsWith("+~") && BashCodeHighlighter.isSynopsisWord(s2.substring(2));
    }

    private static boolean isOption(String s2) {
        return s2.startsWith("-") || s2.startsWith("+");
    }

    private static boolean isSynopsisWord(String s) {
        if (s.length() > 0) {
            if (!Character.isAlphabetic(s.charAt(0))) {
                return false;
            }
            if (!Character.isAlphabetic(s.charAt(0))) {
                return false;
            }
            for (int i = 0; i < s.length(); ++i) {
                if (Character.isAlphabetic(s.charAt(i))) continue;
                if (s.charAt(i) == '-') {
                    if (s.charAt(i - 1) != '-') continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    public NText stringToText(String text, NTexts txt) {
        ArrayList<NText> all = new ArrayList<NText>();
        BufferedReader reader = new BufferedReader(new StringReader(text));
        String line = null;
        boolean first = true;
        while (true) {
            try {
                line = reader.readLine();
                if (line == null) {
                    break;
                }
            }
            catch (IOException ex) {
                throw new NIOException(ex);
            }
            if (first) {
                first = false;
            } else {
                all.add(txt.ofPlain("\n"));
            }
            all.add(this.commandToNode(line, txt));
        }
        return txt.ofList(all).simplify();
    }

    public NText next(StringReaderExt reader, boolean exitOnClosedCurlBrace, boolean exitOnClosedPar, boolean exitOnDblQuote, boolean exitOnAntiQuote, NTexts txt) {
        boolean lineStart = true;
        ArrayList<NText> all = new ArrayList<NText>();
        NTexts factory = NTexts.of();
        boolean exit = false;
        block47: while (!exit && reader.hasNext()) {
            switch (reader.peekChar()) {
                case '}': {
                    lineStart = false;
                    if (exitOnClosedCurlBrace) {
                        exit = true;
                        continue block47;
                    }
                    all.add(factory.ofStyled(reader.nextChars(1), NTextStyle.separator()));
                    continue block47;
                }
                case ')': {
                    lineStart = false;
                    if (exitOnClosedPar) {
                        exit = true;
                        continue block47;
                    }
                    all.add(factory.ofStyled(reader.nextChars(1), NTextStyle.separator()));
                    continue block47;
                }
                case '>': {
                    lineStart = false;
                    if (reader.isAvailable(2) && reader.peekChar() == '>') {
                        all.add(factory.ofStyled(reader.nextChars(2), NTextStyle.separator()));
                        continue block47;
                    }
                    all.add(factory.ofStyled(reader.nextChars(1), NTextStyle.separator()));
                    continue block47;
                }
                case '&': {
                    lineStart = false;
                    if (reader.isAvailable(2) && reader.peekChar() == '&') {
                        all.add(factory.ofStyled(reader.nextChars(2), NTextStyle.separator()));
                        continue block47;
                    }
                    if (reader.isAvailable(2) && reader.peekChar() == '>') {
                        all.add(factory.ofStyled(reader.nextChars(2), NTextStyle.separator()));
                        continue block47;
                    }
                    if (reader.isAvailable(2) && reader.peekChar() == '<') {
                        all.add(factory.ofStyled(reader.nextChars(2), NTextStyle.separator()));
                        continue block47;
                    }
                    all.add(factory.ofStyled(reader.nextChars(1), NTextStyle.separator()));
                    continue block47;
                }
                case '|': {
                    lineStart = false;
                    if (reader.isAvailable(2) && reader.peekChar() == '|') {
                        all.add(factory.ofStyled(reader.nextChars(2), NTextStyle.separator()));
                        continue block47;
                    }
                    all.add(factory.ofStyled(reader.nextChars(1), NTextStyle.separator()));
                    continue block47;
                }
                case ';': {
                    all.add(factory.ofStyled(reader.nextChars(1), NTextStyle.separator()));
                    lineStart = true;
                    continue block47;
                }
                case '\n': {
                    if (reader.isAvailable(2) && reader.peekChar() == '\r') {
                        all.add(factory.ofStyled(reader.nextChars(2), NTextStyle.separator()));
                    } else {
                        all.add(factory.ofStyled(reader.nextChars(1), NTextStyle.separator()));
                    }
                    lineStart = true;
                    continue block47;
                }
                case '<': {
                    lineStart = false;
                    StringBuilder sb = new StringBuilder();
                    if (reader.isAvailable(3)) {
                        int index = 0;
                        sb.append(reader.peekChar(index));
                        ++index;
                        boolean ok = false;
                        while (reader.isAvailable(index)) {
                            char c = reader.peekChar(index);
                            if (c == '>') {
                                sb.append(c);
                                ok = true;
                                break;
                            }
                            if (!Character.isAlphabetic(c) && c != '-') break;
                            sb.append(c);
                            ++index;
                        }
                        if (ok) {
                            reader.nextChars(sb.length());
                            all.add(factory.ofStyled(sb.toString(), NTextStyle.input()));
                            continue block47;
                        }
                        all.add(factory.ofStyled(reader.nextChars(1), NTextStyle.separator()));
                        continue block47;
                    }
                    if (reader.isAvailable(2) && reader.peekChar() == '<') {
                        all.add(factory.ofStyled(reader.nextChars(2), NTextStyle.separator()));
                        continue block47;
                    }
                    all.add(factory.ofStyled(reader.nextChars(1), NTextStyle.separator()));
                    continue block47;
                }
                case '\\': {
                    lineStart = false;
                    all.add(factory.ofStyled(reader.nextChars(2), NTextStyle.separator(2)));
                    continue block47;
                }
                case '\"': {
                    lineStart = false;
                    all.add(this.nextDoubleQuotes(reader, txt));
                    continue block47;
                }
                case '`': {
                    lineStart = false;
                    if (exitOnAntiQuote) {
                        exit = true;
                        continue block47;
                    }
                    ArrayList<NText> a = new ArrayList<NText>();
                    a.add(factory.ofStyled(reader.nextChars(1), NTextStyle.string()));
                    a.add(this.next(reader, false, false, false, true, txt));
                    if (reader.hasNext() && reader.peekChar() == '`') {
                        a.add(factory.ofStyled(reader.nextChars(1), NTextStyle.string()));
                    } else {
                        exit = true;
                    }
                    all.add(factory.ofList(a).simplify());
                    continue block47;
                }
                case '\'': {
                    lineStart = false;
                    StringBuilder sb = new StringBuilder();
                    sb.append(reader.readChar());
                    boolean end = false;
                    block49: while (!end && reader.hasNext()) {
                        switch (reader.peekChar()) {
                            case '\\': {
                                sb.append(reader.nextChars(2));
                                continue block49;
                            }
                            case '\'': {
                                sb.append(reader.readChar());
                                end = true;
                                continue block49;
                            }
                        }
                        sb.append(reader.readChar());
                    }
                    all.add(factory.ofStyled(sb.toString(), NTextStyle.string()));
                    continue block47;
                }
                case '$': {
                    lineStart = false;
                    if (reader.isAvailable(2)) {
                        char c = reader.peekChar(1);
                        switch (c) {
                            case '(': {
                                continue block47;
                            }
                            case '{': {
                                continue block47;
                            }
                            case '$': 
                            case '*': 
                            case '-': 
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': 
                            case '?': 
                            case '@': {
                                all.add(factory.ofStyled(reader.nextChars(2), NTextStyle.string()));
                                continue block47;
                            }
                        }
                        if (Character.isAlphabetic(reader.peekChar(1))) {
                            StringBuilder sb = new StringBuilder();
                            sb.append(reader.readChar());
                            while (reader.hasNext() && (Character.isAlphabetic(reader.peekChar()) || reader.peekChar() == '_')) {
                                sb.append(reader.readChar());
                            }
                            all.add(factory.ofStyled(sb.toString(), NTextStyle.variable()));
                            continue block47;
                        }
                        all.add(factory.ofStyled(reader.nextChars(1), NTextStyle.separator()));
                        continue block47;
                    }
                    all.add(factory.ofStyled(reader.nextChars(1), NTextStyle.string()));
                    continue block47;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': 
                case '!': {
                    StringBuilder whites = new StringBuilder();
                    while (reader.hasNext() && Character.isWhitespace(reader.peekChar())) {
                        whites.append(reader.readChar());
                    }
                    all.add(factory.ofPlain(whites.toString()));
                    continue block47;
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append(reader.readChar());
            while (reader.hasNext()) {
                char c2 = reader.peekChar();
                boolean accept = true;
                switch (c2) {
                    case '$': 
                    case '&': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case '<': 
                    case '>': 
                    case '?': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '{': 
                    case '|': 
                    case '}': {
                        accept = false;
                        break;
                    }
                    default: {
                        if (c2 <= ' ') {
                            accept = false;
                            break;
                        }
                        sb.append(reader.readChar());
                    }
                }
                if (accept) continue;
                break;
            }
            if (lineStart && !reader.hasNext() || Character.isWhitespace(reader.peekChar())) {
                NTextStyle keyword1 = NTextStyle.keyword(2);
                switch (sb.toString()) {
                    case "if": 
                    case "while": 
                    case "do": 
                    case "fi": 
                    case "elif": 
                    case "then": 
                    case "else": {
                        keyword1 = NTextStyle.keyword();
                        break;
                    }
                    case "cp": 
                    case "ls": 
                    case "ll": 
                    case "rm": 
                    case "pwd": 
                    case "echo": {
                        keyword1 = NTextStyle.keyword(3);
                    }
                }
                all.add(factory.ofStyled(sb.toString(), keyword1));
            } else {
                all.add(factory.ofPlain(sb.toString()));
            }
            lineStart = false;
        }
        return factory.ofList(all).simplify();
    }

    private NText nextDollar(StringReaderExt reader, NTexts txt) {
        NTexts factory = NTexts.of();
        if (reader.isAvailable(2)) {
            char c = reader.peekChar(1);
            switch (c) {
                case '(': {
                    ArrayList<NText> a = new ArrayList<NText>();
                    a.add(factory.ofStyled(reader.nextChars(1), NTextStyle.separator()));
                    a.add(this.next(reader, false, true, false, false, txt));
                    if (reader.hasNext() && reader.peekChar() == ')') {
                        a.add(factory.ofStyled(reader.nextChars(1), NTextStyle.separator()));
                    }
                    return factory.ofList(a).simplify();
                }
                case '{': {
                    ArrayList<NText> a = new ArrayList<NText>();
                    a.add(factory.ofStyled(reader.nextChars(1), NTextStyle.separator()));
                    a.add(this.next(reader, true, false, false, false, txt));
                    if (reader.hasNext() && reader.peekChar() == ')') {
                        a.add(factory.ofStyled(reader.nextChars(1), NTextStyle.separator()));
                    }
                    return factory.ofList(a).simplify();
                }
                case '$': 
                case '*': 
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case '?': 
                case '@': {
                    return factory.ofStyled(reader.nextChars(2), NTextStyle.string());
                }
            }
            if (Character.isAlphabetic(reader.peekChar(1))) {
                StringBuilder sb = new StringBuilder();
                sb.append(reader.readChar());
                while (reader.hasNext() && (Character.isAlphabetic(reader.peekChar()) || reader.peekChar() == '_')) {
                    sb.append(reader.readChar());
                }
                return factory.ofStyled(sb.toString(), NTextStyle.variable());
            }
            return factory.ofStyled(reader.nextChars(1), NTextStyle.separator());
        }
        return factory.ofStyled(reader.nextChars(1), NTextStyle.string());
    }

    public NText nextDoubleQuotes(StringReaderExt reader, NTexts txt) {
        ArrayList<NText> all = new ArrayList<NText>();
        boolean exit = false;
        StringBuilder sb = new StringBuilder();
        sb.append(reader.readChar());
        block6: while (!exit && reader.hasNext()) {
            switch (reader.peekChar()) {
                case '\\': {
                    sb.append(reader.nextChars(2));
                    continue block6;
                }
                case '\"': {
                    sb.append(reader.nextChars(1));
                    exit = true;
                    continue block6;
                }
                case '$': {
                    if (sb.length() > 0) {
                        all.add(txt.ofStyled(sb.toString(), NTextStyle.string()));
                        sb.setLength(0);
                    }
                    all.add(this.nextDollar(reader, txt));
                }
                case '`': {
                    if (sb.length() > 0) {
                        all.add(txt.ofStyled(sb.toString(), NTextStyle.string()));
                        sb.setLength(0);
                    }
                    ArrayList<NText> a = new ArrayList<NText>();
                    a.add(txt.ofStyled(reader.nextChars(1), NTextStyle.string()));
                    a.add(this.next(reader, false, false, false, true, txt));
                    if (reader.hasNext() && reader.peekChar() == '`') {
                        a.add(txt.ofStyled(reader.nextChars(1), NTextStyle.string()));
                    } else {
                        exit = true;
                    }
                    all.add(txt.ofList(a).simplify());
                    continue block6;
                }
            }
            sb.append(reader.nextChars(1));
        }
        if (sb.length() > 0) {
            all.add(txt.ofStyled(sb.toString(), NTextStyle.string()));
            sb.setLength(0);
        }
        return txt.ofList(all).simplify();
    }

    public NText commandToNode(String text, NTexts txt) {
        return txt.ofList(this.parseCmdLine(text, txt));
    }

    private static enum TokenType {
        ENV,
        WORD,
        SPACE,
        QUOTES,
        SEPARATORS,
        OTHER,
        EMPTY;

    }
}

