/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.art.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thevpc.nuts.elem.NArrayElement;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElements;
import net.thevpc.nuts.elem.NObjectElement;
import net.thevpc.nuts.elem.NPairElement;
import net.thevpc.nuts.runtime.standalone.text.art.tree.XNodeFormatter;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTreeNode;

public class XNode
implements NTreeNode {
    NText key;
    Object value;
    NText title;
    XNodeFormatter format;

    public static XNode root(Object destructedObject, NText title, XNodeFormatter format) {
        return new XNode(null, destructedObject, destructedObject instanceof List || destructedObject instanceof Map || destructedObject instanceof Map.Entry ? title : null, format);
    }

    public static XNode node(Object destructedObject, XNodeFormatter format) {
        return new XNode(null, destructedObject, null, format);
    }

    public static XNode entryNode(NText key, Object destructedObject, XNodeFormatter format) {
        return new XNode(key, destructedObject, null, format);
    }

    public XNode(NText key, Object destructedObject, NText title, XNodeFormatter format) {
        this.value = destructedObject instanceof Map && ((Map)destructedObject).size() == 1 ? ((Map)destructedObject).entrySet().toArray()[0] : (destructedObject instanceof NObjectElement && ((NObjectElement)destructedObject).size() == 1 ? ((NObjectElement)destructedObject).children().toArray()[0] : destructedObject);
        this.key = key;
        this.title = title;
        this.format = format;
    }

    public String toString() {
        return this.toNutsString().toString();
    }

    public NText toNutsString() {
        NText keyAsElement = this.format.stringValue(this.key);
        NText[] p = this.format.getMultilineArray(keyAsElement, this.value);
        if (p != null) {
            return keyAsElement;
        }
        NText _title = this.resolveTitle();
        NText titleOrValueAsElement = null;
        titleOrValueAsElement = this.getChildren() == null || this.getChildren().isEmpty() ? this.format.stringValue(_title != null ? _title : this.value) : this.format.stringValue(_title);
        if (this.key == null) {
            return titleOrValueAsElement;
        }
        if (XNode.isList(this.value) || XNode.isMap(this.value)) {
            return NTextBuilder.of().append(keyAsElement);
        }
        return NTextBuilder.of().append(keyAsElement).append("=").append(titleOrValueAsElement);
    }

    @Override
    public NText value() {
        return this.toNutsString();
    }

    private NText resolveTitle() {
        if (this.title != null) {
            return this.title;
        }
        if (XNode.isList(this.value)) {
            return null;
        }
        if (XNode.isMapEntry(this.value)) {
            if (this.value instanceof Map.Entry) {
                return this.format.stringValue(((Map.Entry)this.value).getKey());
            }
            return this.format.stringValue(((NPairElement)this.value).key());
        }
        if (XNode.isMap(this.value)) {
            // empty if block
        }
        return null;
    }

    @Override
    public List<NTreeNode> children() {
        return this.getChildren();
    }

    public List<XNode> getChildren() {
        if (this.value instanceof Map.Entry) {
            Object v = ((Map.Entry)this.value).getValue();
            return this.getAsList(v);
        }
        if (this.value instanceof NPairElement) {
            NElement v = ((NPairElement)this.value).value();
            return this.getAsList(v);
        }
        if (XNode.isList(this.value) || XNode.isMap(this.value)) {
            return this.getAsList(this.value);
        }
        return null;
    }

    private static boolean isList(Object value) {
        if (value instanceof List) {
            return true;
        }
        return value instanceof NArrayElement;
    }

    private static boolean isMapEntry(Object value) {
        if (value instanceof Map.Entry) {
            return true;
        }
        return value instanceof NPairElement;
    }

    private static boolean isMap(Object value) {
        if (value instanceof Map) {
            return true;
        }
        return value instanceof NObjectElement;
    }

    private List<XNode> getAsList(Object value) {
        if (value instanceof List) {
            return ((List)value).stream().map(me -> XNode.node(me, this.format)).collect(Collectors.toList());
        }
        if (value instanceof NArrayElement) {
            return ((NArrayElement)value).stream().map(me -> XNode.node(me, this.format)).collect(Collectors.toList());
        }
        if (value instanceof Map) {
            Map m = (Map)value;
            ArrayList<XNode> all = new ArrayList<XNode>();
            for (Map.Entry me2 : m.entrySet()) {
                NText keyStr = this.format.stringValue(me2.getKey());
                NText[] map = this.format.getMultilineArray(keyStr, me2.getValue());
                if (map == null) {
                    all.add(XNode.entryNode(keyStr, me2.getValue(), this.format));
                    continue;
                }
                all.add(XNode.entryNode(keyStr, NElements.of().toElement(Arrays.asList(map)), this.format));
            }
            return all;
        }
        if (value instanceof NObjectElement) {
            NObjectElement m = (NObjectElement)value;
            ArrayList<XNode> all = new ArrayList<XNode>();
            for (NElement e : m) {
                if (e instanceof NPairElement) {
                    NPairElement me3 = (NPairElement)e;
                    NText keyStr = this.format.stringValue(me3.key());
                    NText[] map = this.format.getMultilineArray(keyStr, me3.value());
                    if (map == null) {
                        all.add(XNode.entryNode(keyStr, me3.value(), this.format));
                        continue;
                    }
                    all.add(XNode.entryNode(keyStr, NElements.of().toElement(Arrays.asList(map)), this.format));
                    continue;
                }
                all.add(XNode.node(e, this.format));
            }
            return all;
        }
        return Arrays.asList(XNode.node(value, this.format));
    }
}

