/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.art.tree;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.runtime.standalone.text.art.tree.AsciiTreeLinkFormat;
import net.thevpc.nuts.runtime.standalone.text.art.tree.SpaceTreeLinkFormat;
import net.thevpc.nuts.runtime.standalone.text.art.tree.UnicodeTreeLinkFormat;
import net.thevpc.nuts.runtime.standalone.util.CorePlatformUtils;
import net.thevpc.nuts.text.NPositionType;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextArtTextRenderer;
import net.thevpc.nuts.text.NTextArtTreeRenderer;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTreeLinkFormat;
import net.thevpc.nuts.text.NTreeNode;
import net.thevpc.nuts.text.NTreeNodeFormat;
import net.thevpc.nuts.util.NBlankable;

public class DefaultNTextArtTreeRenderer
implements NTextArtTreeRenderer,
NTextArtTextRenderer {
    public static final NTreeLinkFormat LINK_ASCII_FORMATTER = new AsciiTreeLinkFormat();
    public static final NTreeLinkFormat LINK_SPACE_FORMATTER = new SpaceTreeLinkFormat();
    public static final NTreeLinkFormat LINK_UNICODE_FORMATTER = new UnicodeTreeLinkFormat();
    private NTreeNodeFormat formatter;
    private NTreeLinkFormat linkFormatter;
    private boolean omitRoot = false;
    private boolean infinite = false;
    private boolean omitEmptyRoot = true;
    private String name;
    private Map<String, String> multilineProperties = new HashMap<String, String>();
    public final NTreeNodeFormat TO_STRING_FORMATTER = new NTreeNodeFormat(){

        @Override
        public NText format(NTreeNode o, int depth) {
            return o == null ? NText.of("") : o.value();
        }
    };

    public DefaultNTextArtTreeRenderer(String name) {
        this.name = name;
        this.formatter = this.TO_STRING_FORMATTER;
        this.linkFormatter = CorePlatformUtils.SUPPORTS_UTF_ENCODING ? LINK_UNICODE_FORMATTER : LINK_ASCII_FORMATTER;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public DefaultNTextArtTreeRenderer setFormatter(NTreeNodeFormat formatter) {
        this.formatter = formatter == null ? this.TO_STRING_FORMATTER : formatter;
        return this;
    }

    @Override
    public boolean isInfinite() {
        return this.infinite;
    }

    @Override
    public DefaultNTextArtTreeRenderer setInfinite(boolean infinite) {
        this.infinite = infinite;
        return this;
    }

    public NTreeNodeFormat getNodeFormat() {
        return this.formatter;
    }

    @Override
    public DefaultNTextArtTreeRenderer setNodeFormat(NTreeNodeFormat formatter) {
        if (formatter == null) {
            formatter = this.TO_STRING_FORMATTER;
        }
        this.formatter = formatter;
        return this;
    }

    @Override
    public NTreeLinkFormat getLinkFormat() {
        return this.linkFormatter;
    }

    @Override
    public DefaultNTextArtTreeRenderer setLinkFormat(NTreeLinkFormat linkFormatter) {
        if (linkFormatter == null) {
            linkFormatter = LINK_ASCII_FORMATTER;
        }
        this.linkFormatter = linkFormatter;
        return this;
    }

    public boolean isEffectiveOmitRoot(NTreeNode tree) {
        if (this.isOmitRoot()) {
            return true;
        }
        if (this.omitEmptyRoot) {
            return NBlankable.isBlank(tree.value());
        }
        return false;
    }

    @Override
    public boolean isOmitRoot() {
        return this.omitRoot;
    }

    @Override
    public NTextArtTreeRenderer setOmitRoot(boolean hideRoot) {
        this.omitRoot = hideRoot;
        return this;
    }

    @Override
    public NText render(NText text) {
        return this.render(NTreeNode.of(null, NTreeNode.of(text, new NTreeNode[0])));
    }

    @Override
    public NText render(NTreeNode tree) {
        NTextBuilder out = NTextBuilder.of();
        this.print(tree, NText.ofBlank(), NPositionType.FIRST, out, this.isEffectiveOmitRoot(tree), 0, false);
        return out.build();
    }

    private boolean print(NTreeNode node, NText prefix, NPositionType type, NTextBuilder out, boolean hideRoot, int depth, boolean prefixNewLine) {
        List<NTreeNode> children;
        int i;
        if (!hideRoot) {
            List<NText> lines = node.value().split('\n', false);
            for (i = 0; i < lines.size(); ++i) {
                if (i == 0) {
                    if (prefixNewLine) {
                        out.append("\n");
                    }
                    out.append(prefix).append(this.linkFormatter.formatMain(type)).append(lines.get(i));
                    continue;
                }
                NText continuationPrefix = prefix.concat(type == NPositionType.LAST ? NText.of("    ") : this.linkFormatter.formatChild(type));
                out.append("\n").append(continuationPrefix).append(lines.get(i));
            }
            prefixNewLine = true;
        }
        if ((children = node.children()) != null && !children.isEmpty()) {
            for (i = 0; i < children.size(); ++i) {
                NTreeNode child = children.get(i);
                boolean isLast = i == children.size() - 1;
                NPositionType childType = isLast ? NPositionType.LAST : NPositionType.CENTER;
                NText childPrefix = prefix.concat(type == NPositionType.LAST ? NText.of("    ") : this.linkFormatter.formatChild(type));
                prefixNewLine |= this.print(child, childPrefix, childType, out, false, depth + 1, prefixNewLine);
            }
        }
        return prefixNewLine;
    }

    private void print(NTreeNode tree, NText prefix, NPositionType type, NTextBuilder out, boolean hideRoot, int depth) {
        List<NTreeNode> children1;
        boolean skipNewLine = true;
        if (!hideRoot) {
            out.append(prefix);
            out.append(this.linkFormatter.formatMain(type));
            out.append(this.formatter.format(tree, depth));
            skipNewLine = false;
        }
        if ((children1 = tree.children()) == null) {
            children1 = Collections.emptyList();
        }
        Iterator<NTreeNode> children = children1.iterator();
        NTreeNode last = null;
        if (children.hasNext()) {
            last = children.next();
        }
        while (children.hasNext()) {
            NTreeNode c = last;
            last = children.next();
            if (skipNewLine) {
                skipNewLine = false;
            } else {
                out.append("\n");
            }
            this.print(tree, prefix.concat(this.linkFormatter.formatChild(type)), NPositionType.CENTER, out, false, depth + 1);
        }
        if (last != null) {
            if (skipNewLine) {
                skipNewLine = false;
            } else {
                out.append("\n");
            }
        }
        this.print(tree, prefix.concat(this.linkFormatter.formatChild(type)), this.infinite && NBlankable.isBlank(prefix) ? NPositionType.CENTER : NPositionType.LAST, out, false, depth + 1);
    }

    public DefaultNTextArtTreeRenderer addMultilineProperty(String property, String separator) {
        this.multilineProperties.put(property, separator);
        return this;
    }

    public String getMultilineSeparator(NText key) {
        String sep = this.multilineProperties.get(key.toString());
        if (sep != null && sep.length() == 0) {
            sep = ":|;";
        }
        return sep;
    }

    public String toString() {
        return "DefaultNTextArtTreeRenderer(" + this.name + ")";
    }
}

