/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.art.table;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.stream.Stream;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.text.art.NTextArtImpl;
import net.thevpc.nuts.runtime.standalone.text.art.img.PixelNTextArtImageRenderer;
import net.thevpc.nuts.runtime.standalone.text.art.table.DefaultNTextArtTableRenderer;
import net.thevpc.nuts.text.NTextArtImageRenderer;
import net.thevpc.nuts.text.NTextArtRenderer;
import net.thevpc.nuts.text.NTextArtRendererFactory;
import net.thevpc.nuts.text.NTextArtTextRenderer;
import net.thevpc.nuts.util.NCollections;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NScorableContext;

public class TableNTextArtRendererFactory
implements NTextArtRendererFactory {
    String rendererType = "table";

    @Override
    public NOptional<NTextArtRenderer> load(NInputSource path) {
        try {
            return NOptional.of(new PixelNTextArtImageRenderer(path));
        }
        catch (Exception e) {
            return NOptional.ofNamedEmpty(this.rendererType + " renderer");
        }
    }

    @Override
    public NOptional<NTextArtRenderer> load(InputStream path) {
        try {
            return NOptional.of(new PixelNTextArtImageRenderer(path, null));
        }
        catch (Exception e) {
            return NOptional.ofNamedEmpty(this.rendererType + " renderer");
        }
    }

    @Override
    public Stream<NTextArtRenderer> listRenderers(Class<? extends NTextArtRenderer> rendererType) {
        if (rendererType.isAssignableFrom(NTextArtTextRenderer.class) || rendererType.isAssignableFrom(NTextArtImageRenderer.class)) {
            return this.listRenderers();
        }
        return Stream.empty();
    }

    @Override
    public Stream<NTextArtRenderer> listRenderers() {
        HashMap<Object, NTextArtRenderer> all = new HashMap<Object, NTextArtRenderer>();
        for (ClassLoader classLoader : new ClassLoader[]{Thread.currentThread().getContextClassLoader(), NTextArtImpl.class.getClassLoader()}) {
            try {
                Enumeration<URL> resources = classLoader.getResources("META-INF/textart/" + this.rendererType + ".lst");
                for (URL url : NCollections.list(resources)) {
                    for (String line : NPath.of(url).lines()) {
                        if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                        String id = this.rendererType + ":" + line;
                        this.getRenderer(id).ifPresent(x -> all.put(id, (NTextArtRenderer)x));
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (String id : new String[]{"table:default", "table:spaces", "table:simple", "table:columns", "table:rows", "table:none", "table:unicode"}) {
            all.put(id, this.getRenderer(id).get());
        }
        return all.values().stream();
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    @Override
    public NOptional<NTextArtRenderer> getRenderer(String renderName) {
        if (renderName.startsWith(this.rendererType + ":")) {
            switch (renderName) {
                case "table:default": 
                case "table:spaces": 
                case "table:simple": 
                case "table:columns": 
                case "table:rows": 
                case "table:none": 
                case "table:unicode": {
                    return NOptional.of(new DefaultNTextArtTableRenderer().setBorder(renderName.substring(this.rendererType.length() + 1)));
                }
            }
        }
        return NOptional.ofNamedEmpty(renderName);
    }
}

