/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.art.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.thevpc.nuts.runtime.standalone.text.art.table.Interval;
import net.thevpc.nuts.runtime.standalone.text.art.table.Pos;

public class Bounds {
    List<Integer> columnSize = new ArrayList<Integer>();
    List<Integer> rowSize = new ArrayList<Integer>();
    Map<Interval, Integer> columnIntervalSize = new HashMap<Interval, Integer>();
    Map<Interval, Integer> rowIntervalSize = new HashMap<Interval, Integer>();
    Set<Pos> reserved = new HashSet<Pos>();

    public void discardRow(int row) {
        Iterator<Pos> iterator = this.reserved.iterator();
        while (iterator.hasNext()) {
            Pos pos = iterator.next();
            if (pos.row != row) continue;
            iterator.remove();
        }
    }

    public boolean isReserved(int col, int row) {
        return this.reserved.contains(new Pos(col, row));
    }

    public void addReservation(int col, int row) {
        this.reserved.add(new Pos(col, row));
    }

    public void setColumnMinSize(int index, int size) {
        while (this.columnSize.size() < index + 1) {
            this.columnSize.add(0);
        }
        this.columnSize.set(index, Math.max(size, this.columnSize.get(index)));
    }

    public void setRowMinSize(int index, int size) {
        while (this.rowSize.size() < index + 1) {
            this.rowSize.add(0);
        }
        this.rowSize.set(index, Math.max(size, this.rowSize.get(index)));
    }

    public void setColumnSize(int index, int size) {
        while (this.columnSize.size() < index + 1) {
            this.columnSize.add(0);
        }
        this.columnSize.set(index, size);
    }

    public void setRowSize(int index, int size) {
        while (this.rowSize.size() < index + 1) {
            this.rowSize.add(0);
        }
        this.columnSize.set(index, size);
    }

    public void setColumnIntervalSize(int from, int to, int size) {
        if (from + 1 == to) {
            this.setColumnSize(from, size);
            return;
        }
        this.columnIntervalSize.put(new Interval(from, to), size);
    }

    public void setRowIntervalSize(int from, int to, int size) {
        if (from + 1 == to) {
            this.setRowSize(from, size);
            return;
        }
        this.rowIntervalSize.put(new Interval(from, to), size);
    }

    public void setColumnIntervalMinSize(int from, int to, int size) {
        Interval key;
        if (from + 1 == to) {
            this.setColumnMinSize(from, size);
            return;
        }
        this.columnIntervalSize.put(key, Math.max(this.columnIntervalSize.containsKey(key = new Interval(from, to)) ? this.columnIntervalSize.get(key) : 0, size));
    }

    public void setRowIntervalMinSize(int from, int to, int size) {
        Interval key;
        if (from + 1 == to) {
            this.setRowMinSize(from, size);
            return;
        }
        this.rowIntervalSize.put(key, Math.max(this.rowIntervalSize.containsKey(key = new Interval(from, to)) ? this.rowIntervalSize.get(key) : 0, size));
    }

    public int evalCharLineWidth(int col, int colspan) {
        if (colspan <= 0) {
            return 0;
        }
        if (colspan == 1) {
            return this.columnSize.get(col);
        }
        int best = 0;
        for (Map.Entry<Interval, Integer> e : this.columnIntervalSize.entrySet()) {
            int v;
            Interval interval = e.getKey();
            if (interval.from < col || interval.to > col + colspan || (v = this.evalCharLineWidth(col, interval.from - col) + e.getValue() + this.evalCharLineWidth(interval.to, col + colspan - interval.to)) <= best) continue;
            best = v;
        }
        int v = this.evalCharLineWidth(col, 1) + this.evalCharLineWidth(col + 1, colspan - 1);
        if (v > best) {
            best = v;
        }
        return best;
    }

    public int evalCharLineHeight(int row, int rowspan) {
        if (rowspan <= 0) {
            return 0;
        }
        if (rowspan == 1) {
            return this.rowSize.get(row);
        }
        int best = 0;
        for (Map.Entry<Interval, Integer> e : this.rowIntervalSize.entrySet()) {
            int v;
            Interval interval = e.getKey();
            if (interval.from < row || interval.to > row + rowspan || (v = this.evalCharLineHeight(row, interval.from - row) + e.getValue() + this.evalCharLineHeight(interval.to, row + rowspan - interval.to)) <= best) continue;
            best = v;
        }
        int v = this.evalCharLineHeight(row, 1) + this.evalCharLineHeight(row + 1, rowspan - 1);
        if (v > best) {
            best = v;
        }
        return best;
    }
}

