/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.art.region;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.thevpc.nuts.runtime.standalone.text.DefaultNTextBuilder;
import net.thevpc.nuts.runtime.standalone.text.art.region.NTextRegion;
import net.thevpc.nuts.runtime.standalone.util.CoreNUtils;
import net.thevpc.nuts.text.NPositionType;
import net.thevpc.nuts.text.NPrimitiveText;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextType;
import net.thevpc.nuts.util.NAssert;

public class NTextRegionImpl
implements NTextRegion {
    private NPrimitiveText[][] rendered;
    private int charLines;
    private int charColumns;

    private NTextRegionImpl(NPrimitiveText[][] rendered, int charColumns, int charLines) {
        this.rendered = rendered;
        this.charColumns = charColumns;
        this.charLines = charLines;
        for (NPrimitiveText[] r : rendered) {
            NAssert.requireTrue(charColumns >= r.length, "charColumns>=" + r.length);
        }
        NAssert.requireTrue(charLines == rendered.length, "charLines==" + rendered.length);
    }

    NTextRegionImpl(NPrimitiveText a, int charColumns, int charLines) {
        NAssert.requireTrue(a.length() == 1, "length==1");
        this.rendered = new NPrimitiveText[charLines][charColumns];
        this.charColumns = charColumns;
        this.charLines = charLines;
        for (int r = 0; r < charLines; ++r) {
            for (int c = 0; c < charColumns; ++c) {
                this.rendered[r][c] = a;
            }
        }
    }

    public NPrimitiveText[] charsAt(int cellLineIndex) {
        return this.rendered[cellLineIndex];
    }

    public NTextRegionImpl(NText str) {
        str = str == null ? NText.ofBlank() : str.normalize();
        ArrayList<NTextBuilder> strings = new ArrayList<NTextBuilder>();
        List<NText> st = str.split("\n", true);
        this.charColumns = 0;
        for (NText e : st) {
            if (e.type() == NTextType.PLAIN && e.isNewLine()) {
                strings.add(NTextBuilder.of());
                continue;
            }
            if (strings.isEmpty()) {
                strings.add(NTextBuilder.of());
            }
            NTextBuilder last = (NTextBuilder)strings.get(strings.size() - 1);
            last.append(e);
            this.charColumns = Math.max(this.charColumns, last.length());
        }
        this.charLines = strings.size();
        if (this.charLines == 0) {
            this.rendered = new NPrimitiveText[][]{{(NPrimitiveText)NText.ofSpace()}};
            this.charLines = 1;
            this.charColumns = 1;
        } else {
            this.rendered = new NPrimitiveText[this.charLines][];
            int stringsSize = strings.size();
            for (int i = 0; i < stringsSize; ++i) {
                NTextBuilder s = (NTextBuilder)strings.get(i);
                this.rendered[i] = s.toCharArray();
            }
        }
    }

    @Override
    public NTextRegion trimLeft() {
        int left = -1;
        if (this.rendered.length == 0) {
            return this;
        }
        for (int i = 0; i < this.rendered.length; ++i) {
            int count = 0;
            for (NPrimitiveText e : this.rendered[i]) {
                if (!e.isNewLine()) break;
                ++count;
            }
            if (left < 0 || left > count) {
                left = count;
            }
            if (left <= 0) continue;
            NPrimitiveText[][] rendered0 = new NPrimitiveText[this.rendered.length][];
            for (int j = 0; j < rendered0.length; ++j) {
                rendered0[i] = Arrays.copyOfRange(this.rendered[j], left, this.rendered[i].length);
            }
            return new NTextRegionImpl(rendered0, this.charColumns - left, this.charLines);
        }
        return this;
    }

    @Override
    public NPrimitiveText charAt(int column, int row) {
        NPrimitiveText[] u = this.rendered[row];
        if (column < u.length) {
            return u[column];
        }
        if (column < this.charColumns) {
            return (NPrimitiveText)NText.ofSpace();
        }
        return u[column];
    }

    @Override
    public NTextRegion ensureColumns() {
        NPrimitiveText[][] rendered0 = new NPrimitiveText[this.charLines][];
        for (int i = 0; i < rendered0.length; ++i) {
            DefaultNTextBuilder sb = new DefaultNTextBuilder();
            int count = 0;
            for (NPrimitiveText e : this.rendered[i]) {
                sb.append(e);
                ++count;
            }
            int remaining = this.columns() - count;
            if (remaining > 0) {
                for (int j = 0; j < remaining; ++j) {
                    sb.append(NText.ofSpace());
                }
            }
            rendered0[i] = sb.toCharArray();
        }
        return new NTextRegionImpl(rendered0, this.charColumns, rendered0.length);
    }

    @Override
    public NTextRegion concatHorizontally(NText other) {
        return this.concatHorizontally(new NTextRegionImpl(other));
    }

    @Override
    public NTextRegion concatHorizontally(NTextRegion other) {
        NPrimitiveText[][] rendered0 = new NPrimitiveText[Math.max(this.charLines, other.rows())][];
        for (int i = 0; i < rendered0.length; ++i) {
            DefaultNTextBuilder sb = new DefaultNTextBuilder();
            if (i < this.rendered.length) {
                for (NPrimitiveText e : this.rendered[i]) {
                    sb.append(e);
                }
            } else {
                for (int j = 0; j < this.charColumns; ++j) {
                    sb.append(NText.ofSpace());
                }
            }
            if (i < other.rows()) {
                sb.append(other.lineAt(i));
            } else {
                for (int j = 0; j < other.columns(); ++j) {
                    sb.append(NText.ofSpace());
                }
            }
            rendered0[i] = sb.toCharArray();
        }
        return new NTextRegionImpl(rendered0, this.charColumns + other.columns(), rendered0.length);
    }

    @Override
    public NTextRegion concatVertically(NText other) {
        return this.concatVertically(new NTextRegionImpl(other));
    }

    @Override
    public NTextRegion concatVertically(NTextRegion other) {
        int j;
        int remaining;
        DefaultNTextBuilder sb;
        int i;
        NPrimitiveText[][] rendered0 = new NPrimitiveText[this.charLines + other.rows()][];
        int cols = Math.max(this.charColumns, other.columns());
        for (i = 0; i < this.rendered.length; ++i) {
            sb = new DefaultNTextBuilder();
            sb.append(this.lineAt(i));
            remaining = cols - this.charColumns;
            if (remaining > 0) {
                for (j = 0; j < remaining; ++j) {
                    sb.append(NText.ofSpace());
                }
            }
            rendered0[i] = sb.toCharArray();
        }
        for (i = 0; i < other.rows(); ++i) {
            sb = new DefaultNTextBuilder();
            sb.append(other.lineAt(i));
            remaining = cols - other.columns();
            if (remaining > 0) {
                for (j = 0; j < remaining; ++j) {
                    sb.append(NText.ofSpace());
                }
            }
            rendered0[i + this.rendered.length] = sb.toCharArray();
        }
        return new NTextRegionImpl(rendered0, Math.max(this.charColumns, other.columns()), rendered0.length);
    }

    @Override
    public NTextRegion replaceSubRegion(NTextRegion other, int col, int row, NPositionType halign, NPositionType valign) {
        NPrimitiveText[][] rendered0 = this.resize((int)Math.max((int)this.charColumns, (int)(col + other.columns())), (int)Math.max((int)this.charLines, (int)(row + other.rows())), (NPositionType)halign, (NPositionType)valign).rendered;
        for (int r = 0; r < other.rows(); ++r) {
            for (int c = 0; c < other.columns(); ++c) {
                rendered0[row + r][col + c] = other.charAt(c, r);
            }
        }
        return new NTextRegionImpl(rendered0, this.charColumns, this.charLines);
    }

    @Override
    public NTextRegion subRegion(int col, int row, int toCol, int toRow) {
        NPrimitiveText[][] rendered0 = new NPrimitiveText[toRow - row][toCol - col];
        for (int i = 0; i < rendered0.length; ++i) {
            System.arraycopy(this.rendered[i + row], col, rendered0[i], 0, toCol - col);
        }
        return new NTextRegionImpl(rendered0, toCol - col, toRow - row);
    }

    @Override
    public NTextRegionImpl resize(int columns, int rows, NPositionType horizontalAlign, NPositionType verticalAlign) {
        NPrimitiveText[][] rendered0 = new NPrimitiveText[rows][];
        switch (verticalAlign) {
            case FIRST: {
                for (int i = 0; i < rows; ++i) {
                    if (i < this.rendered.length) {
                        NText[] chars = this.rendered[i];
                        int ll = NTextBuilder.of().appendAll(chars).length();
                        int min = Math.min(columns, ll);
                        if (min < columns) {
                            int x = columns - min;
                            NTextBuilder s = NTextBuilder.of();
                            s.appendAll(chars);
                            CoreNUtils.formatAndHorizontalAlign(s, horizontalAlign, columns);
                            rendered0[i] = s.toCharArray();
                            continue;
                        }
                        rendered0[i] = this.rendered[i];
                        continue;
                    }
                    rendered0[i] = NText.ofSpaces(columns).toCharArray();
                }
                break;
            }
            case LAST: {
                for (int i = 0; i < rows; ++i) {
                    if (i < rows - this.rendered.length) {
                        rendered0[i] = NText.ofSpaces(columns).toCharArray();
                        continue;
                    }
                    NText[] chars = this.rendered[i];
                    int ll = NTextBuilder.of().appendAll(chars).length();
                    int min = Math.min(columns, ll);
                    if (min < columns) {
                        int x = columns - min;
                        NTextBuilder s = NTextBuilder.of();
                        s.appendAll(chars);
                        CoreNUtils.formatAndHorizontalAlign(s, horizontalAlign, columns);
                        rendered0[i] = s.toCharArray();
                        continue;
                    }
                    rendered0[i] = this.rendered[i];
                }
                break;
            }
            case CENTER: {
                for (int i = 0; i < rows; ++i) {
                    if (i < this.rendered.length) {
                        NText[] chars = this.rendered[i];
                        int ll = NTextBuilder.of().appendAll(chars).length();
                        int min = Math.min(columns, ll);
                        if (min < columns) {
                            int x = columns - min;
                            NTextBuilder s = NTextBuilder.of();
                            s.appendAll(chars);
                            CoreNUtils.formatAndHorizontalAlign(s, horizontalAlign, columns);
                            rendered0[i] = s.toCharArray();
                            continue;
                        }
                        rendered0[i] = this.rendered[i];
                        continue;
                    }
                    rendered0[i] = NText.ofSpaces(columns).toCharArray();
                }
                break;
            }
        }
        return new NTextRegionImpl(rendered0, columns, rows);
    }

    public NTextRegion copy() {
        NPrimitiveText[][] rendered0 = new NPrimitiveText[this.rendered.length][];
        for (int i = 0; i < rendered0.length; ++i) {
            rendered0[i] = new NPrimitiveText[this.rendered[i].length];
            System.arraycopy(this.rendered[i], 0, rendered0[i], 0, this.rendered[i].length);
        }
        return new NTextRegionImpl(rendered0, this.charColumns, this.charLines);
    }

    @Override
    public int rows() {
        return this.charLines;
    }

    @Override
    public int columns() {
        return this.charColumns;
    }

    @Override
    public NText toText() {
        NTextBuilder sb = NTextBuilder.of();
        int renderedLength = this.rendered.length;
        for (int i = 0; i < renderedLength; ++i) {
            NPrimitiveText[] chars = this.rendered[i];
            if (i > 0) {
                sb.newLine();
            }
            sb.appendAll(Arrays.asList(chars));
        }
        return sb.build();
    }

    public String toString() {
        return this.toText().filteredText();
    }

    @Override
    public NText lineAt(int cellLineIndex) {
        return NText.ofList(this.rendered[cellLineIndex]).simplify();
    }

    @Override
    public NText columnAt(int cellColumnIndex) {
        NTextBuilder sb = NTextBuilder.of();
        for (int i = 0; i < this.rows(); ++i) {
            sb.append(this.charAt(cellColumnIndex, i));
            if (i >= this.rows() - 1) continue;
            sb.append(NText.ofNewLine());
        }
        return sb.build();
    }
}

