/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.art.img;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.ImageIcon;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementParser;
import net.thevpc.nuts.elem.NPairElement;
import net.thevpc.nuts.io.NContentMetadata;
import net.thevpc.nuts.io.NIOUtils;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextArtImageRenderer;
import net.thevpc.nuts.text.NTextArtTextRenderer;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringUtils;

public class PixelNTextArtImageRenderer
implements NTextArtImageRenderer,
NTextArtTextRenderer {
    public static final PixelNTextArtImageRenderer HASH = new PixelNTextArtImageRenderer("hash", "Monospaced", 24, false, true, new char[]{' ', '#'}, 0, 0);
    public static final PixelNTextArtImageRenderer DOT = new PixelNTextArtImageRenderer("dot", "Monospaced", 24, false, true, new char[]{' ', '.'}, 0, 0);
    public static final PixelNTextArtImageRenderer DOLLAR = new PixelNTextArtImageRenderer("dollar", "Monospaced", 24, false, true, new char[]{' ', '$'}, 0, 0);
    public static final PixelNTextArtImageRenderer STAR = new PixelNTextArtImageRenderer("star", "Monospaced", 24, false, true, new char[]{' ', '*'}, 0, 0);
    public static final PixelNTextArtImageRenderer CIPHER = new PixelNTextArtImageRenderer("cipher", "Monospaced", 24, false, true, " .'`^\",:;Il!i><~+_-?][}{1)(|\\/tfjrxnuvczXYUJCLQ0OZmwqpdbkhao*#MW&8%B@$".toCharArray(), 0, 0);
    public static final PixelNTextArtImageRenderer STANDARD = new PixelNTextArtImageRenderer("standard", "Monospaced", 24, false, true, new char[]{' ', '\u2591', '\u2592', '\u2593', '\u2588'}, 0, 0);
    private String fontName;
    private int fontSize;
    private boolean fontItalic;
    private boolean fontBold;
    private String[] lines;
    private int outputWidth;
    private int outputHeight;
    private String name;

    public PixelNTextArtImageRenderer(String name, String fontName, int fontSize, boolean fontItalic, boolean fontBold, String[] lines, int outputWidth, int outputHeight) {
        if (NBlankable.isBlank(name)) {
            name = "noname";
        }
        this.name = name.startsWith("pixel:") ? name : "pixel:" + name;
        this.fontName = NBlankable.firstNonBlank(NStringUtils.trim(fontName), "Monospaced");
        this.fontItalic = fontItalic;
        this.fontBold = fontBold;
        this.fontSize = fontSize <= 0 ? 24 : fontSize;
        this.lines = lines;
        this.outputWidth = outputWidth <= 0 ? -1 : outputWidth;
        this.outputHeight = outputHeight <= 0 ? -1 : outputHeight;
    }

    public PixelNTextArtImageRenderer(String name, String fontName, int fontSize, boolean fontItalic, boolean fontBold, char[] lines, int outputWidth, int outputHeight) {
        if (NBlankable.isBlank(name)) {
            name = "noname";
        }
        this.name = name.startsWith("pixel:") ? name : "pixel:" + name;
        this.fontName = NBlankable.firstNonBlank(NStringUtils.trim(fontName), "Monospaced");
        this.fontItalic = fontItalic;
        this.fontBold = fontBold;
        this.fontSize = fontSize <= 0 ? 24 : fontSize;
        ArrayList<String> str = new ArrayList<String>();
        for (char c : lines) {
            str.add(String.valueOf(c));
        }
        this.lines = str.toArray(new String[0]);
        this.outputWidth = outputWidth <= 0 ? -1 : outputWidth;
        this.outputHeight = outputHeight <= 0 ? -1 : outputHeight;
    }

    public PixelNTextArtImageRenderer(InputStream in) {
        this(NIOUtils.readString(in));
    }

    public PixelNTextArtImageRenderer(NInputSource file) {
        try (InputStream in = file.getInputStream();){
            if (file instanceof NPath) {
                this.fontName = ((NPath)file).nameParts().getBaseName();
            } else {
                NContentMetadata md = file.getMetaData();
                if (md != null) {
                    this.fontName = NPath.of(md.getName().orElse(null)).nameParts().getBaseName();
                }
            }
            this.load(NIOUtils.loadString(in, false));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public PixelNTextArtImageRenderer(InputStream in, String name) {
        this.fontName = name;
        this.load(NIOUtils.loadString(in, false));
    }

    @Override
    public NTextArtImageRenderer setFontSize(int fontSize) {
        if (this.fontSize == fontSize) {
            return this;
        }
        return new PixelNTextArtImageRenderer(this.name, this.fontName, fontSize, this.fontItalic, this.fontBold, this.lines, this.outputWidth, this.outputHeight);
    }

    @Override
    public NTextArtImageRenderer setFontItalic(boolean fontItalic) {
        if (this.fontItalic == fontItalic) {
            return this;
        }
        return new PixelNTextArtImageRenderer(this.name, this.fontName, this.fontSize, fontItalic, this.fontBold, this.lines, this.outputWidth, this.outputHeight);
    }

    @Override
    public NTextArtImageRenderer setFontBold(boolean fontBold) {
        if (this.fontBold == fontBold) {
            return this;
        }
        return new PixelNTextArtImageRenderer(this.name, this.fontName, this.fontSize, this.fontItalic, fontBold, this.lines, this.outputWidth, this.outputHeight);
    }

    @Override
    public NTextArtImageRenderer setFontName(String fontName) {
        if (Objects.equals(this.fontName, fontName = NBlankable.firstNonBlank(NStringUtils.trim(fontName), "Monospaced"))) {
            return this;
        }
        return new PixelNTextArtImageRenderer(this.name, fontName, this.fontSize, this.fontItalic, this.fontBold, this.lines, this.outputWidth, this.outputHeight);
    }

    @Override
    public NTextArtImageRenderer setOutputSize(int columns, int rows) {
        columns = columns <= 0 ? -1 : columns;
        int n = columns = columns <= 0 ? -1 : columns;
        if (this.outputWidth == columns && this.outputHeight == rows) {
            return this;
        }
        return new PixelNTextArtImageRenderer(this.name, this.fontName, this.fontSize, this.fontItalic, this.fontBold, this.lines, columns, rows);
    }

    @Override
    public NTextArtImageRenderer setOutputColumns(int columns) {
        return this.setOutputSize(columns, -1);
    }

    public static NOptional<PixelNTextArtImageRenderer> ofName(String name) {
        URL u;
        if (NBlankable.isBlank(name)) {
            return NOptional.of(CIPHER);
        }
        if (name.startsWith("pixel:")) {
            name = name.substring("pixel:".length());
        }
        switch (name = name.trim().toLowerCase()) {
            case "cipher": {
                return NOptional.of(CIPHER);
            }
            case "hash": {
                return NOptional.of(HASH);
            }
            case "standard": {
                return NOptional.of(STANDARD);
            }
            case "star": {
                return NOptional.of(STAR);
            }
            case "dot": {
                return NOptional.of(DOT);
            }
            case "dollar": {
                return NOptional.of(DOLLAR);
            }
        }
        try {
            u = Thread.currentThread().getContextClassLoader().getResource("META-INF/textart/" + name + ".pxl");
            if (u != null) {
                return NOptional.of(new PixelNTextArtImageRenderer(NPath.of(u).readString()));
            }
        }
        catch (Exception ex) {
            return NOptional.ofNamedEmpty(NMsg.ofC("unable to load pixel renderer %s : %s", name, ex));
        }
        try {
            u = PixelNTextArtImageRenderer.class.getClassLoader().getResource("META-INF/textart/" + name + ".pxl");
            if (u != null) {
                return NOptional.of(new PixelNTextArtImageRenderer(NPath.of(u).readString()));
            }
        }
        catch (Exception ex) {
            return NOptional.ofNamedEmpty(NMsg.ofC("unable to load pixel renderer %s : %s", name, ex));
        }
        return NOptional.ofNamedEmpty(NMsg.ofC("pixel renderer %s not found", name));
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static boolean acceptContent(String content) {
        return content != null && content.startsWith("npixel{");
    }

    public PixelNTextArtImageRenderer(String content) {
        this.load(content);
    }

    private void load(String content) {
        NElement o = NElementParser.ofTson().parse(content);
        if (!o.isNamedObject("npixel")) {
            throw new IllegalArgumentException("invalid format");
        }
        String fontName = null;
        boolean fontItalic = false;
        boolean fontBold = false;
        int fontSize = 24;
        int columns = 0;
        int rows = 0;
        String name = null;
        ArrayList<String> styleLevel = new ArrayList<String>();
        block36: for (NElement e : o.asObject().get().children()) {
            if (e.isNamedPair()) {
                NPairElement p = e.asPair().get();
                switch (p.key().asStringValue().get()) {
                    case "fontName": {
                        fontName = p.asStringValue().get();
                        break;
                    }
                    case "italic": {
                        fontItalic = p.asBooleanValue().get();
                        break;
                    }
                    case "bold": {
                        fontBold = p.asBooleanValue().get();
                        break;
                    }
                    case "name": {
                        name = p.asStringValue().get();
                        break;
                    }
                    case "fontSize": {
                        fontSize = p.asIntValue().get();
                        break;
                    }
                    case "columns": {
                        columns = p.asIntValue().get();
                        break;
                    }
                    case "rows": {
                        rows = p.asIntValue().get();
                        break;
                    }
                    case "pattern": {
                        if (p.isArray()) {
                            Object object = p.asArray().get().children().iterator();
                            while (object.hasNext()) {
                                NElement ne = (NElement)object.next();
                                String c = ne.asStringValue().get();
                                if (c.isEmpty()) {
                                    throw new IllegalArgumentException("invalid format");
                                }
                                if (styleLevel.isEmpty() && !c.equals(" ")) {
                                    styleLevel.add(" ");
                                }
                                styleLevel.add(c);
                            }
                            continue block36;
                        }
                        for (char c : p.asStringValue().get().toCharArray()) {
                            if (styleLevel.isEmpty() && c != ' ') {
                                styleLevel.add(" ");
                            }
                            styleLevel.add(String.valueOf(c));
                        }
                        continue block36;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid format");
                    }
                }
                continue;
            }
            throw new IllegalArgumentException("invalid format");
        }
        if (styleLevel.isEmpty()) {
            switch (NStringUtils.trim(name).toLowerCase()) {
                case "block": {
                    for (char c : " \u2588".toCharArray()) {
                        styleLevel.add(String.valueOf(c));
                    }
                    break;
                }
                case "star": {
                    for (char c : " *".toCharArray()) {
                        styleLevel.add(String.valueOf(c));
                    }
                    break;
                }
                case "dot": {
                    for (char c : " .".toCharArray()) {
                        styleLevel.add(String.valueOf(c));
                    }
                    break;
                }
                case "hash": {
                    for (char c : " #".toCharArray()) {
                        styleLevel.add(String.valueOf(c));
                    }
                    break;
                }
                case "simple": {
                    for (char c : " .'`^\",:;Il!i><~+_-?][}{1)(|\\/tfjrxnuvczXYUJCLQ0OZmwqpdbkhao*#MW&8%B@$".toCharArray()) {
                        styleLevel.add(String.valueOf(c));
                    }
                    break;
                }
                case "unicode": {
                    for (char c : " .:--=+\u2591\u2592\u2593\u2588".toCharArray()) {
                        styleLevel.add(String.valueOf(c));
                    }
                    break;
                }
                default: {
                    for (char c : " .'`^\",:;Il!i><~+_-?][}{1)(|\\/tfjrxnuvczXYUJCLQ0OZmwqpdbkhao*#MW&8%B@$".toCharArray()) {
                        styleLevel.add(String.valueOf(c));
                    }
                }
            }
        }
        if (NBlankable.isBlank(name)) {
            name = "noname";
        }
        this.name = name.startsWith("pixel:") ? name : "pixel:" + name;
        this.fontName = NBlankable.firstNonBlank(NStringUtils.trim(fontName), "Monospaced");
        this.fontSize = fontSize <= 0 ? 24 : fontSize;
        this.fontItalic = fontItalic;
        this.fontBold = fontBold;
        this.lines = styleLevel.toArray(new String[0]);
        this.outputWidth = columns <= 0 ? -1 : columns;
        this.outputHeight = rows <= 0 ? -1 : rows;
    }

    @Override
    public NText render(NText text) {
        String filteredText = text.filteredText();
        int fontSize = this.fontSize;
        if (fontSize <= 0) {
            fontSize = 24;
        }
        String fontName = this.fontName;
        BufferedImage tmpToCalculateTextSize = new BufferedImage(1, 1, 1);
        Graphics2D g2 = tmpToCalculateTextSize.createGraphics();
        Font font = new Font(fontName, (this.fontBold ? 1 : 0) | (this.fontItalic ? 2 : 0), fontSize);
        g2.setFont(font);
        FontMetrics fm = g2.getFontMetrics();
        int width = fm.stringWidth(filteredText) + 2;
        int height = fm.getHeight() + 2;
        g2.dispose();
        BufferedImage img = new BufferedImage(width, height, 1);
        g2 = img.createGraphics();
        g2.setFont(font);
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, width, height);
        g2.setColor(Color.BLACK);
        g2.drawString(filteredText, 1, fm.getAscent());
        g2.dispose();
        return this.render(img, d -> {
            if (this.outputWidth <= 0 && this.outputHeight <= 0) {
                return new Dimension(80, (int)(1.0 * (double)d.height * 80.0 / (double)d.width));
            }
            if (this.outputWidth <= 0) {
                return new Dimension((int)(1.0 * (double)d.width * (double)this.outputHeight / (double)d.height), this.outputHeight);
            }
            if (this.outputHeight <= 0) {
                return new Dimension(this.outputWidth, (int)(1.0 * (double)d.height * (double)this.outputWidth / (double)d.width));
            }
            return new Dimension(this.outputWidth, this.outputHeight);
        });
    }

    @Override
    public NText render(Image img) {
        return this.render(PixelNTextArtImageRenderer.toBufferedImage(img), d -> {
            if (this.outputWidth <= 0 && this.outputHeight <= 0) {
                return new Dimension(80, d.height / d.width * 80);
            }
            if (this.outputWidth <= 0) {
                return new Dimension(d.width / d.height * this.outputHeight, this.outputHeight);
            }
            if (this.outputHeight <= 0) {
                return new Dimension(this.outputWidth, d.height / d.width * this.outputWidth);
            }
            return new Dimension(this.outputWidth, this.outputHeight);
        });
    }

    public static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        img = new ImageIcon(img).getImage();
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    public BufferedImage resize(BufferedImage originalImage, int targetWidth, int targetHeight) {
        int type = originalImage.getType() == 0 ? 2 : originalImage.getType();
        BufferedImage resizedImage = new BufferedImage(targetWidth, targetHeight, type);
        Graphics2D g = resizedImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.drawImage(originalImage, 0, 0, targetWidth, targetHeight, null);
        g.dispose();
        return resizedImage;
    }

    public NText render(Image img, int width, int height) {
        return this.render(PixelNTextArtImageRenderer.toBufferedImage(img), width, height);
    }

    private NText render(BufferedImage img, Function<Dimension, Dimension> dim) {
        int rgb;
        int x;
        int y;
        Dimension d2 = dim.apply(new Dimension(img.getWidth(), img.getHeight()));
        if (d2.width != img.getWidth() || d2.height != img.getHeight()) {
            img = this.resize(img, d2.width, d2.height);
        }
        int width = img.getWidth();
        int height = img.getHeight();
        StringBuilder sb = new StringBuilder();
        int min = Integer.MAX_VALUE;
        int max = 0;
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                rgb = img.getRGB(x, y);
                int gray = (rgb >> 16 & 255 + (rgb >> 8) & 255 + (rgb & 0xFF)) / 3;
                min = Math.min(gray, min);
                max = Math.max(gray, max);
            }
        }
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                rgb = img.getRGB(x, y);
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                int gray = 255 - (int)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b);
                min = Math.min(gray, min);
                max = Math.max(gray, max);
                double grayPercent = 1.0 * (double)gray / (double)max;
                double grayPercentAbsolute = 1.0 * (double)gray / 255.0;
                NText ch = this.charFor(rgb, gray, grayPercent, grayPercentAbsolute, min, max);
                sb.append(ch);
            }
            sb.append('\n');
        }
        return NText.ofPlain(sb.toString());
    }

    private NText charFor(int rgb, int gray, double grayPercent, double grayPercentAbsolute, int minGray, int maxGray) {
        int idx = (int)Math.round(grayPercent * (double)(this.lines.length - 1));
        return NText.ofPlain(String.valueOf(this.lines[idx].charAt(0)));
    }

    public String toString() {
        return "PixelNTextArtImageRenderer(" + this.name + ')';
    }
}

