/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.art.figlet;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.io.NContentMetadata;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.text.art.figlet.FigletChar;
import net.thevpc.nuts.runtime.standalone.text.art.figlet.FigletCharSimple;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextArtTextRenderer;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringUtils;

public class FigletNTextArtTextRenderer
implements NTextArtTextRenderer,
Cloneable {
    public static final int SM_SMUSH_EQUAL = 1;
    public static final int SM_SMUSH_UNDERSCORE = 2;
    public static final int SM_SMUSH_HIERARCHY = 4;
    public static final int SM_SMUSH_PAIR = 8;
    public static final int SM_SMUSH_BIGX = 16;
    public static final int SM_SMUSH_HARDBLANK = 32;
    public static final int SM_KERN = 64;
    public static final int SM_SMUSH = 128;
    private static final int CHARS_REGULAR = 102;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int[] CHARS_POS_MAPPER = new int[102];
    private char hardBlank;
    private int height;
    private int heightWithoutDescenders;
    private int maxLine;
    private int smushingMode;
    private Map<Integer, FigletChar> chars = new HashMap<Integer, FigletChar>();
    private String fontName = "";

    public static NOptional<FigletNTextArtTextRenderer> ofName(String name) {
        URL u;
        try {
            u = Thread.currentThread().getContextClassLoader().getResource("META-INF/textart/figlet/" + name + ".flf");
            if (u != null) {
                return NOptional.of(new FigletNTextArtTextRenderer(NPath.of(u)));
            }
        }
        catch (Exception ex) {
            return NOptional.ofNamedEmpty(NMsg.ofC("font %s not found", name));
        }
        try {
            u = FigletNTextArtTextRenderer.class.getClassLoader().getResource("META-INF/textart/figlet/" + name + ".flf");
            if (u != null) {
                return NOptional.of(new FigletNTextArtTextRenderer(NPath.of(u)));
            }
        }
        catch (Exception ex) {
            return NOptional.ofNamedEmpty(NMsg.ofC("font %s not found", name));
        }
        return NOptional.ofNamedEmpty(NMsg.ofC("font %s not found", name));
    }

    public FigletNTextArtTextRenderer(NInputSource file) {
        try (InputStream in = file.getInputStream();){
            if (file instanceof NPath) {
                this.fontName = ((NPath)file).nameParts().getBaseName();
            } else {
                NContentMetadata md = file.getMetaData();
                if (md != null) {
                    this.fontName = NPath.of(md.getName().orElse(null)).nameParts().getBaseName();
                }
            }
            this.load(in);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public FigletNTextArtTextRenderer(InputStream in, String name) {
        this.fontName = name;
        this.load(in);
    }

    public static boolean acceptContent(String content) {
        return content != null && content.startsWith("flf2");
    }

    public FigletNTextArtTextRenderer(InputStream stream) {
        this.load(stream);
    }

    protected FigletNTextArtTextRenderer clone() {
        try {
            return (FigletNTextArtTextRenderer)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalArgumentException("unsupported clone");
        }
    }

    @Override
    public String getName() {
        return "figlet:" + NStringUtils.firstNonBlank(this.fontName, "noname");
    }

    private void load(InputStream stream) {
        this.chars.clear();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(stream), "UTF-8"));){
            String nextLine;
            char[][] charData;
            String line = br.readLine();
            String[] st = NStringUtils.split(line.trim(), " ").toArray(new String[0]);
            this.hardBlank = st[0].charAt(st[0].length() - 1);
            this.height = Integer.parseInt(st[1]);
            this.heightWithoutDescenders = Integer.parseInt(st[2]);
            this.maxLine = Integer.parseInt(st[3]);
            this.smushingMode = Integer.parseInt(st[4]);
            int remaining = Integer.parseInt(st[5]);
            for (int i = 0; i < remaining; ++i) {
                String[] parts;
                line = br.readLine();
                if (i != 0 || line == null || (parts = NStringUtils.split(line.trim(), " ").toArray(new String[0])).length <= 0) continue;
                this.fontName = parts[0];
            }
            for (int charPos = 0; charPos < 102; ++charPos) {
                int charCode = CHARS_POS_MAPPER[charPos];
                charData = this.readCharacterData(br);
                if (charData == null) continue;
                this.chars.put(charCode, new FigletCharSimple(charData));
            }
            while ((nextLine = br.readLine()) != null) {
                if ((nextLine = nextLine.trim()).isEmpty()) continue;
                try {
                    int charCode = this.parseInt(nextLine);
                    charData = this.readCharacterData(br);
                    if (charData == null) continue;
                    this.chars.put(charCode, new FigletCharSimple(charData));
                }
                catch (NumberFormatException e) {
                    String mappingLine;
                    if (nextLine.endsWith("@@")) continue;
                    while ((mappingLine = br.readLine()) != null) {
                        if (!mappingLine.trim().endsWith("@@")) continue;
                    }
                    continue;
                }
                {
                    break;
                }
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private char[][] readCharacterData(BufferedReader br) throws IOException {
        char[][] map = new char[this.height][];
        for (int i = 0; i < this.height; ++i) {
            String line = br.readLine();
            if (line == null) {
                return null;
            }
            map[i] = this.parseCharacterLine(line, i);
        }
        return map;
    }

    private char[] parseCharacterLine(String line, int lineIndex) {
        int endMarkCount;
        if (line == null || line.isEmpty()) {
            return new char[0];
        }
        int n = endMarkCount = lineIndex == this.height - 1 ? 2 : 1;
        if (this.height == 1) {
            endMarkCount = 1;
        }
        int charWidth = Math.max(0, line.length() - endMarkCount);
        char[] result = new char[charWidth];
        for (int j = 0; j < charWidth; ++j) {
            char c = line.charAt(j);
            result[j] = c == this.hardBlank ? 32 : (int)c;
        }
        return result;
    }

    private int parseInt(String input) {
        String codeTag;
        List<String> s = NStringUtils.split(input.trim(), " ");
        String string = codeTag = s.isEmpty() ? input : s.get(0);
        if (codeTag.matches("^0[xX][0-9A-Fa-f]+$")) {
            return Integer.parseInt(codeTag.substring(2), 16);
        }
        if (codeTag.matches("^0[0-7]+$")) {
            return Integer.parseInt(codeTag.substring(1), 8);
        }
        return Integer.parseInt(codeTag);
    }

    @Override
    public NText render(NText text) {
        String filteredText = text.filteredText();
        StringBuilder processedText = new StringBuilder();
        for (int i = 0; i < filteredText.length(); ++i) {
            char c = filteredText.charAt(i);
            if (this.chars.containsKey(c)) {
                processedText.append(c);
                continue;
            }
            if (c < ' ' || c > '~') continue;
            processedText.append(c);
        }
        String textToRender = processedText.toString();
        if (textToRender.isEmpty()) {
            return NText.of("");
        }
        NTextBuilder[] rows = new NTextBuilder[this.height];
        for (int i = 0; i < this.height; ++i) {
            rows[i] = NTextBuilder.of();
        }
        for (int c = 0; c < textToRender.length(); ++c) {
            char currentChar = textToRender.charAt(c);
            FigletChar fc = this.chars.get(currentChar);
            if (fc == null && (fc = this.chars.get(32)) == null) continue;
            for (int row = 0; row < this.height; ++row) {
                NText charRow = fc.getRow(row);
                if (c == 0) {
                    rows[row].append(charRow);
                    continue;
                }
                this.appendWithSmushing(rows[row], charRow, this.smushingMode);
            }
        }
        NTextBuilder result = NTextBuilder.of();
        for (int i = 0; i < rows.length; ++i) {
            result.append(rows[i]);
            if (i >= rows.length - 1) continue;
            result.append(LINE_SEPARATOR);
        }
        return result.build();
    }

    private void appendWithSmushing(NTextBuilder currentRow, NText newRow, int mode) {
        String current = currentRow.filteredText();
        String newText = newRow.filteredText();
        if (current.isEmpty()) {
            currentRow.append(newRow);
            return;
        }
        if (newText.isEmpty()) {
            return;
        }
        int spacing = this.calculateSpacing(current, newText, mode);
        if (spacing < 0) {
            int overlap = -spacing;
            this.performSmush(currentRow, newRow, overlap, mode);
        } else if (spacing == 0) {
            currentRow.append(newRow);
        } else {
            for (int i = 0; i < spacing; ++i) {
                currentRow.append(Character.valueOf(' '));
            }
            currentRow.append(newRow);
        }
    }

    private int calculateSpacing(String current, String newText, int mode) {
        int maxOverlap;
        if ((mode & 0xC0) == 0) {
            return 1;
        }
        for (int overlap = maxOverlap = Math.min(current.length(), newText.length()); overlap >= 1; --overlap) {
            if (!this.canOverlapAt(current, newText, overlap, mode)) continue;
            return -overlap;
        }
        if ((mode & 0x40) != 0) {
            return 0;
        }
        return 1;
    }

    private boolean canOverlapAt(String current, String newText, int overlap, int mode) {
        for (int i = 0; i < overlap; ++i) {
            char rightChar;
            char leftChar = current.charAt(current.length() - overlap + i);
            if (this.canSmushPair(leftChar, rightChar = newText.charAt(i), mode)) continue;
            return false;
        }
        return true;
    }

    private boolean canSmushPair(char left, char right, int mode) {
        String hierarchy;
        if (left == ' ' || right == ' ') {
            return true;
        }
        if ((mode & 0x80) == 0) {
            return false;
        }
        if ((mode & 1) != 0 && left == right) {
            return true;
        }
        if ((mode & 2) != 0) {
            String smushChars = "|/\\[]{}()<>";
            if (left == '_' && smushChars.indexOf(right) >= 0 || right == '_' && smushChars.indexOf(left) >= 0) {
                return true;
            }
        }
        if ((mode & 4) != 0 && (hierarchy = "|/\\[]{}()<>").indexOf(left) >= 0 && hierarchy.indexOf(right) >= 0) {
            return true;
        }
        if ((mode & 8) != 0 && (left == '[' && right == ']' || left == ']' && right == '[' || left == '{' && right == '}' || left == '}' && right == '{' || left == '(' && right == ')' || left == ')' && right == '(')) {
            return true;
        }
        if ((mode & 0x10) != 0 && (left == '/' && right == '\\' || left == '\\' && right == '/' || left == '>' && right == '<' || left == '<' && right == '>')) {
            return true;
        }
        return (mode & 0x20) != 0 && left == this.hardBlank && right == this.hardBlank;
    }

    private void performSmush(NTextBuilder currentRow, NText newRow, int overlap, int mode) {
        String current = currentRow.filteredText();
        String newText = newRow.filteredText();
        StringBuilder smushed = new StringBuilder();
        for (int i = 0; i < overlap; ++i) {
            char leftChar = current.charAt(current.length() - overlap + i);
            char rightChar = newText.charAt(i);
            smushed.append(this.smushChars(leftChar, rightChar, mode));
        }
        int currentLength = currentRow.length();
        currentRow.delete(currentLength - overlap, currentLength);
        currentRow.append(smushed.toString());
        if (overlap < newText.length()) {
            currentRow.append(newText.substring(overlap));
        }
    }

    private char smushChars(char left, char right, int mode) {
        if (left == ' ') {
            return right;
        }
        if (right == ' ') {
            return left;
        }
        if ((mode & 1) != 0 && left == right) {
            return left;
        }
        if ((mode & 2) != 0) {
            String smushChars = "|/\\[]{}()<>";
            if (left == '_' && smushChars.indexOf(right) >= 0) {
                return right;
            }
            if (right == '_' && smushChars.indexOf(left) >= 0) {
                return left;
            }
        }
        if ((mode & 4) != 0) {
            String hierarchy = "|/\\[]{}()<>";
            int leftPos = hierarchy.indexOf(left);
            int rightPos = hierarchy.indexOf(right);
            if (leftPos >= 0 && rightPos >= 0) {
                return leftPos < rightPos ? left : right;
            }
        }
        if ((mode & 8) != 0) {
            if (left == '[' && right == ']' || left == ']' && right == '[') {
                return '|';
            }
            if (left == '{' && right == '}' || left == '}' && right == '{') {
                return '|';
            }
            if (left == '(' && right == ')' || left == ')' && right == '(') {
                return '|';
            }
        }
        if ((mode & 0x10) != 0) {
            if (left == '/' && right == '\\' || left == '\\' && right == '/') {
                return '|';
            }
            if (left == '>' && right == '<' || left == '<' && right == '>') {
                return 'X';
            }
        }
        if ((mode & 0x20) != 0 && left == this.hardBlank && right == this.hardBlank) {
            return ' ';
        }
        return right;
    }

    public String toString() {
        return "FigletNTextArtTextRenderer(" + this.fontName + ')';
    }

    static {
        int j = 0;
        int c = 32;
        while (c <= 126) {
            FigletNTextArtTextRenderer.CHARS_POS_MAPPER[j++] = c++;
        }
        for (int additional : new int[]{196, 214, 220, 228, 246, 252, 223}) {
            FigletNTextArtTextRenderer.CHARS_POS_MAPPER[j++] = additional;
        }
    }
}

