/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text.art;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.thevpc.nuts.ext.NExtensions;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NTextArt;
import net.thevpc.nuts.text.NTextArtImageRenderer;
import net.thevpc.nuts.text.NTextArtRenderer;
import net.thevpc.nuts.text.NTextArtRendererFactory;
import net.thevpc.nuts.text.NTextArtTableRenderer;
import net.thevpc.nuts.text.NTextArtTextRenderer;
import net.thevpc.nuts.text.NTextArtTreeRenderer;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStream;

@NComponentScope(value=NScopeType.WORKSPACE)
public class NTextArtImpl
implements NTextArt {
    private List<NTextArtRendererFactory> factories;

    public List<NTextArtRendererFactory> getFactories() {
        if (this.factories == null) {
            this.factories = NExtensions.of().createComponents(NTextArtRendererFactory.class, null);
        }
        return this.factories;
    }

    @Override
    public List<NTextArtRenderer> getRenderers() {
        ArrayList<NTextArtRenderer> all = new ArrayList<NTextArtRenderer>();
        for (NTextArtRendererFactory factory : this.getFactories()) {
            for (NTextArtRenderer nTextArtRenderer : factory.listRenderers().collect(Collectors.toList())) {
                all.add(nTextArtRenderer);
            }
        }
        return all;
    }

    @Override
    public List<NTextArtTableRenderer> getTableRenderers() {
        return NStream.ofIterable(this.getRenderers()).instanceOf(NTextArtTableRenderer.class).toList();
    }

    @Override
    public List<NTextArtTreeRenderer> getTreeRenderers() {
        return NStream.ofIterable(this.getRenderers()).instanceOf(NTextArtTreeRenderer.class).toList();
    }

    @Override
    public List<NTextArtTextRenderer> getTextRenderers() {
        return NStream.ofIterable(this.getRenderers()).instanceOf(NTextArtTextRenderer.class).toList();
    }

    @Override
    public List<NTextArtImageRenderer> getImageRenderers() {
        return NStream.ofIterable(this.getRenderers()).instanceOf(NTextArtImageRenderer.class).collect(Collectors.toList());
    }

    @Override
    public <T extends NTextArtRenderer> List<NTextArtRenderer> getRenderers(Class<T> rendererType) {
        return NStream.ofIterable(this.getRenderers()).instanceOf(rendererType).collect(Collectors.toList());
    }

    @Override
    public NOptional<NTextArtRenderer> loadRenderer(NPath path) {
        for (NTextArtRendererFactory factory : this.getFactories()) {
            NOptional<NTextArtRenderer> p = factory.load(path);
            if (!p.isPresent()) continue;
            return p;
        }
        return NOptional.ofEmpty(NMsg.ofC("renderer file not found : %s", path));
    }

    @Override
    public NOptional<NTextArtRenderer> getDefaultRenderer() {
        return this.getRenderer("figlet:banner");
    }

    @Override
    public NOptional<NTextArtRenderer> getRenderer(String rendererName) {
        for (NTextArtRendererFactory factory : this.getFactories()) {
            NOptional<NTextArtRenderer> p = factory.getRenderer(rendererName);
            if (!p.isPresent()) continue;
            return p;
        }
        return NOptional.ofNamedEmpty(rendererName);
    }

    @Override
    public NOptional<NTextArtImageRenderer> loadImageRenderer(NPath path) {
        return this.loadRenderer(path).instanceOf(NTextArtImageRenderer.class);
    }

    @Override
    public NOptional<NTextArtImageRenderer> getImageRenderer(String rendererName) {
        return this.getRenderer(rendererName).instanceOf(NTextArtImageRenderer.class);
    }

    @Override
    public NOptional<NTextArtTextRenderer> loadTextRenderer(NPath path) {
        return this.loadRenderer(path).instanceOf(NTextArtTextRenderer.class);
    }

    @Override
    public NOptional<NTextArtTextRenderer> getTextRenderer(String rendererName) {
        return this.getRenderer(rendererName).instanceOf(NTextArtTextRenderer.class);
    }

    @Override
    public NOptional<NTextArtTableRenderer> loadTableRenderer(NPath path) {
        return this.loadRenderer(path).instanceOf(NTextArtTableRenderer.class);
    }

    @Override
    public NOptional<NTextArtTableRenderer> getTableRenderer(String rendererName) {
        return this.getRenderer(rendererName).instanceOf(NTextArtTableRenderer.class);
    }

    @Override
    public NOptional<NTextArtTreeRenderer> loadTreeRenderer(NPath path) {
        return this.loadRenderer(path).instanceOf(NTextArtTreeRenderer.class);
    }

    @Override
    public NOptional<NTextArtTreeRenderer> getTreeRenderer(String rendererName) {
        return this.getRenderer(rendererName).instanceOf(NTextArtTreeRenderer.class);
    }

    @Override
    public NOptional<NTextArtImageRenderer> getImageRenderer() {
        return this.getImageRenderer("pixel:standard").instanceOf(NTextArtImageRenderer.class);
    }

    @Override
    public NOptional<NTextArtTextRenderer> getTextRenderer() {
        return this.getTextRenderer("figlet:banner");
    }

    @Override
    public NOptional<NTextArtTableRenderer> getTableRenderer() {
        return this.getTableRenderer("table:default");
    }

    @Override
    public NOptional<NTextArtTreeRenderer> getTreeRenderer() {
        return this.getTreeRenderer("tree:default");
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }
}

