/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import java.io.IOException;
import java.io.OutputStream;
import net.thevpc.nuts.io.NTerminalMode;
import net.thevpc.nuts.runtime.standalone.io.outputstream.BaseTransparentFilterOutputStream;
import net.thevpc.nuts.runtime.standalone.io.terminal.NTerminalModeOp;
import net.thevpc.nuts.runtime.standalone.io.terminal.NTerminalModeOpUtils;
import net.thevpc.nuts.runtime.standalone.text.ExtendedFormatAware;
import net.thevpc.nuts.runtime.standalone.text.FormatOutputStream;
import net.thevpc.nuts.runtime.standalone.text.RawOutputStream;
import net.thevpc.nuts.spi.NSystemTerminalBase;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NUnsupportedEnumException;

public class UnescapeOutputStream
extends BaseTransparentFilterOutputStream
implements ExtendedFormatAware {
    private NSystemTerminalBase term;

    public UnescapeOutputStream(OutputStream out, NSystemTerminalBase term) {
        super(out);
        this.term = term;
        NTerminalModeOp t = NTerminalModeOpUtils.resolveNutsTerminalModeOp(out);
        if (t.in() != NTerminalMode.FORMATTED && t.in() != NTerminalMode.FILTERED) {
            throw new IllegalArgumentException("Illegal Formatted");
        }
    }

    @Override
    public NTerminalModeOp getModeOp() {
        return NTerminalModeOp.UNESCAPE;
    }

    public OutputStream getOut() {
        return this.out;
    }

    private String filterThanEscape(String b) throws IOException {
        NTexts txt = NTexts.of();
        String filtered = txt.ofBuilder().append(b).filteredText();
        return txt.ofPlain(filtered).toString();
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(this.filterThanEscape(Character.toString((char)b)).getBytes());
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        byte[] bytes = this.filterThanEscape(new String(b, off, len)).getBytes();
        this.out.write(bytes, 0, bytes.length);
    }

    @Override
    public ExtendedFormatAware convert(NTerminalModeOp other) {
        if (other == null || other == this.getModeOp()) {
            return this;
        }
        switch (other) {
            case NOP: {
                if (this.out instanceof ExtendedFormatAware) {
                    return ((ExtendedFormatAware)((Object)this.out)).convert(NTerminalModeOp.NOP);
                }
                return new RawOutputStream(this.out, this.term);
            }
            case FORMAT: {
                if (this.out instanceof ExtendedFormatAware) {
                    return ((ExtendedFormatAware)((Object)this.out)).convert(NTerminalModeOp.FORMAT);
                }
                return new FormatOutputStream(this.out, this.term);
            }
            case FILTER: {
                if (this.out instanceof ExtendedFormatAware) {
                    return ((ExtendedFormatAware)((Object)this.out)).convert(NTerminalModeOp.FILTER);
                }
                return this;
            }
            case ESCAPE: {
                return (ExtendedFormatAware)((Object)this.out);
            }
            case UNESCAPE: {
                return (ExtendedFormatAware)((Object)this.out);
            }
        }
        throw new NUnsupportedEnumException(other);
    }
}

