/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import java.io.OutputStream;
import net.thevpc.nuts.runtime.standalone.io.outputstream.BaseTransparentFilterOutputStream;
import net.thevpc.nuts.runtime.standalone.io.terminal.NTerminalModeOp;
import net.thevpc.nuts.runtime.standalone.text.EscapeOutputStream;
import net.thevpc.nuts.runtime.standalone.text.ExtendedFormatAware;
import net.thevpc.nuts.runtime.standalone.text.FilterFormatOutputStream;
import net.thevpc.nuts.runtime.standalone.text.FormatOutputStream;
import net.thevpc.nuts.runtime.standalone.text.UnescapeOutputStream;
import net.thevpc.nuts.spi.NSystemTerminalBase;
import net.thevpc.nuts.util.NUnsupportedEnumException;

public class RawOutputStream
extends BaseTransparentFilterOutputStream
implements ExtendedFormatAware {
    private NSystemTerminalBase term;

    public RawOutputStream(OutputStream out, NSystemTerminalBase term) {
        super(out);
        this.term = term;
    }

    @Override
    public NTerminalModeOp getModeOp() {
        return NTerminalModeOp.NOP;
    }

    @Override
    public ExtendedFormatAware convert(NTerminalModeOp other) {
        if (other == null || other == this.getModeOp()) {
            return this;
        }
        switch (other) {
            case NOP: {
                return this;
            }
            case FORMAT: {
                return new FormatOutputStream(this.out, this.term);
            }
            case FILTER: {
                return new FilterFormatOutputStream(this.out, this.term);
            }
            case ESCAPE: {
                return new EscapeOutputStream(this, this.term);
            }
            case UNESCAPE: {
                return new UnescapeOutputStream(this, this.term);
            }
        }
        throw new NUnsupportedEnumException(other);
    }
}

