/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.text.AbstractNTextNodeWriter;
import net.thevpc.nuts.runtime.standalone.text.RenderedRawStream;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNTextCommand;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNTextStyled;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNTextTitle;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.spi.NSystemTerminalBase;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextCode;
import net.thevpc.nuts.text.NTextInclude;
import net.thevpc.nuts.text.NTextLink;
import net.thevpc.nuts.text.NTextList;
import net.thevpc.nuts.text.NTextPlain;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTextStyles;
import net.thevpc.nuts.text.NTextTransformConfig;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.text.NTitleSequence;

public class NTextNodeWriterRenderer
extends AbstractNTextNodeWriter {
    private byte[] buffer = new byte[1024];
    private int bufferSize = 0;
    private boolean enableBuffering = false;
    private byte[] later = null;
    private NPrintStream rawOutput;
    private RenderedRawStream renderedRawStream = new RenderedRawStream(){

        @Override
        public NPrintStream baseOutput() {
            return NTextNodeWriterRenderer.this.rawOutput;
        }

        @Override
        public void writeRaw(byte[] buf, int off, int len) {
            NTextNodeWriterRenderer.this.writeRaw(new String(buf, off, len));
        }

        @Override
        public void writeLater(byte[] buf) {
            NTextNodeWriterRenderer.this.writeLater(buf);
        }
    };
    private NSystemTerminalBase term;

    public NTextNodeWriterRenderer(NPrintStream rawOutput, NSystemTerminalBase term) {
        this.rawOutput = rawOutput;
        this.term = term;
    }

    @Override
    public void writeNode(NText node) {
        this.writeNode(node, this.getWriteConfiguration());
    }

    @Override
    public final void writeRaw(byte[] buf, int off, int len) {
        this.rawOutput.write(buf, off, len);
    }

    @Override
    public void writeRaw(char[] buf, int off, int len) {
        this.writeRaw(new String(this.buffer, off, len));
    }

    @Override
    public final boolean flush() {
        if (this.bufferSize > 0) {
            this.rawOutput.write(this.buffer, 0, this.bufferSize);
            this.bufferSize = 0;
            return true;
        }
        this.rawOutput.flush();
        return false;
    }

    public void writeNode(NText node, NTextTransformConfig ctx) {
        this.writeNode(NTextStyles.of(new NTextStyle[0]), node, ctx, null);
    }

    private void writeNode(NTextStyles formats, NText node, NTextTransformConfig ctx, NTexts txt) {
        if (formats == null) {
            formats = NTextStyles.of(new NTextStyle[0]);
        }
        if (txt == null) {
            txt = NTexts.of();
        }
        switch (node.type()) {
            case PLAIN: {
                NTextPlain p = (NTextPlain)node;
                this.writeRaw(formats, p.getValue(), ctx.isFiltered());
                break;
            }
            case LIST: {
                NTextList s = (NTextList)node;
                for (NText n : s) {
                    this.writeNode(formats, n, ctx, txt);
                }
                break;
            }
            case BUILDER: {
                NTextBuilder s = (NTextBuilder)node;
                for (NText n : s.getChildren()) {
                    this.writeNode(formats, n, ctx, txt);
                }
                break;
            }
            case STYLED: {
                DefaultNTextStyled s = (DefaultNTextStyled)node;
                NTextStyles styles = s.getStyles();
                NTextStyles format = txt.getTheme().toBasicStyles(styles, ctx.isBasicTrueStyles());
                NTextStyles s2 = formats.append(format);
                this.writeNode(s2, s.getChild(), ctx, txt);
                break;
            }
            case TITLE: {
                DefaultNTextTitle s = (DefaultNTextTitle)node;
                NTextStyles s2 = formats.append(txt.getTheme().toBasicStyles(NTextStyles.of(NTextStyle.title(s.getLevel())), ctx.isBasicTrueStyles()));
                if (ctx.isProcessTitleNumbers()) {
                    NTitleSequence seq = ctx.getTitleNumberSequence();
                    if (seq == null) {
                        seq = txt.ofNumbering();
                        ctx.setTitleNumberSequence(seq);
                    }
                    NTitleSequence a = seq.next(s.getLevel());
                    NTextList sWithTitle = txt.ofList(txt.ofPlain(a.toString() + " "), s.getChild());
                    this.writeNode(s2, sWithTitle, ctx, txt);
                    this.writeRaw("\n");
                    break;
                }
                NTextList sWithTitle = txt.ofList(txt.ofPlain(CoreStringUtils.fillString('#', s.getLevel()) + ") "), s.getChild());
                this.writeNode(s2, sWithTitle, ctx, txt);
                this.writeRaw("\n");
                break;
            }
            case COMMAND: {
                DefaultNTextCommand s = (DefaultNTextCommand)node;
                if (this.term == null || ctx.isFiltered()) break;
                this.term.run(s.getCommand(), this.rawOutput);
                break;
            }
            case ANCHOR: {
                break;
            }
            case LINK: {
                NTextPlain child = txt.ofPlain(((NTextLink)node).getValue());
                this.writeNode(formats, txt.ofStyled((NText)child, NTextStyles.of(NTextStyle.underlined())), ctx, txt);
                this.writeRaw(formats, "see: " + ((NTextLink)node).getValue(), ctx.isFiltered());
                break;
            }
            case INCLUDE: {
                NTextPlain child = txt.ofPlain(((NTextInclude)node).getText());
                this.writeNode(formats, txt.ofStyled((NText)txt.ofList(txt.ofPlain("include: "), child), NTextStyles.of(NTextStyle.warn())), ctx, txt);
                break;
            }
            case CODE: {
                NTextCode node1 = (NTextCode)node;
                if (ctx.isFiltered()) {
                    this.writeRaw(formats, node1.getValue(), true);
                    break;
                }
                NText cn = node1.highlight();
                this.writeNode(formats, cn, ctx, txt);
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported NutsTextNode type " + node.getClass().getSimpleName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeRaw(NTextStyles format, String rawString, boolean filterFormat) {
        if (!filterFormat && format != null) {
            if (rawString.length() > 0) {
                if (format.isPlain()) {
                    this.writeRaw(rawString);
                } else {
                    this.flush();
                    if (this.term != null) {
                        this.term.setStyles(format, this.rawOutput);
                    }
                    try {
                        this.writeRaw(rawString);
                    }
                    finally {
                        if (this.term != null) {
                            this.term.setStyles(null, this.rawOutput);
                        }
                    }
                }
            }
        } else if (rawString.length() > 0) {
            this.writeRaw(rawString);
        }
    }

    public final void writeRaw(String rawString) {
        this.flushLater();
        byte[] b = rawString.getBytes();
        if (this.enableBuffering) {
            if (b.length + this.bufferSize < this.buffer.length) {
                System.arraycopy(b, 0, this.buffer, this.bufferSize, b.length);
                this.bufferSize += b.length;
            } else {
                this.flush();
                if (b.length >= this.buffer.length) {
                    this.rawOutput.write(b, 0, b.length);
                } else {
                    System.arraycopy(b, 0, this.buffer, this.bufferSize, b.length);
                    this.bufferSize += b.length;
                }
            }
        } else {
            this.rawOutput.write(b, 0, b.length);
        }
    }

    public final void writeLater(byte[] later) {
        this.later = later;
        this.rawOutput.flush();
    }

    public final void flushLater() {
        byte[] b = this.later;
        if (b != null) {
            this.later = null;
            if (this.enableBuffering) {
                if (b.length + this.bufferSize < this.buffer.length) {
                    System.arraycopy(b, 0, this.buffer, this.bufferSize, b.length);
                    this.bufferSize += b.length;
                } else {
                    this.flush();
                    if (b.length >= this.buffer.length) {
                        this.rawOutput.write(b, 0, b.length);
                    } else {
                        System.arraycopy(b, 0, this.buffer, this.bufferSize, b.length);
                        this.bufferSize += b.length;
                    }
                }
            } else {
                this.rawOutput.write(b, 0, b.length);
                this.rawOutput.flush();
            }
        }
    }

    public String toString() {
        return "Printer(" + this.rawOutput + (this.later != null ? ";withLater" : "") + ")";
    }
}

