/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import java.util.Formatter;
import net.thevpc.nuts.runtime.standalone.text.AbstractNMsgFormatHelper;
import net.thevpc.nuts.runtime.standalone.text.NFormattedTextPart;
import net.thevpc.nuts.runtime.standalone.text.NFormattedTextParts;
import net.thevpc.nuts.runtime.standalone.text.util.NTextUtils;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextPlain;
import net.thevpc.nuts.text.NTextStyled;
import net.thevpc.nuts.text.NTextType;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NIllegalArgumentException;

public class NMsgCFormatHelper
extends AbstractNMsgFormatHelper {
    int paramIndex = 0;

    public NMsgCFormatHelper(NMsg m, NTexts txt) {
        super(m, txt);
    }

    @Override
    protected NText formatPlain(String ss) {
        NFormattedTextParts r = NFormattedTextParts.parseCFormat(ss);
        NTextBuilder sb = NTextBuilder.of();
        for (NFormattedTextPart part : r.getParts()) {
            if (part.isFormat()) {
                if (part.getValue().equals("%%")) {
                    sb.append("%");
                    continue;
                }
                if (part.getValue().equals("%n")) {
                    sb.append("\n");
                    continue;
                }
                if (this.paramIndex < 0 || this.paramIndex >= this.params.length) {
                    throw new NIllegalArgumentException(NMsg.ofPlain("invalid index " + this.paramIndex + " in message (not in 0.." + (this.params.length - 1) + ")"));
                }
                Object a = this.resolvePlaceholder(this.params[this.paramIndex]);
                if (a == null) {
                    sb.append((Object)null);
                } else if (NTextUtils.isSpecialLiteral(a)) {
                    StringBuilder sb2 = new StringBuilder();
                    new Formatter(sb2, this.locale).format(part.getValue(), a);
                    sb.append(this.txt.ofStyled(sb2.toString(), NTextUtils.getSpecialLiteralType(a)));
                } else {
                    NText u = this.txt.of(a);
                    if (u.type() == NTextType.PLAIN) {
                        sb.append(NText.ofPlain(this.doFormatPlain(((NTextPlain)u).getValue(), part.getValue())));
                    } else if (u.type() == NTextType.STYLED && ((NTextStyled)u).getChild().type() == NTextType.PLAIN) {
                        sb.append(NText.ofStyled(this.doFormatPlain(((NTextPlain)((NTextStyled)u).getChild()).getValue(), part.getValue()), ((NTextStyled)u).getStyles()));
                    } else {
                        sb.append(u);
                    }
                }
                ++this.paramIndex;
                continue;
            }
            sb.append(part.getValue());
        }
        return sb.build();
    }

    private String doFormatPlain(String value, String pattern) {
        StringBuilder sb2 = new StringBuilder();
        new Formatter(sb2, this.locale).format(pattern, value == null ? "null" : value);
        return sb2.toString();
    }
}

