/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UnknownFormatConversionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.thevpc.nuts.runtime.standalone.text.NFormattedTextPart;
import net.thevpc.nuts.util.NLiteral;

public class NFormattedTextParts {
    private static Pattern CFORMAT_PATTERN = Pattern.compile("%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");
    private List<NFormattedTextPart> parts;
    private List<String> formats;
    private String type;

    public NFormattedTextParts(String type, List<NFormattedTextPart> parts) {
        this.type = type;
        this.parts = new ArrayList<NFormattedTextPart>(parts);
    }

    public NFormattedTextPart[] getParts() {
        return this.parts.toArray(new NFormattedTextPart[0]);
    }

    public static NFormattedTextParts parseJStyle(String msg) {
        if (msg == null) {
            return new NFormattedTextParts("jformat", Collections.emptyList());
        }
        ArrayList<NFormattedTextPart> al = new ArrayList<NFormattedTextPart>();
        int length = msg.length();
        char[] chars = msg.toCharArray();
        boolean inText = true;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (inText) {
                if (chars[i] == '{') {
                    if (sb.length() > 0) {
                        al.add(new NFormattedTextPart(false, sb.toString()));
                        sb.setLength(0);
                    }
                    inText = false;
                    continue;
                }
                if (chars[i] == '\\') {
                    sb.append(chars[++i]);
                    continue;
                }
                sb.append(chars[i]);
                continue;
            }
            if (chars[i] == '}') {
                al.add(new NFormattedTextPart(true, sb.toString()));
                if (sb.length() > 0) {
                    sb.setLength(0);
                }
                inText = true;
                continue;
            }
            if (chars[i] == '\\') {
                sb.append(chars[++i]);
                continue;
            }
            sb.append(chars[i]);
        }
        if (sb.length() > 0) {
            al.add(new NFormattedTextPart(!inText, sb.toString()));
            sb.setLength(0);
        }
        return new NFormattedTextParts("jformat", al);
    }

    public static NFormattedTextParts parseCFormat(String msg) {
        if (msg == null) {
            return new NFormattedTextParts("cformat", Collections.emptyList());
        }
        ArrayList<NFormattedTextPart> al = new ArrayList<NFormattedTextPart>();
        Matcher m = CFORMAT_PATTERN.matcher(msg);
        int length = msg.length();
        int i = 0;
        while (i < length) {
            if (m.find(i)) {
                if (m.start() != i) {
                    NFormattedTextParts.checkCFormatText(msg, i, m.start());
                    al.add(new NFormattedTextPart(false, msg.substring(i, m.start())));
                }
                al.add(new NFormattedTextPart(true, m.group()));
                i = m.end();
                continue;
            }
            NFormattedTextParts.checkCFormatText(msg, i, length);
            al.add(new NFormattedTextPart(false, msg.substring(i)));
            break;
        }
        return new NFormattedTextParts("cformat", al);
    }

    private static void checkCFormatText(String s, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (s.charAt(i) != '%') continue;
            char c = i == end - 1 ? (char)'%' : (char)s.charAt(i + 1);
            throw new UnknownFormatConversionException(String.valueOf(c) + " in " + s);
        }
    }

    public String getFormatAt(int index) {
        String[] formats1 = this.getFormats();
        if (index >= 0 && index < formats1.length) {
            return formats1[index];
        }
        return null;
    }

    public String getFormatFor(int index) {
        String[] formats1 = this.getFormats();
        switch (this.type) {
            case "jformat": {
                int i = 0;
                for (String s : formats1) {
                    if (s.isEmpty()) {
                        NLiteral dl;
                        if (i == index) {
                            return s;
                        }
                        int c = s.indexOf(58);
                        String d = s;
                        if (c >= 0) {
                            d = s.substring(c + 1);
                        }
                        if ((dl = NLiteral.of(d)).asInt().isPresent() && dl.asInt().get() == index) {
                            return s;
                        }
                    }
                    ++i;
                }
                return null;
            }
            case "cformat": {
                return this.getFormatAt(index);
            }
        }
        return null;
    }

    public String[] getFormats() {
        if (this.formats == null) {
            this.formats = this.parts.stream().filter(NFormattedTextPart::isFormat).map(NFormattedTextPart::getValue).collect(Collectors.toList());
        }
        return this.formats.toArray(new String[0]);
    }
}

