/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.text.NTextNodeWriter;
import net.thevpc.nuts.runtime.standalone.text.NTextNodeWriterRenderer;
import net.thevpc.nuts.runtime.standalone.text.parser.AbstractNTextNodeParserDefaults;
import net.thevpc.nuts.spi.NSystemTerminalBase;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextParser;
import net.thevpc.nuts.text.NTextTransformConfig;
import net.thevpc.nuts.text.NTextVisitor;
import net.thevpc.nuts.text.NTexts;

public class FormatOutputStreamSupport {
    private NTextNodeWriter nodeWriter;
    private NTextParser parser;
    private boolean formatEnabled = true;
    private NTextTransformConfig writeConfiguration = new NTextTransformConfig();
    private NTextVisitor nutsTextNodeVisitor = node -> this.nodeWriter.writeNode(node);

    public FormatOutputStreamSupport() {
    }

    public FormatOutputStreamSupport(NPrintStream rawOutput, NSystemTerminalBase term, boolean filtered) {
        this.parser = AbstractNTextNodeParserDefaults.createDefault();
        this.nodeWriter = new NTextNodeWriterRenderer(rawOutput, term).setWriteConfiguration(this.writeConfiguration.setFiltered(false));
        this.writeConfiguration.setFiltered(filtered);
    }

    public NTextParser getParser() {
        return this.parser;
    }

    public FormatOutputStreamSupport setParser(NTextParser parser) {
        this.parser = parser == null ? NTexts.of().parser() : parser;
        return this;
    }

    public boolean isFormatEnabled() {
        return this.formatEnabled;
    }

    public FormatOutputStreamSupport setFormatEnabled(boolean formatEnabled) {
        this.formatEnabled = formatEnabled;
        this.writeConfiguration.setFiltered(!formatEnabled);
        return this;
    }

    public void processByte(int oneByte) {
        this.processBytes(new byte[]{(byte)oneByte}, 0, 1);
    }

    public void writeRaw(byte[] buf, int off, int len) {
        this.nodeWriter.writeRaw(buf, off, len);
    }

    public void processBytes(byte[] buf, int off, int len) {
        if (!this.isFormatEnabled()) {
            this.nodeWriter.writeRaw(buf, off, len);
        } else {
            this.parser.parseIncremental(buf, off, len, new NTextVisitor(){

                @Override
                public void visit(NText node) {
                    FormatOutputStreamSupport.this.nutsTextNodeVisitor.visit(node);
                }
            });
        }
    }

    public void pushNode(NText node) {
        this.flush();
        this.nutsTextNodeVisitor.visit(node);
    }

    public void processChars(char[] buf, int off, int len) {
        if (!this.isFormatEnabled()) {
            this.nodeWriter.writeRaw(buf, off, len);
        } else {
            this.parser.parseIncremental(buf, off, len, new NTextVisitor(){

                @Override
                public void visit(NText node) {
                    FormatOutputStreamSupport.this.nutsTextNodeVisitor.visit(node);
                }
            });
        }
    }

    public void reset() {
        this.flush();
    }

    public void flush() {
        this.nodeWriter.flush();
        this.parser.parseRemaining(this.nutsTextNodeVisitor);
        this.nodeWriter.flush();
    }

    public boolean isIncomplete() {
        return this.parser.isIncomplete();
    }

    public String toString() {
        return "FormatOutputStreamSupport(" + this.parser.toString() + ";" + this.nodeWriter + ")";
    }
}

